/*
 * Decompiled with CFR 0.152.
 */
package net.stardustlabs.zcavetweaksforge.mixins;

import java.util.ArrayList;
import net.minecraft.core.Registry;
import net.minecraft.util.Mth;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.PositionalRandomFactory;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.blending.Blender;
import net.minecraft.world.level.levelgen.synth.NoiseUtils;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import net.stardustlabs.zcavetweaksforge.ZCaveTweaksForge;
import net.stardustlabs.zcavetweaksforge.config.CaveTweaksConfig;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NoiseSampler.class})
public abstract class NoiseSamplerMixin {
    private static Registry<NormalNoise.NoiseParameters> registry = null;
    private NormalNoise entranceLayer;
    private NormalNoise noodleDistortX;
    private NormalNoise noodleDistortY;
    private NormalNoise noodleDistortZ;
    private NormalNoise spaghettiClamp;
    private NormalNoise layerDistort;
    private NormalNoise spaghettiXFactor;
    private NormalNoise spaghettiYFactor;
    private NormalNoise spaghettiZFactor;
    private NormalNoise spaghettiDistortFactor;
    private NormalNoise spaghettiShapeDistort;
    private NormalNoise spaghettiShapeDistort2;
    private NormalNoise spaghettiShapeDistortFactor;
    private NormalNoise spaghettiDistortModulator;
    public ArrayList<Double> noiseData = new ArrayList();
    @Shadow
    protected final NormalNoise f_188905_;
    @Shadow
    protected final NormalNoise f_188948_;
    @Shadow
    protected final NormalNoise f_188906_;
    final boolean ENABLE_SPAGHETTI_2D = CaveTweaksConfig.CaveConfig.GlobalToggleConfig.ENABLE_SPAGHETTI_2D.getValue();
    final boolean ENABLE_SPAGHETTI_3D = CaveTweaksConfig.CaveConfig.GlobalToggleConfig.ENABLE_SPAGHETTI_3D.getValue();
    final boolean ENABLE_CHEESE = CaveTweaksConfig.CaveConfig.GlobalToggleConfig.ENABLE_CHEESE.getValue();
    final boolean ENABLE_BIG_ENTRANCE = CaveTweaksConfig.CaveConfig.GlobalToggleConfig.ENABLE_BIG_ENTRANCE.getValue();
    final double SPAGHETTI_SURFACE_EXPAND_FACTOR = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_EXPAND_FACTOR.getValue();
    final double SPAGHETTI_SURFACE_CONTRACT_FACTOR = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_CONTRACT_FACTOR.getValue();
    final double SPAGHETTI_SURFACE_PRIMARY_OFFSET = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_PRIMARY_OFFSET.getValue();
    final double SPAGHETTI_SURFACE_SECONDARY_OFFSET = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_SECONDARY_OFFSET.getValue();
    final double SPAGHETTI_SURFACE_SAUCE_AMOUNT = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_SAUCE_AMOUNT.getValue();
    final int SPAGHETTI_SURFACE_START_DEPTH = CaveTweaksConfig.CaveConfig.SpaghettiSurfaceConfig.SPAGHETTI_SURFACE_START_DEPTH.getValue();
    final double BONUS_FACTOR = CaveTweaksConfig.CaveConfig.CaveEntranceConfig.ENTRANCE_BONUS_FACTOR.getValue();
    final double LIMITING_FACTOR = CaveTweaksConfig.CaveConfig.CaveEntranceConfig.ENTRANCE_LIMITING_FACTOR.getValue();
    final double NOISE_FACTOR = CaveTweaksConfig.CaveConfig.CaveEntranceConfig.ENTRANCE_NOISE_FACTOR.getValue();
    final double LAYER_FACTOR = CaveTweaksConfig.CaveConfig.CaveEntranceConfig.ENTRANCE_LAYER_FACTOR.getValue();
    final double SPAGHETTI_TWIST_VANILLA_BIAS = CaveTweaksConfig.CaveConfig.SpaghettiTwistConfig.SPAGHETTI_TWIST_VANILLA_BIAS.getValue();
    final double SPAGHETTI_TWIST_BIAS_POWER = CaveTweaksConfig.CaveConfig.SpaghettiTwistConfig.SPAGHETTI_TWIST_BIAS_POWER.getValue();
    final double SPAGHETTI_TWIST_MODULATOR_SCALE = CaveTweaksConfig.CaveConfig.SpaghettiTwistConfig.SPAGHETTI_TWIST_MODULATOR_SCALE.getValue();
    final double SPAGHETTI_TWIST_LIMITER = CaveTweaksConfig.CaveConfig.SpaghettiTwistConfig.SPAGHETTI_TWIST_LIMITER.getValue();
    final double SPAGHETTI_TWIST_BONUS_FACTOR = CaveTweaksConfig.CaveConfig.SpaghettiTwistConfig.SPAGHETTI_TWIST_BONUS_FACTOR.getValue();
    Logger LOGGER = LogManager.getLogger((String)"cavetweaks");
    int count = 0;
    double precise_entrance = 2.0;
    final boolean ENTRANCE_REDUCE_PILLARS = CaveTweaksConfig.CaveConfig.CaveEntranceConfig.ENTRANCE_REDUCE_PILLARS.getValue();
    final double ENTRANCE_PILLAR_THRESHOLD = 0.075;
    final double ENTRANCE_PILLAR_REDUCTION_FACTOR = 5.0;
    final double ENTRANCE_MAX_PILLAR_REDUCTION = 0.6;

    protected NoiseSamplerMixin(NormalNoise caveEntranceNoise, NormalNoise pillarRarenessNoise, NormalNoise caveCheeseNoise) {
        this.f_188905_ = caveEntranceNoise;
        this.f_188948_ = pillarRarenessNoise;
        this.f_188906_ = caveCheeseNoise;
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void get_randomness(NoiseSettings config, boolean hasNoiseCaves, long seed, Registry noiseRegistry, WorldgenRandom.Algorithm randomProvider, CallbackInfo ci) {
        PositionalRandomFactory randomDeriver = randomProvider.m_190084_(seed).m_183423_();
        this.entranceLayer = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.ENTRANCE_LAYER);
        this.noodleDistortX = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.NOODLE_DISTORT_X);
        this.noodleDistortY = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.NOODLE_DISTORT_Y);
        this.noodleDistortZ = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.NOODLE_DISTORT_Z);
        this.spaghettiClamp = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_CLAMP);
        this.layerDistort = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.LAYER_DISTORT);
        this.spaghettiXFactor = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_X_FACTOR);
        this.spaghettiYFactor = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_Y_FACTOR);
        this.spaghettiZFactor = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_Z_FACTOR);
        this.spaghettiDistortFactor = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_DISTORT_FACTOR);
        this.spaghettiShapeDistort = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_SHAPE_DISTORT);
        this.spaghettiShapeDistort2 = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_SHAPE_DISTORT_2);
        this.spaghettiShapeDistortFactor = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_SHAPE_DISTORT_FACTOR);
        this.spaghettiDistortModulator = ZCaveTweaksForge.createNoiseSampler((Registry<NormalNoise.NoiseParameters>)noiseRegistry, randomDeriver, ZCaveTweaksForge.SPAGHETTI_DISTORT_MODULATOR);
    }

    @Shadow
    protected abstract double m_189102_(int var1, int var2, int var3);

    @Shadow
    protected abstract double m_189089_(double var1, double var3, double var5);

    @Shadow
    protected abstract double m_189111_(int var1, int var2, int var3);

    @Shadow
    protected abstract double m_188981_(int var1, int var2, int var3, TerrainInfo var4, double var5, boolean var7, boolean var8, Blender var9);

    @Inject(method={"getSpaghetti2D"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancel_2D(int x, int y, int z, CallbackInfoReturnable<Double> cir) {
        if (!this.ENABLE_SPAGHETTI_2D) {
            cir.setReturnValue((Object)1.0);
            cir.cancel();
        }
    }

    @Inject(method={"getSpaghetti3D"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancel_3D(int x, int y, int z, CallbackInfoReturnable<Double> cir) {
        if (!this.ENABLE_SPAGHETTI_3D) {
            cir.setReturnValue((Object)1.0);
            cir.cancel();
        }
    }

    @Inject(method={"getBigEntrances(III)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancel_entrance(int x, int y, int z, CallbackInfoReturnable<Double> cir) {
        if (!this.ENABLE_BIG_ENTRANCE) {
            cir.setReturnValue((Object)5.0);
            cir.cancel();
        }
    }

    @Inject(method={"getLayerizedCaverns"}, at={@At(value="RETURN")}, cancellable=true)
    private void cancel_cheese(int x, int y, int z, CallbackInfoReturnable<Double> cir) {
        if (!this.ENABLE_CHEESE) {
            cir.setReturnValue((Object)64.0);
            cir.cancel();
        }
    }

    @ModifyVariable(method={"calculateBaseNoise(IIILnet/minecraft/world/level/levelgen/TerrainInfo;DZZLnet/minecraft/world/level/levelgen/blending/Blender;)D"}, at=@At(value="STORE"), index=31)
    private double spaghetti_surface_clamp(double p, int x, int y, int z, TerrainInfo point, double noise, boolean hasNoNoiseCaves, boolean bl, Blender blender) {
        double spaghettix = p;
        double p_depth = 0.0;
        double pre_factor = 2.0 * this.spaghettiClamp.m_75380_((double)x, (double)y, (double)z) + this.SPAGHETTI_SURFACE_PRIMARY_OFFSET;
        double sign = pre_factor < 0.0 ? this.SPAGHETTI_SURFACE_EXPAND_FACTOR : this.SPAGHETTI_SURFACE_CONTRACT_FACTOR;
        double clamp_factor = Mth.m_14008_((double)(sign * pre_factor * pre_factor + this.SPAGHETTI_SURFACE_SECONDARY_OFFSET), (double)-1.0, (double)1.0);
        p_depth = point.f_190011_();
        p_depth = p_depth * 128.0 + 128.0;
        return spaghettix += this.SPAGHETTI_SURFACE_SAUCE_AMOUNT * clamp_factor * Math.max(0.0, (double)y - (p_depth - (double)this.SPAGHETTI_SURFACE_START_DEPTH));
    }

    @ModifyVariable(method={"getSpaghetti3D"}, at=@At(value="STORE"), ordinal=5)
    private double spaghetti_shape_distort(double ix, int x, int y, int z) {
        double preDistortFactor;
        double distortFactor = Math.pow(Mth.m_14008_((double)(this.spaghettiShapeDistortFactor.m_75380_((double)x, (double)y, (double)z) + this.SPAGHETTI_TWIST_VANILLA_BIAS), (double)0.0, (double)1.0), this.SPAGHETTI_TWIST_BIAS_POWER);
        double modulatorValue = this.spaghettiDistortModulator.m_75380_((double)x, (double)y, (double)z);
        if (modulatorValue < -0.4) {
            preDistortFactor = this.spaghettiShapeDistort.m_75380_((double)(x * 2), (double)(y * 2), (double)(z * 2));
        } else if (modulatorValue >= -0.4 && modulatorValue < -0.25) {
            double redFactor = Mth.m_144914_((double)modulatorValue, (double)-0.4, (double)-0.25, (double)1.0, (double)0.0);
            double greenFactor = Mth.m_144914_((double)modulatorValue, (double)-0.4, (double)-0.25, (double)0.0, (double)1.0);
            preDistortFactor = redFactor * this.spaghettiShapeDistort.m_75380_((double)x * this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y * this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z * this.SPAGHETTI_TWIST_MODULATOR_SCALE) + greenFactor * this.spaghettiShapeDistort.m_75380_((double)x, (double)y, (double)z);
        } else if (modulatorValue >= -0.25 && modulatorValue < 0.25) {
            preDistortFactor = this.spaghettiShapeDistort.m_75380_((double)x, (double)y, (double)z);
        } else if (modulatorValue >= 0.25 && modulatorValue < 0.4) {
            double greenFactor = Mth.m_144914_((double)modulatorValue, (double)0.25, (double)0.4, (double)1.0, (double)0.0);
            double blueFactor = Mth.m_144914_((double)modulatorValue, (double)0.25, (double)0.4, (double)0.0, (double)1.0);
            preDistortFactor = greenFactor * this.spaghettiShapeDistort.m_75380_((double)x, (double)y, (double)z) + blueFactor * this.spaghettiShapeDistort.m_75380_((double)x / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z / this.SPAGHETTI_TWIST_MODULATOR_SCALE);
        } else {
            preDistortFactor = this.spaghettiShapeDistort.m_75380_((double)x / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z / this.SPAGHETTI_TWIST_MODULATOR_SCALE);
        }
        double noiseModifier = this.SPAGHETTI_TWIST_LIMITER * preDistortFactor * distortFactor;
        double bonusFactor = Mth.m_14008_((double)(1.0 - this.SPAGHETTI_TWIST_BONUS_FACTOR * Math.abs(noiseModifier)), (double)0.4, (double)1.0);
        return (ix *= bonusFactor) + noiseModifier;
    }

    @ModifyVariable(method={"getSpaghetti3D"}, at=@At(value="STORE"), ordinal=7)
    private double spaghetti2_shape_distort(double ix, int x, int y, int z) {
        double preDistortFactor;
        double distortFactor = Math.pow(Mth.m_14008_((double)(this.spaghettiShapeDistortFactor.m_75380_((double)x, (double)y, (double)z) + this.SPAGHETTI_TWIST_VANILLA_BIAS), (double)0.0, (double)1.0), this.SPAGHETTI_TWIST_BIAS_POWER);
        double modulatorValue = this.spaghettiDistortModulator.m_75380_((double)x, (double)y, (double)z);
        if (modulatorValue < -0.4) {
            preDistortFactor = this.spaghettiShapeDistort2.m_75380_((double)(x * 2), (double)(y * 2), (double)(z * 2));
        } else if (modulatorValue >= -0.4 && modulatorValue < -0.25) {
            double redFactor = Mth.m_144914_((double)modulatorValue, (double)-0.4, (double)-0.25, (double)1.0, (double)0.0);
            double greenFactor = Mth.m_144914_((double)modulatorValue, (double)-0.4, (double)-0.25, (double)0.0, (double)1.0);
            preDistortFactor = redFactor * this.spaghettiShapeDistort2.m_75380_((double)x * this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y * this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z * this.SPAGHETTI_TWIST_MODULATOR_SCALE) + greenFactor * this.spaghettiShapeDistort2.m_75380_((double)x, (double)y, (double)z);
        } else if (modulatorValue >= -0.25 && modulatorValue < 0.25) {
            preDistortFactor = this.spaghettiShapeDistort2.m_75380_((double)x, (double)y, (double)z);
        } else if (modulatorValue >= 0.25 && modulatorValue < 0.4) {
            double greenFactor = Mth.m_144914_((double)modulatorValue, (double)0.25, (double)0.4, (double)1.0, (double)0.0);
            double blueFactor = Mth.m_144914_((double)modulatorValue, (double)0.25, (double)0.4, (double)0.0, (double)1.0);
            preDistortFactor = greenFactor * this.spaghettiShapeDistort2.m_75380_((double)x, (double)y, (double)z) + blueFactor * this.spaghettiShapeDistort2.m_75380_((double)x / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z / this.SPAGHETTI_TWIST_MODULATOR_SCALE);
        } else {
            preDistortFactor = this.spaghettiShapeDistort2.m_75380_((double)x / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)y / this.SPAGHETTI_TWIST_MODULATOR_SCALE, (double)z / this.SPAGHETTI_TWIST_MODULATOR_SCALE);
        }
        double noiseModifier = this.SPAGHETTI_TWIST_LIMITER * preDistortFactor * distortFactor;
        double bonusFactor = Mth.m_14008_((double)(1.0 - this.SPAGHETTI_TWIST_BONUS_FACTOR * Math.abs(noiseModifier)), (double)0.4, (double)1.0);
        return (ix *= bonusFactor) + noiseModifier;
    }

    @Inject(method={"getBigEntrances(III)D"}, at={@At(value="RETURN")}, cancellable=true)
    private void meme_38993(int x, int y, int z, CallbackInfoReturnable<Double> cir) {
        if (this.ENABLE_CHEESE) {
            double pr_entrance = (Double)cir.getReturnValue();
            double pre_w_factor = Mth.m_14008_((double)(this.entranceLayer.m_75380_((double)x, (double)y, (double)z) * this.NOISE_FACTOR + 0.175), (double)0.0, (double)1.0);
            cir.setReturnValue((Object)(pr_entrance - pre_w_factor * this.BONUS_FACTOR + Mth.m_14008_((double)(pre_w_factor * this.LIMITING_FACTOR * Math.pow(this.m_189102_(x * 2, y * 2, z * 2), this.LAYER_FACTOR)), (double)0.0, (double)0.3)));
            cir.cancel();
        }
    }

    @ModifyVariable(method={"getPillars"}, at=@At(value="STORE"), ordinal=2)
    private double injected(double d, int x, int y, int z) {
        double hx = d;
        double precise_entrance = this.retrieveCaveEntranceNoise(x, y, z);
        double modified_value = precise_entrance < 0.075 && this.ENTRANCE_REDUCE_PILLARS ? hx - Math.max(-0.6, 5.0 * (precise_entrance - 0.075)) : hx;
        return modified_value;
    }

    private double retrieveCaveEntranceNoise(int x, int y, int z) {
        double g = NoiseUtils.m_164337_((NormalNoise)this.f_188905_, (double)((double)x * 0.75), (double)((double)y * 0.5), (double)((double)z * 0.75), (double)-1.0, (double)1.0) + 0.37;
        double h = (double)(y - -10) / 40.0;
        return g + Mth.m_14085_((double)0.3, (double)0.0, (double)h);
    }
}

