/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.gen;

import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;

public class DETerrainAnalyzer {
    public static Settings defaultCheckSettings = new Settings(1, 3, 3);
    protected static ChunkGenerator chunkGenerator;
    protected static LevelHeightAccessor heightAccessor;

    public static boolean isFlatEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, LevelHeightAccessor heightAccessor) {
        return DETerrainAnalyzer.isFlatEnough(chunkPos, chunkGenerator, defaultCheckSettings, heightAccessor);
    }

    public static boolean isFlatEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, Settings settings, LevelHeightAccessor heightAccessor) {
        int z;
        int y;
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        int x = chunkPos.m_45604_();
        if (DETerrainAnalyzer.getBlockAt(x, (y = chunkGenerator.m_142647_(x, z = chunkPos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor)) - 1, z).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        int columSpreading = settings.columSpreading();
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x + columSpreading, y, z), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x - columSpreading, y, z), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x, y, z + columSpreading), settings)) {
            return false;
        }
        return !DETerrainAnalyzer.isColumBlocked(new BlockPos(x, y, z - columSpreading), settings);
    }

    public static boolean isUnderwater(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int depth, LevelHeightAccessor heightAccessor) {
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        return DETerrainAnalyzer.getBlockAt(x, chunkGenerator.m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor) + depth, z).m_60713_(Blocks.f_49990_);
    }

    public static boolean isGroundHighEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int height, LevelHeightAccessor heightAccessor) {
        int z;
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        int x = chunkPos.m_45604_();
        int y = chunkGenerator.m_142647_(x, z = chunkPos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
        return y >= chunkGenerator.m_142062_() + height;
    }

    public static boolean isGroundLowEnough(ChunkPos chunkPos, ChunkGenerator chunkGenerator, int freeBlocks, LevelHeightAccessor heightAccessor) {
        int z;
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        int x = chunkPos.m_45604_();
        int y = chunkGenerator.m_142647_(x, z = chunkPos.m_45605_(), Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
        return y <= chunkGenerator.m_142062_() + chunkGenerator.m_6331_() - freeBlocks;
    }

    public static boolean areNearbyBiomesValid(BiomeSource biomeSource, ChunkPos chunkPos, ChunkGenerator generator, int radius, Predicate<Holder<Biome>> validBiome) {
        chunkGenerator = generator;
        for (Holder biome : biomeSource.m_183399_(chunkPos.m_45604_(), generator.m_6337_(), chunkPos.m_45605_(), radius, generator.m_183403_())) {
            if (validBiome.test((Holder<Biome>)biome)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    public static boolean isPositionSuitable(ChunkPos chunkPos, ChunkGenerator chunkGenerator, GenerationType generationType, Settings settings, LevelHeightAccessor heightAccessor) {
        if (generationType == GenerationType.onWater) {
            return true;
        }
        DETerrainAnalyzer.chunkGenerator = chunkGenerator;
        DETerrainAnalyzer.heightAccessor = heightAccessor;
        int x = chunkPos.m_45604_();
        int z = chunkPos.m_45605_();
        if (generationType == GenerationType.underwater) {
            return DETerrainAnalyzer.getBlockAt(x, chunkGenerator.m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor) + 16, z).m_60713_(Blocks.f_49990_);
        }
        int y = chunkGenerator.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
        if (generationType == GenerationType.underground) {
            return y > chunkGenerator.m_142062_() + 24;
        }
        if (generationType == GenerationType.inAir) {
            return y < chunkGenerator.m_142062_() + chunkGenerator.m_6331_() - 72;
        }
        if (DETerrainAnalyzer.getBlockAt(x, y - 1, z).m_60713_(Blocks.f_49990_)) {
            return false;
        }
        int columSpreading = settings.columSpreading();
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x + columSpreading, y, z), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x - columSpreading, y, z), settings)) {
            return false;
        }
        if (DETerrainAnalyzer.isColumBlocked(new BlockPos(x, y, z + columSpreading), settings)) {
            return false;
        }
        return !DETerrainAnalyzer.isColumBlocked(new BlockPos(x, y, z - columSpreading), settings);
    }

    protected static boolean isColumBlocked(BlockPos pos, Settings settings) {
        if (!DETerrainAnalyzer.isDownwardsFree(pos, settings.stepSize(), settings.steps())) {
            return DETerrainAnalyzer.isUpwardsBlocked(pos, settings.stepSize(), settings.steps());
        }
        return true;
    }

    protected static boolean isUpwardsBlocked(BlockPos pos, int stepSize, int steps) {
        for (int i = 1; i <= steps; ++i) {
            if (DETerrainAnalyzer.getBlockAt(pos.m_123341_(), pos.m_123342_() + i * stepSize, pos.m_123343_()).m_60795_()) continue;
            return true;
        }
        return false;
    }

    protected static boolean isDownwardsFree(BlockPos pos, int stepSize, int steps) {
        for (int i = 1; i <= steps; ++i) {
            if (!DETerrainAnalyzer.getBlockAt(pos.m_123341_(), pos.m_123342_() - i * stepSize, pos.m_123343_()).m_60795_()) continue;
            return true;
        }
        return false;
    }

    protected static BlockState getBlockAt(int x, int y, int z) {
        return chunkGenerator.m_141914_(x, z, heightAccessor).m_183556_(y);
    }

    public record Settings(int steps, int stepSize, int columSpreading) {
    }

    public static enum GenerationType {
        onGround,
        inAir,
        underground,
        onWater,
        underwater;

    }
}

