/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.world.structures.prefabs;

import com.barion.dungeons_enhanced.DEStructures;
import com.barion.dungeons_enhanced.world.gen.DETerrainAnalyzer;
import com.barion.dungeons_enhanced.world.structures.prefabs.DEBaseStructure;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEPieceAssembler;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEStructurePiece;
import com.barion.dungeons_enhanced.world.structures.prefabs.utils.DEUnderwaterProcessor;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import java.util.Optional;
import java.util.Random;
import java.util.function.Predicate;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.minecraft.world.level.levelgen.structure.pieces.StructurePieceSerializationContext;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DEUnderwaterStructure
extends DEBaseStructure {
    public DEUnderwaterStructure(StructureConfig config, boolean generateNearSpawn, DEStructurePiece[] resources) {
        this(config, generateNearSpawn, context -> DETerrainAnalyzer.isUnderwater(context.f_197355_(), context.f_197352_(), 16, context.f_197357_()), DEUnderwaterStructure::assemble, resources);
    }

    protected DEUnderwaterStructure(StructureConfig config, boolean generateNearSpawn, Predicate<PieceGeneratorSupplier.Context<NoneFeatureConfiguration>> pieceGenerator, DEPieceAssembler assembler, DEStructurePiece[] resources) {
        super(config, DETerrainAnalyzer.GenerationType.underwater, generateNearSpawn, pieceGenerator, assembler, resources);
    }

    private static void assemble(DEPieceAssembler.Context context) {
        context.piecesBuilder().m_142679_((StructurePiece)new Piece(context.structureManager(), context.piece(), context.pos(), context.rotation()));
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructureManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super(DEStructures.SunkenShrine.getPieceType(), 0, structureManager, templateName, Piece.getPlaceSettings(structureManager, templateName, rotation), pos);
        }

        public Piece(StructurePieceSerializationContext serializationContext, CompoundTag nbt) {
            super(DEStructures.SunkenShrine.getPieceType(), nbt, serializationContext.f_192764_(), name -> Piece.getPlaceSettings(serializationContext.f_192764_(), name, Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        protected static StructurePlaceSettings getPlaceSettings(StructureManager structureManager, ResourceLocation name, Rotation rotation) {
            Optional temp = structureManager.m_163774_(name);
            Vec3i size = Vec3i.f_123288_;
            if (temp.isPresent()) {
                size = ((StructureTemplate)temp.get()).m_163801_();
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(true).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2).m_7954_(rotation));
            settings.m_74383_((StructureProcessor)DEUnderwaterProcessor.Instance);
            return settings;
        }

        @ParametersAreNonnullByDefault
        protected void m_7756_(String key, BlockPos pos, ServerLevelAccessor level, Random random, BoundingBox box) {
        }
    }
}

