/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.client.renderers;

import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.client.renderers.IRenderBase;
import com.legacy.structure_gel.core.structure.StructureInfo;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Matrix4f;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class StructureBoundsRenderer
implements IRenderBase {
    private static final Map<ResourceLocation, List<StructureBoundsRenderer>> STRUCTURE_INFOS = new HashMap<ResourceLocation, List<StructureBoundsRenderer>>();
    private static boolean shouldClear = false;
    private final BlockPos pos;
    private final StructureInfo structureInfo;
    @Nullable
    private VertexBuffer lineBuffer;
    private boolean needsUpdated = true;

    private StructureBoundsRenderer(StructureInfo structureInfo) {
        this.pos = structureInfo.fullBounds().m_162394_();
        this.structureInfo = structureInfo;
    }

    public static void render(Minecraft mc, PoseStack poseStack, Matrix4f projectionMatrix, double camX, double camY, double camZ) {
        ResourceLocation dimensionName;
        List<StructureBoundsRenderer> renderers;
        if (shouldClear) {
            shouldClear = false;
            for (List<StructureBoundsRenderer> rendererList : STRUCTURE_INFOS.values()) {
                for (StructureBoundsRenderer renderer : rendererList) {
                    if (renderer.lineBuffer == null) continue;
                    renderer.lineBuffer.close();
                }
            }
            STRUCTURE_INFOS.clear();
        }
        if (StructureGelMod.proxy.shouldViewBounds() && (renderers = STRUCTURE_INFOS.get(dimensionName = mc.f_91073_.m_46472_().m_135782_())) != null) {
            RenderSystem.m_157427_(GameRenderer::m_172811_);
            poseStack.m_85836_();
            poseStack.m_85837_(-camX, -camY, -camZ);
            ShaderInstance shaderInstance = RenderSystem.m_157196_();
            Vec3i camPos = new Vec3i(camX, camY, camZ);
            for (int i = renderers.size() - 1; i > -1; --i) {
                StructureBoundsRenderer renderer = renderers.get(i);
                if (!renderer.pos.m_123314_(camPos, 300.0)) continue;
                renderer.renderBounds(mc, poseStack, projectionMatrix, shaderInstance, camX, camY, camZ);
            }
            poseStack.m_85849_();
        }
    }

    private void renderBounds(Minecraft mc, PoseStack poseStack, Matrix4f projectionMatrix, ShaderInstance shaderInstance, double camX, double camY, double camZ) {
        if (this.needsUpdated) {
            this.needsUpdated = false;
            if (this.lineBuffer != null) {
                this.lineBuffer.close();
            }
            this.lineBuffer = new VertexBuffer();
            BufferBuilder buffBuilder = Tesselator.m_85913_().m_85915_();
            buffBuilder.m_166779_(VertexFormat.Mode.TRIANGLE_STRIP, DefaultVertexFormat.f_85815_);
            this.compileBounds(mc, buffBuilder, camX, camY, camZ);
            buffBuilder.m_85721_();
            this.lineBuffer.m_85925_(buffBuilder);
        }
        if (this.lineBuffer != null) {
            poseStack.m_85836_();
            BoundingBox bb = this.structureInfo.fullBounds();
            poseStack.m_85837_(camX, camY, camZ);
            poseStack.m_85837_((double)bb.m_162395_() - camX, (double)bb.m_162396_() - camY, (double)bb.m_162398_() - camZ);
            this.lineBuffer.m_166867_(poseStack.m_85850_().m_85861_(), projectionMatrix, shaderInstance);
            poseStack.m_85849_();
        }
    }

    private void compileBounds(Minecraft mc, BufferBuilder buffBuilder, double camX, double camY, double camZ) {
        BoundingBox fullBounds = this.structureInfo.fullBounds();
        int minX = fullBounds.m_162395_();
        int minY = fullBounds.m_162396_();
        int minZ = fullBounds.m_162398_();
        IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)fullBounds.m_71053_()), 0.12, 1.0f, 1.0f, 1.0f);
        for (int i = this.structureInfo.pieces().size() - 1; i > -1; --i) {
            StructureInfo.PieceInfo pieceInfo = this.structureInfo.pieces().get(i);
            float[] rgb = pieceInfo.getColorFloats();
            BoundingBox pieceBounds = pieceInfo.bounds();
            IRenderBase.makeLineBox(buffBuilder, BoundingBox.m_162375_((Vec3i)Vec3i.f_123288_, (Vec3i)pieceBounds.m_71053_()).m_71045_(pieceBounds.m_162395_() - minX, pieceBounds.m_162396_() - minY, pieceBounds.m_162398_() - minZ), rgb[0], rgb[1], rgb[2]);
        }
    }

    public static void addInfo(StructureInfo structureInfo) {
        StructureGelMod.log("Recieved structure info at ({}) in {}", structureInfo.fullBounds().m_162394_().m_123344_(), structureInfo.dimension());
        STRUCTURE_INFOS.computeIfAbsent(structureInfo.dimension(), type -> new ArrayList()).add(new StructureBoundsRenderer(structureInfo));
    }

    public static void clear() {
        shouldClear = true;
    }
}

