/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import com.google.common.collect.ImmutableMap;
import com.legacy.structure_gel.api.registry.SGRegistry;
import com.legacy.structure_gel.api.structure.base.IModifyState;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.item.building_tool.ActionHistory;
import com.legacy.structure_gel.core.item.building_tool.BuildingToolItem;
import com.legacy.structure_gel.core.item.building_tool.CapturedBlocks;
import com.legacy.structure_gel.core.item.building_tool.ToolModeProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.Options;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public abstract class BuildingToolMode {
    public static final SGRegistry<ResourceLocation, BuildingToolMode> REGISTRY = new SGRegistry(StructureGelMod.locate("modes"), () -> NONE, null);
    private static final String MESSAGE_PRE = "info.structure_gel.building_tool.message.";
    private static final String SET_POS_KEY = "info.structure_gel.building_tool.message.set_pos";
    private static final String CLEAR_POSES_KEY = "info.structure_gel.building_tool.message.clear_poses";
    private static final String MISSING_POS_KEY = "info.structure_gel.building_tool.message.missing_pos";
    private static final String SELECT_STATE_KEY = "info.structure_gel.building_tool.message.select_state";
    private static final String MISSING_STATE_KEY = "info.structure_gel.building_tool.message.missing_state";
    private static final String CLEAR_BLOCKS_KEY = "info.structure_gel.building_tool.message.clear_blocks";
    private static final String PLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.place_blocks";
    private static final String REPLACE_BLOCKS_KEY = "info.structure_gel.building_tool.message.replace_blocks";
    private static final String CLONE_BLOCKS_KEY = "info.structure_gel.building_tool.message.clone_blocks";
    private static final String FLOOD_BLOCKS_KEY = "info.structure_gel.building_tool.message.flood_blocks";
    private static final String MOVE_BLOCKS_KEY = "info.structure_gel.building_tool.message.move_blocks";
    public static final BuildingToolMode NONE = new BuildingToolMode("none"){

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
        }
    };
    public static final BuildingToolMode CLEAR = new ForCorners("clear", true){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            BlockState air = Blocks.f_50016_.m_49966_();
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            Random rand = level.m_5822_();
            int total = this.forPosesWithin(cornerA, cornerB, pos -> (double)rand.nextFloat() < integrity ? this.setBlock(level, (BlockPos)pos, air, action) : false);
            ActionHistory.getOrCreateHistory(player).add(level, action);
            this.sendMessage(player, BuildingToolMode.CLEAR_BLOCKS_KEY, total);
            if (total > 0) {
                this.playSound(player, SoundEvents.f_11852_);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            return new Object[]{rightClick, rightClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
        }
    };
    public static final BuildingToolMode FILL = new ForCorners("fill", false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            Optional<BlockState> optionalState = BuildingToolItem.getSelectedState(stack);
            if (optionalState.isPresent()) {
                boolean retainState = BuildingToolItem.getProperty(stack, ToolModeProperty.RETAIN_STATE).value();
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                ToolModeProperty.FillMode fillMode = BuildingToolItem.getProperty(stack, ToolModeProperty.FILL_MODE);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState state = optionalState.get();
                BlockState clickedState = level.m_8055_(clickedPos);
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                Random rand = level.f_46441_;
                BlockPos minCorner = new BlockPos(Math.min(cornerA.m_123341_(), cornerB.m_123341_()), Math.min(cornerA.m_123342_(), cornerB.m_123342_()), Math.min(cornerA.m_123343_(), cornerB.m_123343_()));
                BlockPos maxCorner = new BlockPos(Math.max(cornerA.m_123341_(), cornerB.m_123341_()), Math.max(cornerA.m_123342_(), cornerB.m_123342_()), Math.max(cornerA.m_123343_(), cornerB.m_123343_()));
                int total = this.forPosesWithin(minCorner, maxCorner, pos -> {
                    if ((double)rand.nextFloat() < integrity) {
                        int x = pos.m_123341_();
                        int y = pos.m_123342_();
                        int z = pos.m_123343_();
                        int edges = 0;
                        if (x == minCorner.m_123341_() || x == maxCorner.m_123341_()) {
                            ++edges;
                        }
                        if (y == minCorner.m_123342_() || y == maxCorner.m_123342_()) {
                            ++edges;
                        }
                        if (z == minCorner.m_123343_() || z == maxCorner.m_123343_()) {
                            ++edges;
                        }
                        if (fillMode == ToolModeProperty.FillMode.HOLLOW && edges < 1 || fillMode == ToolModeProperty.FillMode.FRAME && edges < 2) {
                            return false;
                        }
                        if (replace.getCondition().shouldReplace(level, clickedState, (BlockPos)pos)) {
                            BlockState toPlace = retainState ? state : state.m_60734_().m_5573_(new BlockPlaceContext(player, InteractionHand.MAIN_HAND, state.m_60734_().m_5456_().m_7968_(), new BlockHitResult(Vec3.f_82478_, Direction.UP, pos, true)));
                            return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates(toPlace, oldState) : toPlace, action);
                        }
                    }
                    return false;
                });
                ActionHistory.getOrCreateHistory(player).add(level, action);
                this.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolMode.PLACE_BLOCKS_KEY : BuildingToolMode.REPLACE_BLOCKS_KEY, total, state.m_60734_().m_49954_().getString());
                if (total > 0) {
                    this.playSound(player, state);
                }
            } else {
                this.sendMessage(player, BuildingToolMode.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = options.f_92097_.getKey().m_84875_().getString();
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            return new Object[]{middleClick, rightClick, rightClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.FILL_MODE);
            properties.add(ToolModeProperty.RETAIN_STATE);
            properties.add(ToolModeProperty.REPLACE);
        }
    };
    public static final BuildingToolMode CLONE = new ForCorners("clone", false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
            ToolModeProperty.SGRotation rotation = BuildingToolItem.getProperty(stack, ToolModeProperty.ROTATION);
            ToolModeProperty.SGMirror mirror = BuildingToolItem.getProperty(stack, ToolModeProperty.MIRROR);
            boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_FALSE).value();
            Random rand = level.m_5822_();
            CapturedBlocks captured = new CapturedBlocks(level, cornerA, cornerB, mirror.toVanilla(rand), rotation.toVanilla(rand));
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            if (cut) {
                BlockState air = Blocks.f_50016_.m_49966_();
                this.forPosesWithin(cornerA, cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
                this.clearPoses(stack, player);
            }
            BoundingBox destBB = 4.getCloneDestBounds(captured, clickedPos, level.m_8055_(clickedPos), player.m_20182_());
            BlockPos startPos = new BlockPos(destBB.m_162395_(), destBB.m_162396_(), destBB.m_162398_());
            for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
                if (!((double)rand.nextFloat() < integrity)) continue;
                this.setBlock(level, startPos.m_141952_((Vec3i)info.pos()), info.state(), info.blockEntityTag(), action);
            }
            ActionHistory.getOrCreateHistory(player).add(level, action);
            this.sendMessage(player, BuildingToolMode.CLONE_BLOCKS_KEY, new Object[0]);
            this.playSound(player, SoundEvents.f_12200_);
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            return new Object[]{rightClick, rightClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.ROTATION);
            properties.add(ToolModeProperty.MIRROR);
            properties.add(ToolModeProperty.CUT_FALSE);
        }
    };
    public static final BuildingToolMode FLOOD = new BuildingToolMode("flood"){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (!level.m_8055_(clickedPos).m_60795_()) {
                this.onRightClickBlock(level, player, clickedPos, stack, clickedFace);
            }
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            Optional<BlockState> optionalState = BuildingToolItem.getSelectedState(stack);
            if (optionalState.isPresent()) {
                Set<BlockPos> poses = 5.getFloodPositions(level, clickedPos, clickedFace);
                if (poses.isEmpty()) {
                    return;
                }
                BlockState state = optionalState.get();
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                for (BlockPos pos : poses) {
                    BlockPos.MutableBlockPos mutPos = pos.m_122032_();
                    while (level.m_8055_((BlockPos)mutPos).m_60795_() && pos.m_123342_() - mutPos.m_123342_() < 100) {
                        this.setBlock(level, mutPos.m_7949_(), state, action);
                        mutPos.m_122173_(Direction.DOWN);
                    }
                }
                ActionHistory.getOrCreateHistory(player).add(level, action);
                this.sendMessage(player, BuildingToolMode.FLOOD_BLOCKS_KEY, poses.size());
                if (!poses.isEmpty()) {
                    this.playSound(player, state);
                }
            } else {
                this.sendMessage(player, BuildingToolMode.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = options.f_92097_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            return new Object[]{middleClick, leftClick, rightClick};
        }
    };
    public static final BuildingToolMode EXTEND = new BuildingToolMode("extend"){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (!level.m_8055_(clickedPos).m_60795_()) {
                this.onRightClickBlock(level, player, clickedPos, stack, clickedFace);
            }
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            Set<BlockPos> poses = 6.getExtendPositions(level, clickedPos, clickedFace);
            if (poses.isEmpty()) {
                return;
            }
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            Direction originDir = clickedFace.m_122424_();
            for (BlockPos pos : poses) {
                BlockPos fromPos = pos.m_142300_(originDir);
                BlockEntity blockE = level.m_7702_(fromPos);
                CompoundTag blockEntityNbt = blockE != null ? blockE.m_187482_() : null;
                this.setBlock(level, pos, level.m_8055_(fromPos), blockEntityNbt, action);
            }
            ActionHistory.getOrCreateHistory(player).add(level, action);
            this.sendMessage(player, BuildingToolMode.PLACE_BLOCKS_KEY, poses.size(), level.m_8055_(clickedPos).m_60734_().m_49954_().getString());
            if (!poses.isEmpty()) {
                this.playSound(player, level.m_8055_(clickedPos));
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            return new Object[]{leftClick, rightClick};
        }
    };
    public static final BuildingToolMode MOVE = new ForCorners("move", false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            int dist = BuildingToolItem.getProperty(stack, ToolModeProperty.MOVE_DISTANCE);
            boolean cut = BuildingToolItem.getProperty(stack, ToolModeProperty.CUT_TRUE).value();
            ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE_ALL_AIR);
            Direction facing = Direction.m_122382_((Entity)player)[0];
            CapturedBlocks captured = new CapturedBlocks(level, cornerA, cornerB);
            ActionHistory.ActionBuilder action = ActionHistory.newAction();
            BlockState air = Blocks.f_50016_.m_49966_();
            if (cut) {
                this.forPosesWithin(cornerA, cornerB, pos -> this.setBlock(level, (BlockPos)pos, air, action));
            }
            int total = 0;
            BlockPos placePos = captured.getWorldPos();
            for (CapturedBlocks.BlockInfo info : captured.getBlockInfos()) {
                BlockPos placeAt = placePos.m_141952_((Vec3i)info.pos()).m_5484_(facing, dist);
                if (!replace.getCondition().shouldReplace(level, air, placeAt) || !this.setBlock(level, placeAt, info.state(), info.blockEntityTag(), action)) continue;
                ++total;
            }
            action.changeSelection(this, 0, cornerA, cornerA.m_5484_(facing, dist));
            BuildingToolItem.setPos(stack, 0, cornerA.m_5484_(facing, dist));
            action.changeSelection(this, 1, cornerB, cornerB.m_5484_(facing, dist));
            BuildingToolItem.setPos(stack, 1, cornerB.m_5484_(facing, dist));
            ActionHistory.getOrCreateHistory(player).add(level, action);
            this.sendMessage(player, BuildingToolMode.MOVE_BLOCKS_KEY, total, facing.m_7912_());
            if (total > 0) {
                this.playSound(player, SoundEvents.f_12312_);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            return new Object[]{rightClick, rightClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.MOVE_DISTANCE);
            properties.add(ToolModeProperty.CUT_TRUE);
            properties.add(ToolModeProperty.REPLACE_ALL_AIR);
        }
    };
    public static final BuildingToolMode LINE = new ForCorners("line", false){

        @Override
        protected void performAction(Level level, Player player, BlockPos clickedPos, ItemStack stack, BlockPos cornerA, BlockPos cornerB) {
            if (level.f_46443_) {
                return;
            }
            Optional<BlockState> optionalState = BuildingToolItem.getSelectedState(stack);
            if (optionalState.isPresent()) {
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState state = optionalState.get();
                BlockState clickedState = level.m_8055_(clickedPos);
                Block clickedBlock = clickedState.m_60734_();
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                Random rand = level.m_5822_();
                Set<BlockPos> poses = 8.getLinePositions(cornerA, cornerB);
                int total = 0;
                block5: for (BlockPos pos : poses) {
                    if (!((double)rand.nextFloat() < integrity)) continue;
                    switch (replace) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case ALL: {
                            break;
                        }
                        case AIR: {
                            if (!level.m_8055_(pos).m_60795_()) continue block5;
                            break;
                        }
                        case CLICKED_BLOCK: {
                            if (clickedState.m_60795_() || !level.m_8055_(pos).m_60713_(clickedBlock)) continue block5;
                        }
                    }
                    if (!this.setBlock(level, pos, state, action)) continue;
                    ++total;
                }
                ActionHistory.getOrCreateHistory(player).add(level, action);
                this.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolMode.PLACE_BLOCKS_KEY : BuildingToolMode.REPLACE_BLOCKS_KEY, total, state.m_60734_().m_49954_().getString());
                if (total > 0) {
                    this.playSound(player, state);
                }
            } else {
                this.sendMessage(player, BuildingToolMode.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = options.f_92097_.getKey().m_84875_().getString();
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            return new Object[]{middleClick, rightClick, rightClick, leftClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.REPLACE);
        }
    };
    public static final BuildingToolMode SHAPE = new BuildingToolMode("shape"){

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            this.onRightClickBlock(level, player, clickedPos, stack, clickedFace);
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            if (level.f_46443_) {
                return;
            }
            Optional<BlockState> optionalState = BuildingToolItem.getSelectedState(stack);
            if (optionalState.isPresent()) {
                double integrity = BuildingToolItem.getProperty(stack, ToolModeProperty.INTEGRITY);
                int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
                ToolModeProperty.Shape shape = BuildingToolItem.getProperty(stack, ToolModeProperty.SHAPE);
                ToolModeProperty.Replace replace = BuildingToolItem.getProperty(stack, ToolModeProperty.REPLACE);
                BlockState state = optionalState.get();
                BlockState clickedState = level.m_8055_(clickedPos);
                ActionHistory.ActionBuilder action = ActionHistory.newAction();
                Random rand = level.m_5822_();
                int total = this.forPosesWithin(clickedPos.m_142082_(-radius, -radius, -radius), clickedPos.m_142082_(radius, radius, radius), pos -> {
                    if ((double)rand.nextFloat() < integrity && shape.isInside((Vec3i)clickedPos.m_142082_(-pos.m_123341_(), -pos.m_123342_(), -pos.m_123343_()), radius) && replace.getCondition().shouldReplace(level, clickedState, (BlockPos)pos)) {
                        return this.setBlock(level, (BlockPos)pos, (BlockState oldState) -> replace == ToolModeProperty.Replace.CLICKED_BLOCK ? IModifyState.mergeStates(state, oldState) : state, action);
                    }
                    return false;
                });
                ActionHistory.getOrCreateHistory(player).add(level, action);
                this.sendMessage(player, replace == ToolModeProperty.Replace.ALL ? BuildingToolMode.PLACE_BLOCKS_KEY : BuildingToolMode.REPLACE_BLOCKS_KEY, total, state.m_60734_().m_49954_().getString());
                if (total > 0) {
                    this.playSound(player, state);
                }
            } else {
                this.sendMessage(player, BuildingToolMode.MISSING_STATE_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[0]);
            }
        }

        @Override
        public int getReachDistance(ItemStack stack) {
            int radius = BuildingToolItem.getProperty(stack, ToolModeProperty.RADIUS);
            return 2 + radius;
        }

        @Override
        public Object[] getDescArgs() {
            Options options = Minecraft.m_91087_().f_91066_;
            String middleClick = options.f_92097_.getKey().m_84875_().getString();
            String leftClick = options.f_92096_.getKey().m_84875_().getString();
            String rightClick = options.f_92095_.getKey().m_84875_().getString();
            return new Object[]{middleClick, leftClick, rightClick};
        }

        @Override
        public void addProperties(List<ToolModeProperty<?>> properties) {
            super.addProperties(properties);
            properties.add(ToolModeProperty.INTEGRITY);
            properties.add(ToolModeProperty.RADIUS);
            properties.add(ToolModeProperty.SHAPE);
            properties.add(ToolModeProperty.REPLACE);
        }
    };
    private final ResourceLocation name;
    private final ModelResourceLocation modelName;
    private final ResourceLocation iconTexture;
    private final Component component;
    private final String descKey;
    private final Map<String, ToolModeProperty<?>> properties;

    private static void register(BuildingToolMode mode) {
        REGISTRY.register(mode.name, mode);
    }

    public BuildingToolMode(ResourceLocation name) {
        this.name = name;
        this.modelName = new ModelResourceLocation(new ResourceLocation(name.m_135827_(), "building_tool_" + name.m_135815_()), "inventory");
        this.iconTexture = new ResourceLocation(name.m_135827_(), "textures/item/building_tool_" + name.m_135815_() + ".png");
        this.component = new TranslatableComponent("item.structure_gel.building_tool.mode." + name.toString());
        this.descKey = "item.structure_gel.building_tool.mode.description." + name.toString();
        ArrayList props = new ArrayList();
        this.addProperties(props);
        this.properties = (Map)props.stream().collect(ImmutableMap.toImmutableMap(ToolModeProperty::getKey, Function.identity()));
    }

    private BuildingToolMode(String name) {
        this(StructureGelMod.locate(name));
        BuildingToolMode.register(this);
    }

    public void useOn(UseOnContext context) {
        Level level = context.m_43725_();
        BlockPos clickedPos = context.m_8083_();
        ItemStack stack = context.m_43722_();
        Player player = context.m_43723_();
        this.onRightClickBlock(level, player, clickedPos, stack, context.m_43719_());
    }

    public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onShiftRightClickAir(Level level, Player player, ItemStack stack) {
    }

    public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
    }

    public void onMiddleClick(Level level, Player player, BlockPos clickedPos, ItemStack stack) {
        BlockState state = level.m_8055_(clickedPos);
        BuildingToolItem.setSelectedState(stack, state);
        if (!level.f_46443_) {
            this.sendMessage(player, SELECT_STATE_KEY, state.m_60734_().m_49954_().getString());
            this.playSound(player, SoundEvents.f_12019_);
        }
    }

    public void addProperties(List<ToolModeProperty<?>> properties) {
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, state, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, BlockState state, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, (BlockState old) -> state, blockEntityTag, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, ActionHistory.ActionBuilder actionBuilder) {
        return this.setBlock(level, pos, modifyState, null, actionBuilder);
    }

    protected boolean setBlock(Level level, BlockPos pos, Function<BlockState, BlockState> modifyState, @Nullable CompoundTag blockEntityTag, ActionHistory.ActionBuilder actionBuilder) {
        CompoundTag oldBETag;
        BlockState oldState = level.m_8055_(pos);
        BlockState newState = modifyState.apply(oldState);
        if (newState == null) {
            return false;
        }
        BlockEntity oldBlockEntity = level.m_7702_(pos);
        if (oldBlockEntity != null) {
            oldBETag = oldBlockEntity.m_187482_();
            Clearable.m_18908_((Object)oldBlockEntity);
            level.m_7731_(pos, Blocks.f_50375_.m_49966_(), 2);
        } else {
            oldBETag = null;
        }
        boolean ret = level.m_7731_(pos, newState, 3);
        BlockEntity newBlockEntity = level.m_7702_(pos);
        if (newBlockEntity != null && blockEntityTag != null) {
            newBlockEntity.m_142466_(blockEntityTag);
        }
        if (ret) {
            actionBuilder.changeBlock(pos, oldState, oldBETag, newState, blockEntityTag);
        }
        return ret;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public ModelResourceLocation getModel() {
        return this.modelName;
    }

    public ResourceLocation getIconTexture() {
        return this.iconTexture;
    }

    public Component getComponent() {
        return this.component;
    }

    public String getDescKey() {
        return this.descKey;
    }

    public Object[] getDescArgs() {
        return new Object[0];
    }

    public Map<String, ToolModeProperty<?>> getProperties() {
        return this.properties;
    }

    public int getReachDistance(ItemStack stack) {
        return 2;
    }

    protected int forPosesWithin(BlockPos cornerA, BlockPos cornerB, Function<BlockPos, Boolean> action) {
        int total = 0;
        BoundingBox area = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
        for (int x = area.m_162395_(); x <= area.m_162399_(); ++x) {
            for (int z = area.m_162398_(); z <= area.m_162401_(); ++z) {
                for (int y = area.m_162396_(); y <= area.m_162400_(); ++y) {
                    if (!action.apply(new BlockPos(x, y, z)).booleanValue()) continue;
                    ++total;
                }
            }
        }
        return total;
    }

    protected void setPos(ItemStack stack, int index, BlockPos pos, Player player) {
        this.sendMessage(player, SET_POS_KEY, index + 1, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        BuildingToolItem.setPos(stack, index, pos);
    }

    protected void clearPoses(ItemStack stack, Player player) {
        this.sendMessage(player, CLEAR_POSES_KEY, new Object[0]);
        BuildingToolItem.clearPoses(stack);
    }

    protected void sendMessage(Player player, String translationKey, Object ... args) {
        this.sendMessage(player, translationKey, Style.f_131099_, args);
    }

    protected void sendMessage(Player player, String translationKey, Style style, Object ... args) {
        player.m_5661_((Component)new TranslatableComponent(translationKey, args).m_6270_(style), true);
    }

    protected void playSound(Player player, SoundEvent sound) {
        player.f_19853_.m_5594_(null, player.m_142538_(), sound, SoundSource.BLOCKS, 0.8f, 1.0f + player.m_183503_().m_5822_().nextFloat() * 0.2f);
    }

    protected void playSound(Player player, BlockState state) {
        LiquidBlock liquidBlock;
        SoundEvent emptySound;
        Block block = state.m_60734_();
        SoundEvent sound = block instanceof LiquidBlock ? ((emptySound = (liquidBlock = (LiquidBlock)block).getFluid().getAttributes().getEmptySound()) == null ? SoundEvents.f_11778_ : emptySound) : state.m_60827_().m_56777_();
        this.playSound(player, sound);
    }

    public String toString() {
        return "BuildingToolMode[" + this.name + "]";
    }

    public static BoundingBox getCloneDestBounds(CapturedBlocks captured, BlockPos targetPos, BlockState targetedBlock, Vec3 playerPos) {
        Vec3i bbLength = captured.getBounds().m_71053_();
        BlockPos start = targetPos.m_142082_(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        if (!targetedBlock.m_60795_()) {
            start = start.m_7494_();
        }
        BoundingBox destBB = BoundingBox.m_162375_((Vec3i)start, (Vec3i)start.m_141952_(bbLength));
        int x = destBB.m_162395_();
        int z = destBB.m_162398_();
        int dx = destBB.m_162399_();
        int dz = destBB.m_162401_();
        LinkedList<Vec3i> edgePositions = new LinkedList<Vec3i>();
        edgePositions.add(new Vec3i(x, 0, z));
        edgePositions.add(new Vec3i(x, 0, dz));
        edgePositions.add(new Vec3i(dx, 0, z));
        edgePositions.add(new Vec3i(dx, 0, dz));
        edgePositions.sort(Comparator.comparingDouble(v -> new Vec3((double)v.m_123341_() + 0.5, (double)v.m_123342_(), (double)v.m_123343_() + 0.5).m_82554_(playerPos)));
        Vec3i closestCorner = (Vec3i)edgePositions.getFirst();
        BlockPos center = destBB.m_162394_();
        return destBB.m_71045_(center.m_123341_() - closestCorner.m_123341_(), 0, center.m_123343_() - closestCorner.m_123343_());
    }

    public static Set<BlockPos> getExtendPositions(Level level, BlockPos clickedPos, Direction clickedFace) {
        if (!level.m_8055_(clickedPos.m_142300_(clickedFace)).m_60795_()) {
            return Collections.emptySet();
        }
        Direction.Axis axis = clickedFace.m_122434_();
        BlockState state = level.m_8055_(clickedPos);
        Block clickedBlock = state.m_60734_();
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(clickedPos);
        ArrayList<Vec3i> dirs = new ArrayList<Vec3i>(9);
        for (int a = -1; a <= 1; ++a) {
            for (int b = -1; b <= 1; ++b) {
                Vec3i vec = switch (axis) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.Axis.X -> new Vec3i(0, a, b);
                    case Direction.Axis.Y -> new Vec3i(a, 0, b);
                    case Direction.Axis.Z -> new Vec3i(a, b, 0);
                };
                dirs.add(vec);
            }
        }
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)clickedPos) > 32) continue;
                allPositions.add(pos);
                for (Vec3i dir : dirs) {
                    BlockPos offset = pos.m_141952_(dir);
                    if (allPositions.contains(offset) || !level.m_8055_(offset).m_60713_(clickedBlock) || !level.m_8055_(offset.m_142300_(clickedFace)).m_60795_()) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions.stream().map(p -> p.m_142300_(clickedFace)).collect(Collectors.toSet());
    }

    public static Set<BlockPos> getFloodPositions(Level level, BlockPos clickedPos, Direction clickedFace) {
        BlockPos startPos = clickedPos.m_142300_(clickedFace);
        if (!level.m_8055_(startPos).m_60795_()) {
            return Collections.emptySet();
        }
        HashSet<BlockPos> allPositions = new HashSet<BlockPos>();
        HashSet<BlockPos> posesToSearch = new HashSet<BlockPos>();
        posesToSearch.add(startPos);
        Direction[] dirs = new Direction[]{Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
        while (!posesToSearch.isEmpty()) {
            HashSet<BlockPos> newPoses = new HashSet<BlockPos>();
            for (BlockPos pos : posesToSearch) {
                if (pos.m_123333_((Vec3i)startPos) > 50) continue;
                allPositions.add(pos);
                for (Direction dir : dirs) {
                    BlockPos offset = pos.m_142300_(dir);
                    if (allPositions.contains(offset) || !level.m_8055_(offset).m_60795_()) continue;
                    newPoses.add(offset);
                }
            }
            posesToSearch = newPoses;
        }
        return allPositions;
    }

    public static Set<BlockPos> getLinePositions(BlockPos cornerA, BlockPos cornerB) {
        HashSet<BlockPos> poses = new HashSet<BlockPos>();
        double magnitude = Math.sqrt(cornerA.m_123331_((Vec3i)cornerB));
        if (magnitude == 0.0) {
            poses.add(cornerA);
            return poses;
        }
        int x = cornerA.m_123341_();
        int y = cornerA.m_123342_();
        int z = cornerA.m_123343_();
        double dX = (double)(x - cornerB.m_123341_()) / magnitude;
        double dY = (double)(y - cornerB.m_123342_()) / magnitude;
        double dZ = (double)(z - cornerB.m_123343_()) / magnitude;
        BlockPos pos = cornerA;
        int i = 0;
        while (!pos.equals((Object)cornerB) && (double)i < magnitude + 1.0) {
            pos = cornerA.m_142022_((double)(-Math.round(dX * (double)i)), (double)(-Math.round(dY * (double)i)), (double)(-Math.round(dZ * (double)i)));
            ++i;
            poses.add(pos);
        }
        return poses;
    }

    static {
        REGISTRY.init();
    }

    public static abstract class ForCorners
    extends BuildingToolMode {
        private final boolean resetPosesAfterAction;

        public ForCorners(ResourceLocation name, boolean resetPosesAfterAction) {
            super(name);
            this.resetPosesAfterAction = resetPosesAfterAction;
        }

        private ForCorners(String name, boolean resetPosesAfterAction) {
            super(name);
            this.resetPosesAfterAction = resetPosesAfterAction;
        }

        @Override
        public void onRightClickBlock(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            this.setPosition(player, clickedPos, stack);
        }

        public void setPosition(Player player, BlockPos clickedPos, ItemStack stack) {
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            if (!pos0.isPresent()) {
                this.setPos(stack, 0, clickedPos, player);
                return;
            }
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            if (!pos1.isPresent()) {
                this.setPos(stack, 1, clickedPos, player);
                return;
            }
            this.clearPoses(stack, player);
        }

        @Override
        public void onShiftRightClickAir(Level level, Player player, ItemStack stack) {
            this.clearPoses(stack, player);
        }

        @Override
        public void onLeftClick(Level level, Player player, BlockPos clickedPos, ItemStack stack, Direction clickedFace) {
            Optional<BlockPos> pos0 = BuildingToolItem.getPos(stack, 0);
            Optional<BlockPos> pos1 = BuildingToolItem.getPos(stack, 1);
            if (pos0.isPresent() && pos1.isPresent()) {
                if (this.resetPosesAfterAction) {
                    BuildingToolItem.clearPoses(stack);
                }
                if (level.m_46749_(pos0.get()) && level.m_46749_(pos1.get())) {
                    this.performAction(level, player, clickedPos, stack, pos0.get(), pos1.get());
                }
                return;
            }
            ArrayList<String> missingPoses = new ArrayList<String>(1);
            if (pos0.isEmpty()) {
                missingPoses.add(Integer.toString(1));
            }
            if (pos1.isEmpty()) {
                missingPoses.add(Integer.toString(2));
            }
            this.sendMessage(player, BuildingToolMode.MISSING_POS_KEY, Style.f_131099_.m_131140_(ChatFormatting.RED), new Object[]{"[" + String.join((CharSequence)", ", missingPoses) + "]"});
        }

        protected abstract void performAction(Level var1, Player var2, BlockPos var3, ItemStack var4, BlockPos var5, BlockPos var6);
    }
}

