/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.item.building_tool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.structure.BoundingBox;

public class CapturedBlocks {
    private final BlockPos worldPos;
    private final BlockPos centerOffset;
    private final BoundingBox bounds;
    private final List<BlockInfo> blockInfos;

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB) {
        this(level, cornerA, cornerB, Mirror.NONE, Rotation.NONE);
    }

    public CapturedBlocks(Level level, BlockPos cornerA, BlockPos cornerB, Mirror mirror, Rotation rotation) {
        BoundingBox bounds = BoundingBox.m_162375_((Vec3i)cornerA, (Vec3i)cornerB);
        LinkedList<BlockInfo> infos = new LinkedList<BlockInfo>();
        int minX = bounds.m_162395_();
        int minY = bounds.m_162396_();
        int minZ = bounds.m_162398_();
        int maxX = bounds.m_162399_();
        int maxY = bounds.m_162400_();
        int maxZ = bounds.m_162401_();
        Vec3i bbLength = bounds.m_71053_();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = level.m_8055_(pos);
                    BlockEntity blockEntity = level.m_7702_(pos);
                    CompoundTag blockEntityTag = blockEntity != null ? blockEntity.m_187482_() : null;
                    BlockPos transformedPos = this.transformPos(new BlockPos(x - minX, y - minY, z - minZ), bbLength, mirror, rotation);
                    infos.add(new BlockInfo(transformedPos, state.m_60715_(mirror).m_60717_(rotation), blockEntityTag));
                }
            }
        }
        if (rotation == Rotation.CLOCKWISE_90 || rotation == Rotation.COUNTERCLOCKWISE_90) {
            bounds = BoundingBox.m_162375_((Vec3i)new Vec3i(minX, minY, minZ), (Vec3i)new Vec3i(minX + bbLength.m_123343_(), maxY, minZ + bbLength.m_123341_()));
            bbLength = bounds.m_71053_();
        }
        this.bounds = bounds;
        this.centerOffset = new BlockPos(-bbLength.m_123341_() + bbLength.m_123341_() / 2, 0, -bbLength.m_123343_() + bbLength.m_123343_() / 2);
        this.worldPos = new BlockPos(bounds.m_162395_(), bounds.m_162396_(), bounds.m_162398_());
        this.blockInfos = new ArrayList<BlockInfo>(infos);
    }

    public void compressForRender(Level level, BlockPos startPos) {
        Map<BlockPos, BlockState> positions = this.blockInfos.stream().collect(Collectors.toMap(BlockInfo::pos, BlockInfo::state));
        Iterator<BlockInfo> it = this.blockInfos.iterator();
        while (it.hasNext()) {
            BlockInfo info = it.next();
            boolean remove = true;
            BlockPos pos = info.pos;
            for (Direction dir : Direction.values()) {
                BlockPos offset = pos.m_142300_(dir);
                BlockState offsetState = positions.get(offset);
                if (offsetState != null && offsetState.m_60804_((BlockGetter)level, startPos.m_141952_((Vec3i)offset))) continue;
                remove = false;
                break;
            }
            if (!remove) continue;
            it.remove();
        }
    }

    private BlockPos transformPos(BlockPos pos, Vec3i size, Mirror mirror, Rotation rotation) {
        if (mirror == Mirror.NONE && rotation == Rotation.NONE) {
            return pos;
        }
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        switch (mirror) {
            case LEFT_RIGHT: {
                z = size.m_123343_() - z;
                break;
            }
            case FRONT_BACK: {
                x = size.m_123341_() - x;
                break;
            }
        }
        switch (rotation) {
            case CLOCKWISE_90: {
                int invZ = size.m_123343_() - z;
                z = x;
                x = invZ;
                break;
            }
            case CLOCKWISE_180: {
                x = size.m_123341_() - x;
                z = size.m_123343_() - z;
                break;
            }
            case COUNTERCLOCKWISE_90: {
                int invX = size.m_123341_() - x;
                x = z;
                z = invX;
                break;
            }
        }
        return new BlockPos(x, y, z);
    }

    public BoundingBox getBounds() {
        return this.bounds;
    }

    public BlockPos getCenterPos() {
        return this.centerOffset;
    }

    public BlockPos getWorldPos() {
        return this.worldPos;
    }

    public List<BlockInfo> getBlockInfos() {
        return Collections.unmodifiableList(this.blockInfos);
    }

    public record BlockInfo(BlockPos pos, BlockState state, @Nullable CompoundTag blockEntityTag) {
    }
}

