/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced;

import com.barion.dungeons_enhanced.DEConfig;
import com.barion.dungeons_enhanced.DEUtil;
import com.barion.dungeons_enhanced.DungeonsEnhanced;
import com.barion.dungeons_enhanced.structures.DECastle;
import com.barion.dungeons_enhanced.structures.DEDesertTemple;
import com.barion.dungeons_enhanced.structures.DEDesertTomb;
import com.barion.dungeons_enhanced.structures.DEDruidCircle;
import com.barion.dungeons_enhanced.structures.DEDungeonVariant;
import com.barion.dungeons_enhanced.structures.DEIcePit;
import com.barion.dungeons_enhanced.structures.DEJungleMonument;
import com.barion.dungeons_enhanced.structures.DELargeDungeon;
import com.barion.dungeons_enhanced.structures.DEMinersHouse;
import com.barion.dungeons_enhanced.structures.DEMonsterMaze;
import com.barion.dungeons_enhanced.structures.DEMushroomHouse;
import com.barion.dungeons_enhanced.structures.DEPillagerCamp;
import com.barion.dungeons_enhanced.structures.DEStables;
import com.barion.dungeons_enhanced.structures.DETallWitchHut;
import com.barion.dungeons_enhanced.structures.prefabs.DEPiece;
import com.barion.dungeons_enhanced.structures.prefabs.DESimpleStructure;
import com.barion.dungeons_enhanced.structures.prefabs.DEUndergroundStructure;
import com.legacy.structure_gel.api.registry.registrar.GelStructureRegistrar;
import com.legacy.structure_gel.api.registry.registrar.StructureRegistrar;
import com.legacy.structure_gel.api.structure.GelConfigJigsawStructure;
import com.legacy.structure_gel.api.structure.GelConfigStructure;
import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.StructureTemplatePool;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.IForgeRegistry;

public class DEStructures {
    public static final StructureRegistrar<JigsawConfiguration, DECastle> Castle = DEStructures.registerJigsaw("castle", new DECastle(), DECastle.Pool.Root, 1, DECastle.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEDesertTemple> DesertTemple = DEStructures.register("desert_temple", new DEDesertTemple(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<JigsawConfiguration, DEDesertTomb> DesertTomb = DEStructures.registerJigsaw("desert_tomb", new DEDesertTomb(), DEDesertTomb.Pool.Root, 4, DEDesertTomb.Piece::new);
    public static final StructureRegistrar<JigsawConfiguration, DEDruidCircle> DruidCircle = DEStructures.registerJigsaw("druid_circle", new DEDruidCircle(), DEDruidCircle.Pool.Root, 2, DEDruidCircle.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEDungeonVariant> DungeonVariant = DEStructures.register("dungeon_variant", new DEDungeonVariant(), DEUndergroundStructure.Piece::new, GenerationStep.Decoration.UNDERGROUND_STRUCTURES);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> HayStorage = DEStructures.register("hay_storage", new DESimpleStructure(DEConfig.COMMON.hay_Storage, true, new DEPiece("hay_storage/small", DEUtil.Offset(-7, 0, -7)), new DEPiece("hay_storage/big", DEUtil.Offset(-9, 0, -9))), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEIcePit> IcePit = DEStructures.register("ice_pit", new DEIcePit(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEJungleMonument> JungleMonument = DEStructures.register("jungle_monument", new DEJungleMonument(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<JigsawConfiguration, DELargeDungeon> LargeDungeon = DEStructures.registerJigsaw("large_dungeon", new DELargeDungeon(), DELargeDungeon.Pool.Root, 6, DELargeDungeon.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEMinersHouse> MinersHouse = DEStructures.register("miners_house", new DEMinersHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<JigsawConfiguration, DEMonsterMaze> MonsterMaze = DEStructures.registerJigsaw("monster_maze", new DEMonsterMaze(), DEMonsterMaze.Pool.Root, 9, DEMonsterMaze.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEMushroomHouse> MushroomHouse = DEStructures.register("mushroom_house", new DEMushroomHouse(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEPillagerCamp> PillagerCamp = DEStructures.register("pillager_camp", new DEPillagerCamp(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> RuinedBuilding = DEStructures.register("ruined_building", new DESimpleStructure(DEConfig.COMMON.ruined_building, true, new DEPiece("ruined_building/house", DEUtil.Offset(-5, 0, -5), 3), new DEPiece("ruined_building/house_big", DEUtil.Offset(-6, 0, -8), 2), new DEPiece("ruined_building/barn", DEUtil.Offset(-4, 0, -5), 3)), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DEStables> Stables = DEStructures.register("stables", new DEStables(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DETallWitchHut> TallWitchHut = DEStructures.register("tall_witch_hut", new DETallWitchHut(), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> TreeHouse = DEStructures.register("tree_house", new DESimpleStructure(DEConfig.COMMON.tree_house, true, new DEPiece("tree_house", DEUtil.Offset(-11, 0, -12))), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> TowerOfTheUndead = DEStructures.register("tower_of_the_undead", new DESimpleStructure(DEConfig.COMMON.tower_of_the_undead, true, new DEPiece("tower_of_the_undead/big", DEUtil.Offset(-7, 0, -7), 2), new DEPiece("tower_of_the_undead/small", DEUtil.Offset(-5, 0, -5), 3)), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> WatchTower = DEStructures.register("watch_tower", new DESimpleStructure(DEConfig.COMMON.watch_tower, true, new DEPiece("watch_tower", DEUtil.Offset(-4, 0, -4))), DESimpleStructure.Piece::new);
    public static final StructureRegistrar<NoneFeatureConfiguration, DESimpleStructure> WitchTower = DEStructures.register("witch_tower", new DESimpleStructure(DEConfig.COMMON.witch_tower, true, new DEPiece("witch_tower/normal", DEUtil.Offset(-6, 0, -5), 3), new DEPiece("witch_tower/big", DEUtil.Offset(-7, 0, -7), 1)), DESimpleStructure.Piece::new);

    @SubscribeEvent
    public static void onRegistry(RegistryEvent.Register<StructureFeature<?>> event) {
        IForgeRegistry registry = event.getRegistry();
        DECastle.Pool.init();
        DEDesertTomb.Pool.init();
        DEDruidCircle.Pool.init();
        DEMonsterMaze.Pool.init();
        DELargeDungeon.Pool.init();
        Castle.handleForge(registry);
        RuinedBuilding.handleForge(registry);
        DesertTemple.handleForge(registry);
        DesertTomb.handleForge(registry);
        DruidCircle.handleForge(registry);
        HayStorage.handleForge(registry);
        IcePit.handleForge(registry);
        JungleMonument.handleForge(registry);
        LargeDungeon.handleForge(registry);
        DungeonVariant.handleForge(registry);
        MinersHouse.handleForge(registry);
        MonsterMaze.handleForge(registry);
        MushroomHouse.handleForge(registry);
        PillagerCamp.handleForge(registry);
        Stables.handleForge(registry);
        TallWitchHut.handleForge(registry);
        TreeHouse.handleForge(registry);
        TowerOfTheUndead.handleForge(registry);
        WatchTower.handleForge(registry);
        WitchTower.handleForge(registry);
        DEStructures.noiseAffecting(RuinedBuilding, DruidCircle, TowerOfTheUndead, HayStorage, DruidCircle, MinersHouse, MushroomHouse, WatchTower, WitchTower, Castle, PillagerCamp, TreeHouse, MonsterMaze);
        DungeonsEnhanced.LOGGER.info("Dungeons Enhanced structures loaded");
    }

    private static <S extends GelConfigStructure<NoneFeatureConfiguration>> StructureRegistrar<NoneFeatureConfiguration, S> register(String registryName, S structure, StructurePieceType piece) {
        return GelStructureRegistrar.of((ResourceLocation)DEUtil.createRegistryName(registryName), structure, (StructurePieceType)piece, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_, (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    }

    private static <S extends GelConfigStructure<NoneFeatureConfiguration>> StructureRegistrar<NoneFeatureConfiguration, S> register(String registryName, S structure, StructurePieceType piece, GenerationStep.Decoration decoration) {
        return GelStructureRegistrar.of((ResourceLocation)DEUtil.createRegistryName(registryName), structure, (StructurePieceType)piece, (FeatureConfiguration)NoneFeatureConfiguration.f_67816_, (GenerationStep.Decoration)decoration);
    }

    private static <S extends GelConfigJigsawStructure> StructureRegistrar<JigsawConfiguration, S> registerJigsaw(String registryName, S structure, StructureTemplatePool root, Integer level, StructurePieceType piece) {
        return GelStructureRegistrar.of((ResourceLocation)DEUtil.createRegistryName(registryName), structure, (StructurePieceType)piece, (FeatureConfiguration)new JigsawConfiguration(() -> root, level.intValue()), (GenerationStep.Decoration)GenerationStep.Decoration.SURFACE_STRUCTURES);
    }

    private static void noiseAffecting(StructureRegistrar<?, ?> ... structureRegs) {
        for (StructureRegistrar<?, ?> structure : structureRegs) {
            StructureAccessHelper.addNoiseAffectingStructures((StructureFeature[])new StructureFeature[]{structure.getStructure()});
        }
    }
}

