/*
 * Decompiled with CFR 0.152.
 */
package com.barion.dungeons_enhanced.structures.prefabs;

import com.barion.dungeons_enhanced.structures.prefabs.DEPiece;
import com.barion.dungeons_enhanced.structures.prefabs.DESimpleStructure;
import com.legacy.structure_gel.api.config.StructureConfig;
import com.legacy.structure_gel.api.structure.GelConfigStructure;
import com.legacy.structure_gel.api.structure.GelTemplateStructurePiece;
import com.legacy.structure_gel.api.structure.processor.RemoveGelStructureProcessor;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.StructurePieceType;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockIgnoreProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructurePlaceSettings;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public class DEBaseStructure
extends GelConfigStructure<NoneFeatureConfiguration> {
    protected ChunkGenerator chunkGen;
    protected LevelHeightAccessor heightAccessor;
    protected DEPiece[] Variants;
    protected final GenerationType generationType;
    protected int maxWeight;
    protected boolean generateNearSpawn;

    public DEBaseStructure(StructureConfig config, GenerationType generation, boolean generateNearSpawn, DEPiece ... resources) {
        this(config, generation, generateNearSpawn);
        this.Variants = resources;
        this.maxWeight = this.getMaxWeight();
    }

    public DEBaseStructure(StructureConfig config, GenerationType generation, BlockPos offset, boolean generateNearSpawn, DEPiece ... resources) {
        this(config, generation, generateNearSpawn);
        for (DEPiece resource : resources) {
            resource.Offset = offset;
        }
        this.Variants = resources;
        this.maxWeight = this.getMaxWeight();
    }

    private DEBaseStructure(StructureConfig config, GenerationType generationType, boolean generateNearWorldSpawn) {
        super(NoneFeatureConfiguration.f_67815_, config);
        this.generationType = generationType;
        this.generateNearSpawn = generateNearWorldSpawn;
        this.setLakeProof(true);
    }

    @Nonnull
    public StructureFeature.StructureStartFactory<NoneFeatureConfiguration> m_6258_() {
        return (x$0, x$1, x$2, x$3) -> new Start((StructureFeature<NoneFeatureConfiguration>)x$0, x$1, x$2, x$3);
    }

    public boolean isAllowedNearWorldSpawn() {
        return this.generateNearSpawn;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGen, BiomeSource biomeSource, long seed, WorldgenRandom rand, ChunkPos chunkPos, Biome biome, ChunkPos potentialChunkPos, NoneFeatureConfiguration config, LevelHeightAccessor heightAccessor) {
        if (this.generationType == GenerationType.onGround) {
            this.chunkGen = chunkGen;
            this.heightAccessor = heightAccessor;
            int x = chunkPos.f_45578_ * 16;
            int z = chunkPos.f_45579_ * 16;
            int y = chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
            if (this.getBlockAt(x, y - 1, z) == Blocks.f_49990_) {
                return false;
            }
            int tempY = y + 3;
            if (this.getBlockAt(x + 3, tempY, z) != Blocks.f_50016_ || this.getBlockAt(x - 3, tempY, z) != Blocks.f_50016_ || this.getBlockAt(x, tempY, z + 3) != Blocks.f_50016_ || this.getBlockAt(x, tempY, z - 3) != Blocks.f_50016_) {
                return false;
            }
            tempY = y - 3;
            if (this.getBlockAt(x + 3, tempY, z) == Blocks.f_50016_ || this.getBlockAt(x - 3, tempY, z) == Blocks.f_50016_ || this.getBlockAt(x, tempY, z + 3) == Blocks.f_50016_ || this.getBlockAt(x, tempY, z - 3) == Blocks.f_50016_) {
                return false;
            }
        }
        return super.m_142290_(chunkGen, biomeSource, seed, rand, chunkPos, biome, potentialChunkPos, (FeatureConfiguration)config, heightAccessor);
    }

    public void assemble(StructureManager structureManager, BlockPos pos, Rotation rotation, List<StructurePiece> structurePieces, Random rand) {
        int piece = 0;
        if (this.Variants.length > 1) {
            int i = rand.nextInt(this.maxWeight + 1);
            for (int j = 0; j < this.Variants.length; ++j) {
                if (this.Variants[j].Weight >= i) {
                    piece = j;
                    break;
                }
                i -= this.Variants[j].Weight;
            }
        }
        structurePieces.add((StructurePiece)new DESimpleStructure.Piece(structureManager, this.Variants[piece].Resource, pos.m_141952_((Vec3i)this.Variants[piece].Offset), rotation));
    }

    protected int getMaxWeight() {
        int i = 0;
        for (DEPiece piece : this.Variants) {
            i += piece.Weight;
        }
        return i;
    }

    protected Block getBlockAt(int x, int y, int z) {
        return this.chunkGen.m_141914_(x, z, this.heightAccessor).m_47156_(new BlockPos(x, y, z)).m_60734_();
    }

    public static enum GenerationType {
        onGround,
        inAir,
        underground;

    }

    public class Start
    extends StructureStart<NoneFeatureConfiguration> {
        public Start(StructureFeature<NoneFeatureConfiguration> structureFeature, ChunkPos chunkPos, int reference, long seed) {
            super(structureFeature, chunkPos, reference, seed);
        }

        @ParametersAreNonnullByDefault
        public void generatePieces(RegistryAccess registry, ChunkGenerator chunkGen, StructureManager structureManager, ChunkPos chunkPos, Biome biome, NoneFeatureConfiguration config, LevelHeightAccessor heightAccessor) {
            int x = chunkPos.f_45578_ * 16;
            int z = chunkPos.f_45579_ * 16;
            int y = 0;
            if (DEBaseStructure.this.generationType == GenerationType.onGround) {
                y = chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor);
            } else if (DEBaseStructure.this.generationType == GenerationType.inAir) {
                int maxY;
                int minY = chunkGen.m_142647_(x, z, Heightmap.Types.WORLD_SURFACE_WG, heightAccessor) + 50;
                y = minY > (maxY = 220) ? maxY : minY + this.f_73564_.nextInt(maxY - minY);
            } else if (DEBaseStructure.this.generationType == GenerationType.underground) {
                int minY = 10;
                int maxY = chunkGen.m_142647_(x, z, Heightmap.Types.OCEAN_FLOOR_WG, heightAccessor);
                if (maxY >= 55) {
                    maxY = 55;
                }
                if ((y = Math.abs(this.f_73564_.nextInt(maxY))) < minY) {
                    y = minY;
                }
            }
            DEBaseStructure.this.assemble(structureManager, new BlockPos(x, y, z), Rotation.m_55956_((Random)this.f_73564_), this.f_73562_, (Random)this.f_73564_);
            this.m_142516_();
        }
    }

    public static class Piece
    extends GelTemplateStructurePiece {
        public Piece(StructurePieceType pieceType, int componentType, StructureManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            super(pieceType, componentType, structureManager, templateName, Piece.getPlaceSettings(structureManager, templateName, pos, rotation), pos);
            this.f_73658_ = pos;
            this.f_73379_ = rotation;
        }

        public Piece(StructurePieceType pieceType, StructureManager structureManager, ResourceLocation templateName, BlockPos pos, Rotation rotation) {
            this(pieceType, 0, structureManager, templateName, pos, rotation);
        }

        public Piece(StructurePieceType pieceType, CompoundTag nbt, ServerLevel level) {
            super(pieceType, nbt, level, name -> Piece.getPlaceSettings(level.m_8875_(), name, new BlockPos(nbt.m_128451_("TPX"), nbt.m_128451_("TPY"), nbt.m_128451_("TPZ")), Rotation.valueOf((String)nbt.m_128461_("Rot"))));
        }

        protected static StructurePlaceSettings getPlaceSettings(StructureManager structureManager, ResourceLocation name, BlockPos pos, Rotation rotation) {
            Optional temp = structureManager.m_163774_(name);
            Vec3i size = Vec3i.f_123288_;
            if (temp.isPresent()) {
                size = ((StructureTemplate)temp.get()).m_163801_();
            }
            StructurePlaceSettings settings = new StructurePlaceSettings().m_163782_(false).m_74385_(new BlockPos(size.m_123341_() / 2, 0, size.m_123343_() / 2).m_7954_(rotation));
            settings.m_74383_((StructureProcessor)BlockIgnoreProcessor.f_74048_);
            settings.m_74383_((StructureProcessor)RemoveGelStructureProcessor.INSTANCE);
            return settings;
        }

        @ParametersAreNonnullByDefault
        protected void m_7756_(String key, BlockPos pos, ServerLevelAccessor world, Random rnd, BoundingBox box) {
        }
    }
}

