/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.registry.registrar;

import com.legacy.structure_gel.api.events.RegisterDimensionEvent;
import com.legacy.structure_gel.api.events.RegisterDimensionTypeEvent;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import java.util.function.Function;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraftforge.common.MinecraftForge;

public class DimensionRegistrar {
    private final ResourceKey<LevelStem> dimensionKey;
    private final ResourceKey<DimensionType> dimensionTypeKey;
    private final ResourceKey<NoiseGeneratorSettings> settingsKey;
    private final ResourceKey<Level> levelKey;
    private final DimensionType dimensionType;
    private final NoiseGeneratorSettings noiseSettings;
    private final Function<RegisterDimensionEvent, ChunkGenerator> chunkGenerator;

    public DimensionRegistrar(ResourceLocation registryName, DimensionType dimensionType, NoiseGeneratorSettings noiseSettings, Function<RegisterDimensionEvent, ChunkGenerator> chunkGenerator) {
        this.dimensionKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122820_, (ResourceLocation)registryName);
        this.dimensionTypeKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122818_, (ResourceLocation)registryName);
        this.settingsKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122878_, (ResourceLocation)registryName);
        this.levelKey = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)registryName);
        this.dimensionType = dimensionType;
        this.noiseSettings = noiseSettings;
        this.chunkGenerator = chunkGenerator;
        BuiltinRegistries.m_123880_((Registry)BuiltinRegistries.f_123866_, (ResourceLocation)registryName, (Object)this.noiseSettings);
        StructureGelMod.debug("Registered new dimension noise settings: {}", registryName);
        MinecraftForge.EVENT_BUS.addListener(this::registerDimension);
        MinecraftForge.EVENT_BUS.addListener(this::registerDimensionType);
    }

    public ResourceKey<LevelStem> getDimensionKey() {
        return this.dimensionKey;
    }

    public ResourceKey<DimensionType> getTypeKey() {
        return this.dimensionTypeKey;
    }

    public ResourceKey<NoiseGeneratorSettings> getSettingsKey() {
        return this.settingsKey;
    }

    public ResourceKey<Level> getLevelKey() {
        return this.levelKey;
    }

    public DimensionType getType() {
        return this.dimensionType;
    }

    public NoiseGeneratorSettings getSettings() {
        return this.noiseSettings;
    }

    public Function<RegisterDimensionEvent, ChunkGenerator> getChunkGenerator() {
        return this.chunkGenerator;
    }

    @Internal
    protected final void registerDimension(RegisterDimensionEvent event) {
        event.register(this.dimensionKey, new LevelStem(() -> this.dimensionType, this.chunkGenerator.apply(event)));
    }

    @Internal
    protected final void registerDimensionType(RegisterDimensionTypeEvent event) {
        event.register(this.dimensionTypeKey, this.dimensionType);
    }
}

