/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.GelStructure;
import com.legacy.structure_gel.core.structure.jigsaw.GelStructurePiece;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.core.RegistryAccess;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.feature.structures.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.StructurePieceAccessor;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public abstract class GelJigsawStructure
extends GelStructure<JigsawConfiguration> {
    public final int startY;
    public final boolean doExpansionHack;
    public final boolean projectStartToHeightmap;

    public GelJigsawStructure(Codec<JigsawConfiguration> codec, int startY, boolean doExpansionHack, boolean projectStartToHeightmap) {
        super(codec);
        this.startY = startY;
        this.doExpansionHack = doExpansionHack;
        this.projectStartToHeightmap = projectStartToHeightmap;
    }

    public JigsawPlacement.PieceFactory getPieceType() {
        return GelStructurePiece::new;
    }

    @Internal
    public PoolElementStructurePiece getPiece(StructureManager templateManager, StructurePoolElement jigsawPiece, BlockPos pos, int groundLevelDelta, Rotation rotation, BoundingBox bounds) {
        return this.getPieceType().m_68964_(templateManager, jigsawPiece, pos, groundLevelDelta, rotation, bounds);
    }

    public void handleStartFactory(GelJigsawStructureStart start, RegistryAccess dynamicRegistries, ChunkGenerator chunkGen, StructureManager templateManager, ChunkPos chunkPos, Biome biome, JigsawConfiguration config, LevelHeightAccessor level) {
        BlockPos blockpos = new BlockPos(chunkPos.f_45578_ * 16 + 8, start.jigsawStructure.startY, chunkPos.f_45579_ * 16 + 8);
        JigsawPlacement.m_161612_((RegistryAccess)dynamicRegistries, (JigsawConfiguration)config, start.jigsawStructure::getPiece, (ChunkGenerator)chunkGen, (StructureManager)templateManager, (BlockPos)blockpos, (StructurePieceAccessor)start, (Random)start.getRand(), (boolean)start.jigsawStructure.doExpansionHack, (boolean)start.jigsawStructure.projectStartToHeightmap, (LevelHeightAccessor)level);
    }

    @Internal
    public StructureFeature.StructureStartFactory<JigsawConfiguration> m_6258_() {
        return (structure, chunkPos, references, seed) -> new GelJigsawStructureStart(this, chunkPos, references, seed);
    }

    public static class GelJigsawStructureStart
    extends StructureStart<JigsawConfiguration> {
        public final GelJigsawStructure jigsawStructure;

        public GelJigsawStructureStart(GelJigsawStructure jigsawStructure, ChunkPos chunkPos, int references, long seed) {
            super((StructureFeature)jigsawStructure, chunkPos, references, seed);
            this.jigsawStructure = jigsawStructure;
        }

        public void generatePieces(RegistryAccess dynamicRegistries, ChunkGenerator chunkGen, StructureManager structureManager, ChunkPos chunkPos, Biome biome, JigsawConfiguration config, LevelHeightAccessor level) {
            this.jigsawStructure.handleStartFactory(this, dynamicRegistries, chunkGen, structureManager, chunkPos, biome, config, level);
        }

        public Random getRand() {
            return this.f_73564_;
        }

        public BlockPos m_7148_() {
            return new BlockPos((this.m_163625_().f_45578_ << 4) + 8, 0, (this.m_163625_().f_45579_ << 4) + 8);
        }
    }
}

