/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.api.structure;

import com.legacy.structure_gel.api.structure.StructureAccessHelper;
import com.legacy.structure_gel.core.StructureGelMod;
import com.legacy.structure_gel.core.util.Internal;
import com.mojang.serialization.Codec;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.StructureSpawnListGatherEvent;

public abstract class GelStructure<C extends FeatureConfiguration>
extends StructureFeature<C> {
    protected EnumMap<MobCategory, List<MobSpawnSettings.SpawnerData>> spawns = new EnumMap(MobCategory.class);
    protected Integer seed = null;
    protected int offset = -1;

    public GelStructure(Codec<C> codec) {
        super(codec);
        MinecraftForge.EVENT_BUS.addListener(this::potentialSpawnsEvent);
        this.setLakeProof(true);
    }

    public void setLakeProof(boolean lakeProof) {
        if (lakeProof) {
            StructureAccessHelper.addLakeProofStructure(this);
        } else {
            StructureAccessHelper.removeLakeProofStructure(this);
        }
    }

    public int getSeed() {
        if (this.seed == null) {
            if (this.getRegistryName() == null) {
                this.seed = Math.abs(((Object)((Object)this)).getClass().getCanonicalName().hashCode());
                StructureGelMod.logWarn("The structure {} does not have a registry name. Seed defaulted to {}. This should be avoided.", ((Object)((Object)this)).getClass().getName(), this.seed);
            } else {
                this.seed = Math.abs(this.getRegistryName().toString().hashCode());
            }
        }
        return this.seed;
    }

    public float getProbability() {
        return 1.0f;
    }

    public abstract int getSpacing();

    public int getOffset() {
        return this.getSpacing() - 2;
    }

    @Internal
    private int getSafeOffset() {
        if (this.offset < 0) {
            this.offset = Mth.m_14045_((int)(this.getOffset() - 2), (int)0, (int)this.getSpacing());
        }
        return this.offset;
    }

    @Nullable
    public Set<ResourceLocation> getValidDimensions() {
        return null;
    }

    public boolean isAllowedNearWorldSpawn() {
        return false;
    }

    @Nullable
    public List<MobSpawnSettings.SpawnerData> getSpawns(MobCategory category) {
        try {
            return this.spawns.get(category);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            EnumMap<MobCategory, List<MobSpawnSettings.SpawnerData>> newSpawns = new EnumMap<MobCategory, List<MobSpawnSettings.SpawnerData>>(MobCategory.class);
            for (Map.Entry<MobCategory, List<MobSpawnSettings.SpawnerData>> entry : this.spawns.entrySet()) {
                newSpawns.put(entry.getKey(), entry.getValue());
            }
            this.spawns = newSpawns;
            return this.spawns.get(category);
        }
    }

    @Internal
    protected void potentialSpawnsEvent(StructureSpawnListGatherEvent event) {
        if (event.getStructure() == this) {
            event.setInsideOnly(this.getDefaultRestrictsSpawnsToInside());
            for (MobCategory category : MobCategory.values()) {
                List<MobSpawnSettings.SpawnerData> spawnerList = this.getSpawns(category);
                if (spawnerList == null) continue;
                event.addEntitySpawns(category, spawnerList);
            }
        }
    }

    public ChunkPos m_67067_(@Nullable StructureFeatureConfiguration settings, long seed, WorldgenRandom rand, int chunkX, int chunkZ) {
        int spacing = this.getSpacing();
        int gridX = (int)Math.floor((float)chunkX / (float)spacing) * spacing;
        int gridZ = (int)Math.floor((float)chunkZ / (float)spacing) * spacing;
        int offset = this.getSafeOffset() + 1;
        rand.m_64694_(seed, gridX, gridZ, this.getSeed());
        return new ChunkPos(gridX + rand.nextInt(offset), gridZ + rand.nextInt(offset));
    }

    protected boolean m_142290_(ChunkGenerator chunkGen, BiomeSource biomeSource, long seed, WorldgenRandom rand, ChunkPos chunkPos, Biome biome, ChunkPos potentialChunkPos, C config, LevelHeightAccessor level) {
        float probability;
        if (!this.isAllowedNearWorldSpawn()) {
            int x = potentialChunkPos.f_45578_;
            int z = potentialChunkPos.f_45579_;
            int range = 12;
            if (x < range && x > -range && z < range && z > -range) {
                return false;
            }
        }
        if ((probability = this.getProbability()) == 1.0f) {
            return true;
        }
        rand.m_64694_(seed, chunkPos.f_45578_, chunkPos.f_45579_, this.getSeed());
        return rand.nextFloat() < probability;
    }

    @Internal
    public final BlockPos m_67046_(LevelReader level, StructureFeatureManager structureManager, BlockPos startPos, int searchRadius, boolean skipExistingChunks, long seed, @Nullable StructureFeatureConfiguration settings) {
        if (this.getProbability() == 0.0f) {
            return null;
        }
        return super.m_67046_(level, structureManager, startPos, searchRadius, skipExistingChunks, seed, this.getFeatureConfiguration());
    }

    @Internal
    public StructureFeatureConfiguration getFeatureConfiguration() {
        return new StructureFeatureConfiguration(this.getSpacing(), this.getSafeOffset(), this.getSeed());
    }
}

