/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core;

import com.legacy.structure_gel.core.util.AbstractConfigUtil;
import com.legacy.structure_gel.core.util.Internal;
import java.util.ArrayList;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.commons.lang3.tuple.Pair;

@Internal
public class SGConfig {
    public static final Common COMMON;
    public static final Client CLIENT;
    protected static final ForgeConfigSpec COMMON_SPEC;
    protected static final ForgeConfigSpec CLIENT_SPEC;

    static {
        Pair specPairCommon = new ForgeConfigSpec.Builder().configure(Common::new);
        COMMON_SPEC = (ForgeConfigSpec)specPairCommon.getRight();
        COMMON = (Common)specPairCommon.getLeft();
        Pair specPairClient = new ForgeConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Common
    extends AbstractConfigUtil {
        private final Storage storage = new Storage();
        private final ForgeConfigSpec.ConfigValue<List<? extends String>> biomeDictIgnoredMods;
        private final ForgeConfigSpec.BooleanValue biomeDictBestGuess;
        private final ForgeConfigSpec.BooleanValue exceedFillLimit;
        private final ForgeConfigSpec.BooleanValue extraLakeProofing;
        private final ForgeConfigSpec.BooleanValue consoleDebug;

        public Common(ForgeConfigSpec.Builder builder) {
            super("structure_gel common");
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
            builder.push("biome_dictionary");
            this.biomeDictIgnoredMods = builder.comment(this.configComment("A list of mod IDs that will be ignored when the biome dictionary attempts to register unregistered biomes.", this.storage.biomeDictIgnoredMods, "[\"biomesoplenty\", \"byg\", \"autumnity\"]")).defineList("ignored_mods", this.storage.biomeDictIgnoredMods, o -> true);
            this.biomeDictBestGuess = builder.comment(this.configComment("Determines if the biome dictionary should make assumptions for unregistered biomes. Setting this to false can fix issues where a structure generates weird biomes.", this.storage.biomeDictBestGuess)).define("make_best_guess", this.storage.biomeDictBestGuess);
            builder.pop();
            builder.push("vanilla_enhancements");
            this.exceedFillLimit = builder.comment(this.configComment("When true, removes the size limit from the fill and clone commands.", this.storage.exceedFillLimit)).define("exceed_fill_and_clone_limit", this.storage.exceedFillLimit);
            this.extraLakeProofing = builder.comment(this.configComment("Adds more vanilla structures to the list of structures that lakes cannot generate inside of. Only villages when set to false. Requires reload.", this.storage.extraLakeProofing)).define("extra_lake_proofing", this.storage.extraLakeProofing);
            builder.pop();
            builder.push("console_debug");
            this.consoleDebug = builder.comment(this.configComment("When true, allows extra debug logging to be printed to the console.", this.storage.consoleDebug)).define("console_debug", this.storage.consoleDebug);
            builder.pop();
        }

        public List<? extends String> getIgnoredMods() {
            return this.storage.biomeDictIgnoredMods;
        }

        public boolean shouldGuessBiomeDict() {
            return this.storage.biomeDictBestGuess;
        }

        public boolean shouldExceedFillLimit() {
            return this.storage.exceedFillLimit;
        }

        public boolean getExtraLakeProofing() {
            return this.storage.extraLakeProofing;
        }

        public boolean consoleDebug() {
            return this.storage.consoleDebug;
        }

        protected void onConfigLoad(ModConfigEvent event) {
            this.storage.biomeDictIgnoredMods = (List)this.biomeDictIgnoredMods.get();
            this.storage.biomeDictBestGuess = (Boolean)this.biomeDictBestGuess.get();
            this.storage.exceedFillLimit = (Boolean)this.exceedFillLimit.get();
            this.storage.extraLakeProofing = (Boolean)this.extraLakeProofing.get();
            this.storage.consoleDebug = (Boolean)this.consoleDebug.get();
        }

        private static class Storage {
            private List<? extends String> biomeDictIgnoredMods = new ArrayList<String>();
            private boolean biomeDictBestGuess = true;
            private boolean exceedFillLimit = true;
            private boolean extraLakeProofing = true;
            private boolean consoleDebug = false;

            private Storage() {
            }
        }
    }

    public static class Client
    extends AbstractConfigUtil {
        private final Storage storage = new Storage();
        private final ForgeConfigSpec.BooleanValue skipExperimentalBackupScreen;
        private final ForgeConfigSpec.BooleanValue showStructureBlockInfo;

        public Client(ForgeConfigSpec.Builder builder) {
            super("structure_gel client");
            FMLJavaModLoadingContext.get().getModEventBus().addListener(this::onConfigLoad);
            builder.push("gui");
            this.skipExperimentalBackupScreen = builder.comment(this.configComment("Skips the screen that tells you that a world uses experimental settings.", this.storage.skipExperimentalBackupScreen)).define("skip_experimental_backup_screen", this.storage.skipExperimentalBackupScreen);
            builder.pop();
            builder.push("rendering");
            this.showStructureBlockInfo = builder.comment(this.configComment("Displays info on top of Structure Blocks and Jigsaws in world.", this.storage.showStructureBlockInfo)).define("show_structure_block_info", this.storage.showStructureBlockInfo);
            builder.pop();
        }

        public boolean skipExperimentalScreen() {
            return this.storage.skipExperimentalBackupScreen;
        }

        public boolean showStructureBlockInfo() {
            return this.storage.showStructureBlockInfo;
        }

        protected void onConfigLoad(ModConfigEvent event) {
            this.storage.skipExperimentalBackupScreen = (Boolean)this.skipExperimentalBackupScreen.get();
            this.storage.showStructureBlockInfo = (Boolean)this.showStructureBlockInfo.get();
        }

        private static class Storage {
            private boolean skipExperimentalBackupScreen = true;
            private boolean showStructureBlockInfo = true;

            private Storage() {
            }
        }
    }
}

