/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.commands;

import com.legacy.structure_gel.core.StructureGelMod;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.ResourceLocationArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.StructureFeatureManager;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureManager;

public class GenerateStructureCommand {
    public static boolean overrideHeightmap = false;
    public static final SuggestionProvider<CommandSourceStack> STRUCTURES = SuggestionProviders.m_121658_((ResourceLocation)StructureGelMod.locate("structures"), (context, builder) -> SharedSuggestionProvider.m_82926_((Iterable)BuiltinRegistries.f_123862_.m_6566_(), (SuggestionsBuilder)builder));

    public static LiteralArgumentBuilder<CommandSourceStack> get() {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)Commands.m_82127_((String)"generatestructure").requires(source -> source.m_6761_(2));
        command.then(Commands.m_82129_((String)"pos", (ArgumentType)BlockPosArgument.m_118239_()).then(((RequiredArgumentBuilder)Commands.m_82129_((String)"structure", (ArgumentType)ResourceLocationArgument.m_106984_()).suggests(STRUCTURES).executes(context -> GenerateStructureCommand.generateStructure((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), (ResourceLocation)context.getArgument("structure", ResourceLocation.class), null))).then(Commands.m_82129_((String)"seed", (ArgumentType)StringArgumentType.word()).executes(context -> GenerateStructureCommand.generateStructure((CommandContext<CommandSourceStack>)context, BlockPosArgument.m_118242_((CommandContext)context, (String)"pos"), (ResourceLocation)context.getArgument("structure", ResourceLocation.class), StringArgumentType.getString((CommandContext)context, (String)"seed"))))));
        return command;
    }

    private static int generateStructure(CommandContext<CommandSourceStack> context, BlockPos pos, ResourceLocation structureName, @Nullable String seedString) {
        ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Placing " + structureName.toString() + " at " + pos.m_123344_() + (String)(seedString != null ? " with seed " + seedString : "") + " ..."), true);
        ConfiguredStructureFeature structure = (ConfiguredStructureFeature)BuiltinRegistries.f_123862_.m_7745_(structureName);
        if (structure != null) {
            try {
                Random rand;
                ChunkPos chunkPos = new ChunkPos(pos);
                ServerLevel level = ((CommandSourceStack)context.getSource()).m_81372_();
                Biome biome = level.m_46857_(pos);
                ChunkGenerator chunkGen = level.m_7726_().m_8481_();
                StructureManager templateManager = level.m_8875_();
                StructureFeatureManager structureManager = level.m_8595_();
                Integer seed = null;
                if (seedString != null) {
                    seed = seedString.hashCode();
                    rand = new Random(seed.intValue());
                } else {
                    rand = level.m_5822_();
                }
                StructureStart start = structure.f_65403_.m_6258_().m_160478_(structure.f_65403_, chunkPos, 80, 0L);
                if (seed != null) {
                    start.f_73564_.setSeed((long)seed.intValue());
                }
                StructureGelMod.log("Running \"/structure_gel generatestructure\". Temporarily changing how heightmaps work. If you encounter a crash during this time, this is why. Try not to generate chunks while this command is running.", new Object[0]);
                overrideHeightmap = true;
                start.m_142743_(level.m_5962_(), chunkGen, templateManager, chunkPos, biome, structure.f_65404_, (LevelHeightAccessor)level);
                for (Object piece : start.m_73602_()) {
                    if (!(piece instanceof StructurePiece)) continue;
                    ((StructurePiece)piece).m_7832_((WorldGenLevel)level, structureManager, chunkGen, rand, BoundingBox.m_71044_(), chunkPos, pos);
                }
                overrideHeightmap = false;
                StructureGelMod.log("Finished changing how heightmaps work.", new Object[0]);
                ((CommandSourceStack)context.getSource()).m_81354_((Component)new TextComponent("Finished placing " + structureName.toString()), true);
            }
            catch (Throwable e) {
                overrideHeightmap = false;
                String message = "Encountered an error while placing " + structureName.toString();
                ((CommandSourceStack)context.getSource()).m_81352_((Component)new TextComponent(message));
                StructureGelMod.logError(message, e);
                return 0;
            }
            overrideHeightmap = false;
            return 1;
        }
        overrideHeightmap = false;
        return 0;
    }
}

