/*
 * Decompiled with CFR 0.152.
 */
package com.legacy.structure_gel.core.util;

import com.legacy.structure_gel.core.StructureGelMod;
import java.util.List;
import java.util.stream.Collectors;

public abstract class AbstractConfigUtil {
    protected final String name;

    public AbstractConfigUtil(String name) {
        this.name = name;
    }

    protected String configComment(String description, Object defaultVal, Object example) {
        return String.format("\n %s\n Example: %s\n Default: %s", description, example.toString(), this.defaultValString(defaultVal));
    }

    protected String configComment(String description, Object defaultVal) {
        return String.format("\n %s\n Default: %s", description.toString(), this.defaultValString(defaultVal));
    }

    protected String defaultValString(Object defaultVal) {
        String str = defaultVal.toString();
        if (defaultVal instanceof List) {
            return ((List)defaultVal).stream().map(o -> {
                if (o instanceof String) {
                    return "\"" + o.toString() + "\"";
                }
                return o.toString();
            }).collect(Collectors.toList()).toString();
        }
        return str;
    }

    protected void logResourceLocationError(String invalidResourceLocation, String message) {
        StructureGelMod.logError("An invalid character exists in the config for " + this.name + ". It was " + invalidResourceLocation + ". " + message, new Object[0]);
    }
}

