/*
 * Decompiled with CFR 0.152.
 */
package terrablender.api;

import com.mojang.serialization.Lifecycle;
import java.util.function.Supplier;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import terrablender.core.TerraBlender;
import terrablender.worldgen.TBMultiNoiseBiomeSource;
import terrablender.worldgen.TBNoiseBasedChunkGenerator;
import terrablender.worldgen.TBNoiseGeneratorSettings;

public class WorldPresetUtils {
    public static ChunkGenerator overworldChunkGenerator(RegistryAccess dynamicRegistries, long seed) {
        return WorldPresetUtils.chunkGenerator(dynamicRegistries, seed, () -> (NoiseGeneratorSettings)dynamicRegistries.m_175515_(Registry.f_122878_).m_123013_(TBNoiseGeneratorSettings.OVERWORLD));
    }

    public static ChunkGenerator largeBiomesChunkGenerator(RegistryAccess dynamicRegistries, long seed) {
        return WorldPresetUtils.chunkGenerator(dynamicRegistries, seed, () -> (NoiseGeneratorSettings)dynamicRegistries.m_175515_(Registry.f_122878_).m_123013_(TBNoiseGeneratorSettings.LARGE_BIOMES));
    }

    public static ChunkGenerator amplifiedChunkGenerator(RegistryAccess dynamicRegistries, long seed) {
        return WorldPresetUtils.chunkGenerator(dynamicRegistries, seed, () -> (NoiseGeneratorSettings)dynamicRegistries.m_175515_(Registry.f_122878_).m_123013_(TBNoiseGeneratorSettings.AMPLIFIED));
    }

    public static ChunkGenerator netherChunkGenerator(RegistryAccess dynamicRegistries, long seed) {
        Supplier<NoiseGeneratorSettings> noiseGeneratorSettingsSupplier = () -> (NoiseGeneratorSettings)dynamicRegistries.m_175515_(Registry.f_122878_).m_123013_(TBNoiseGeneratorSettings.NETHER);
        return new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)dynamicRegistries.m_175515_(Registry.f_194568_), TBMultiNoiseBiomeSource.Preset.NETHER.biomeSource((Registry<Biome>)dynamicRegistries.m_175515_(Registry.f_122885_), false), seed, noiseGeneratorSettingsSupplier);
    }

    public static WorldGenSettings settings(RegistryAccess dynamicRegistries, long seed, boolean generateFeatures, boolean bonusChest, MappedRegistry<LevelStem> dimensions, ChunkGenerator chunkGenerator) {
        Registry dimensionTypeRegistry = dynamicRegistries.m_175515_(Registry.f_122818_);
        return new WorldGenSettings(seed, generateFeatures, bonusChest, WorldGenSettings.m_64633_((Registry)dimensionTypeRegistry, dimensions, (ChunkGenerator)chunkGenerator));
    }

    public static ChunkGenerator chunkGenerator(RegistryAccess dynamicRegistries, long seed, Supplier<NoiseGeneratorSettings> noiseGeneratorSettingsSupplier) {
        return new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)dynamicRegistries.m_175515_(Registry.f_194568_), TBMultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource((Registry<Biome>)dynamicRegistries.m_175515_(Registry.f_122885_), false), seed, noiseGeneratorSettingsSupplier);
    }

    public static MappedRegistry<LevelStem> dimensions(RegistryAccess dynamicRegistries, long seed) {
        MappedRegistry dimensions = DimensionType.m_188317_((RegistryAccess)dynamicRegistries, (long)seed);
        Registry dimensionTypeRegistry = dynamicRegistries.m_175515_(Registry.f_122818_);
        if (TerraBlender.CONFIG.replaceDefaultNether) {
            MappedRegistry newDimensions = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental());
            dimensions.m_6579_().stream().filter(entry -> entry.getKey() != LevelStem.f_63972_).forEach(entry -> newDimensions.m_7135_((ResourceKey)entry.getKey(), (Object)((LevelStem)entry.getValue()), Lifecycle.stable()));
            newDimensions.m_7135_(LevelStem.f_63972_, (Object)new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_123013_(DimensionType.f_63846_), WorldPresetUtils.netherChunkGenerator(dynamicRegistries, seed)), Lifecycle.stable());
            dimensions = newDimensions;
        }
        return dimensions;
    }
}

