/*
 * Decompiled with CFR 0.152.
 */
package terrablender.command;

import com.mojang.brigadier.Message;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.biome.BiomeManager;
import net.minecraft.world.level.chunk.ChunkGenerator;
import terrablender.worldgen.TBClimate;
import terrablender.worldgen.TBNoiseBasedChunkGenerator;

public class CommandBiomeParameters {
    private static final SimpleCommandExceptionType ERROR_FAILED = new SimpleCommandExceptionType((Message)new TranslatableComponent("commands.terrablender.biomeparams.failed"));

    public static ArgumentBuilder<CommandSourceStack, ?> register() {
        return Commands.m_82127_((String)"biomeparams").executes(ctx -> CommandBiomeParameters.biomeParams((CommandSourceStack)ctx.getSource()));
    }

    private static int biomeParams(CommandSourceStack cs) throws CommandSyntaxException {
        BlockPos pos = new BlockPos(cs.m_81371_());
        ServerLevel level = cs.m_81372_();
        ChunkGenerator generator = level.m_7726_().m_8481_();
        if (!(generator instanceof TBNoiseBasedChunkGenerator)) {
            throw ERROR_FAILED.create();
        }
        BiomeManager biomeManager = level.m_7062_();
        TBNoiseBasedChunkGenerator noiseBasedChunkGenerator = (TBNoiseBasedChunkGenerator)generator;
        TBClimate.Sampler sampler = (TBClimate.Sampler)noiseBasedChunkGenerator.m_183403_();
        BlockPos adjustedPos = CommandBiomeParameters.getAdjustedPos(pos, biomeManager.f_47863_);
        TBClimate.TargetPoint target = sampler.sampleTB(adjustedPos.m_123341_(), adjustedPos.m_123342_(), adjustedPos.m_123343_());
        cs.m_81354_((Component)new TranslatableComponent("commands.terrablender.biomeparams.success", new Object[]{pos.m_123341_(), pos.m_123342_(), pos.m_123343_(), target.toString().replace("TargetPoint[", "").replace("]", " ")}), true);
        return 1;
    }

    private static BlockPos getAdjustedPos(BlockPos pos, long seed) {
        int i = pos.m_123341_() - 2;
        int j = pos.m_123342_() - 2;
        int k = pos.m_123343_() - 2;
        int l = i >> 2;
        int i1 = j >> 2;
        int j1 = k >> 2;
        double d0 = (double)(i & 3) / 4.0;
        double d1 = (double)(j & 3) / 4.0;
        double d2 = (double)(k & 3) / 4.0;
        int k1 = 0;
        double d3 = Double.POSITIVE_INFINITY;
        for (int l1 = 0; l1 < 8; ++l1) {
            double d6;
            double d5;
            double d4;
            boolean flag2;
            int k2;
            boolean flag1;
            int j2;
            boolean flag = (l1 & 4) == 0;
            int i2 = flag ? l : l + 1;
            double d7 = BiomeManager.m_186679_((long)seed, (int)i2, (int)(j2 = (flag1 = (l1 & 2) == 0) ? i1 : i1 + 1), (int)(k2 = (flag2 = (l1 & 1) == 0) ? j1 : j1 + 1), (double)(d4 = flag ? d0 : d0 - 1.0), (double)(d5 = flag1 ? d1 : d1 - 1.0), (double)(d6 = flag2 ? d2 : d2 - 1.0));
            if (!(d3 > d7)) continue;
            k1 = l1;
            d3 = d7;
        }
        int l2 = (k1 & 4) == 0 ? l : l + 1;
        int i3 = (k1 & 2) == 0 ? i1 : i1 + 1;
        int j3 = (k1 & 1) == 0 ? j1 : j1 + 1;
        return new BlockPos(l2, i3, j3);
    }
}

