/*
 * Decompiled with CFR 0.152.
 */
package terrablender.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.Lifecycle;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.core.MappedRegistry;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.RegistryReadOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.dimension.LevelStem;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.SurfaceRules;
import net.minecraft.world.level.levelgen.WorldGenSettings;
import net.minecraft.world.level.levelgen.synth.NormalNoise;
import terrablender.api.BiomeProvider;
import terrablender.api.BiomeProviders;
import terrablender.core.TerraBlender;
import terrablender.worldgen.BiomeProviderUtils;
import terrablender.worldgen.DataPackBiomeProvider;
import terrablender.worldgen.TBMultiNoiseBiomeSource;
import terrablender.worldgen.TBNoiseBasedChunkGenerator;
import terrablender.worldgen.TBNoiseGeneratorSettings;

public class DataPackManager {
    public static final ResourceLocation DATA_PACK_PROVIDER_LOCATION = new ResourceLocation("datapack:biome_provider");
    private static final Codec<WorldGenSettings> DIRECT_WGS_CODEC = RecordCodecBuilder.create(p_64626_ -> p_64626_.group((App)Codec.LONG.fieldOf("seed").stable().forGetter(WorldGenSettings::m_64619_), (App)Codec.BOOL.fieldOf("generate_features").orElse((Object)true).stable().forGetter(WorldGenSettings::m_64657_), (App)Codec.BOOL.fieldOf("bonus_chest").orElse((Object)false).stable().forGetter(WorldGenSettings::m_64660_), (App)MappedRegistry.m_122756_((ResourceKey)Registry.f_122820_, (Lifecycle)Lifecycle.stable(), (Codec)LevelStem.f_63970_).xmap(LevelStem::m_63987_, Function.identity()).fieldOf("dimensions").forGetter(WorldGenSettings::m_64663_), (App)Codec.STRING.optionalFieldOf("legacy_custom_options").stable().forGetter(p_158959_ -> p_158959_.f_64606_)).apply((Applicative)p_64626_, p_64626_.stable(WorldGenSettings::new))).comapFlatMap(WorldGenSettings::m_64674_, Function.identity());

    public static WorldGenSettings mergeWorldGenSettings(RegistryAccess registryAccess, WorldGenSettings currentSettings, WorldGenSettings newSettings) {
        if (!DataPackManager.shouldAttemptMerge(newSettings)) {
            return newSettings;
        }
        boolean shouldMergeOverworld = DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63971_, newSettings);
        boolean shouldMergeNether = DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63972_, newSettings);
        int overworldWeight = shouldMergeOverworld ? TerraBlender.CONFIG.datapackOverworldRegionWeight : 0;
        int netherWeight = shouldMergeNether && TerraBlender.CONFIG.replaceDefaultNether ? TerraBlender.CONFIG.datapackNetherRegionWeight : 0;
        DataPackBiomeProvider dataPackBiomeProvider = new DataPackBiomeProvider(DATA_PACK_PROVIDER_LOCATION, overworldWeight, netherWeight, newSettings);
        BiomeProviders.register(DATA_PACK_PROVIDER_LOCATION, dataPackBiomeProvider);
        Registry dimensionTypeRegistry = registryAccess.m_175515_(Registry.f_122818_);
        MappedRegistry dimensions = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental());
        for (Map.Entry entry : newSettings.m_64663_().m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            if (key == LevelStem.f_63971_ && shouldMergeOverworld) {
                stem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_123013_(DimensionType.f_63845_), DataPackManager.createdMergedChunkGenerator((ResourceKey<LevelStem>)LevelStem.f_63971_, registryAccess, currentSettings, newSettings, dataPackBiomeProvider, provider -> BiomeProviderUtils.createOverworldRules(provider.getOverworldSurfaceRules().get()), TBNoiseGeneratorSettings::overworld, TBMultiNoiseBiomeSource.Preset.OVERWORLD));
            } else if (key == LevelStem.f_63972_ && shouldMergeNether) {
                stem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_123013_(DimensionType.f_63846_), DataPackManager.createdMergedChunkGenerator((ResourceKey<LevelStem>)LevelStem.f_63972_, registryAccess, currentSettings, newSettings, dataPackBiomeProvider, provider -> BiomeProviderUtils.createNetherRules(provider.getNetherSurfaceRules().get()), TBNoiseGeneratorSettings::nether, TBMultiNoiseBiomeSource.Preset.NETHER));
            }
            dimensions.m_7135_(key, (Object)stem, Lifecycle.stable());
        }
        TerraBlender.LOGGER.info("Merged generation settings with datapack");
        return new WorldGenSettings(currentSettings.m_64619_(), currentSettings.m_64657_(), currentSettings.m_64660_(), dimensions);
    }

    public static <T> DataResult replaceDatapackWorldGenSettings(Dynamic<T> dynamicWorldGenSettings) {
        RegistryAccess registryAccess = ((RegistryReadOps)dynamicWorldGenSettings.getOps()).f_179860_;
        DataResult directWorldGenSettingsResult = DIRECT_WGS_CODEC.parse(dynamicWorldGenSettings);
        DataResult dataPackedWorldGenSettingsResult = WorldGenSettings.f_64600_.parse(dynamicWorldGenSettings);
        Optional directWorldGenSettingsOptional = directWorldGenSettingsResult.result();
        Optional dataPackedWorldGenSettingsOptional = dataPackedWorldGenSettingsResult.result();
        if (directWorldGenSettingsOptional.isPresent() && (dataPackedWorldGenSettingsOptional.isEmpty() || DataPackManager.shouldAttemptMerge((WorldGenSettings)dataPackedWorldGenSettingsOptional.get()))) {
            boolean forceDiscrepencyCorrection = false;
            if (dataPackedWorldGenSettingsOptional.isPresent()) {
                TerraBlender.LOGGER.info("Using merged world generation settings");
                WorldGenSettings datapackSettings = (WorldGenSettings)dataPackedWorldGenSettingsOptional.get();
                int overworldWeight = DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63971_, datapackSettings) ? TerraBlender.CONFIG.datapackOverworldRegionWeight : 0;
                int netherWeight = DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63972_, datapackSettings) && TerraBlender.CONFIG.replaceDefaultNether ? TerraBlender.CONFIG.datapackNetherRegionWeight : 0;
                BiomeProviders.register(new DataPackBiomeProvider(DATA_PACK_PROVIDER_LOCATION, overworldWeight, netherWeight, (WorldGenSettings)dataPackedWorldGenSettingsOptional.get()));
                forceDiscrepencyCorrection = true;
            } else {
                TerraBlender.LOGGER.info("Using direct world generation settings without merging");
            }
            return DataPackManager.correctParameterDiscrepancies(registryAccess, (WorldGenSettings)directWorldGenSettingsOptional.get(), forceDiscrepencyCorrection);
        }
        if (dataPackedWorldGenSettingsOptional.isPresent()) {
            TerraBlender.LOGGER.info("Using original world generation settings");
            return DataPackManager.correctParameterDiscrepancies(registryAccess, (WorldGenSettings)dataPackedWorldGenSettingsOptional.get(), false);
        }
        return dataPackedWorldGenSettingsResult;
    }

    private static ChunkGenerator createdMergedChunkGenerator(ResourceKey<LevelStem> key, RegistryAccess registryAccess, WorldGenSettings currentSettings, WorldGenSettings newSettings, BiomeProvider biomeProvider, Function<BiomeProvider, SurfaceRules.RuleSource> getSurfaceRules, BiFunction<NoiseSettings, SurfaceRules.RuleSource, NoiseGeneratorSettings> createNoiseGeneratorSettings, TBMultiNoiseBiomeSource.Preset preset) {
        ChunkGenerator newChunkGenerator = DataPackManager.chunkGeneratorForStem(key, newSettings);
        if (newChunkGenerator == null) {
            throw new IllegalStateException("Attempted to merge chunk generator for missing level stem");
        }
        if (!(newChunkGenerator instanceof NoiseBasedChunkGenerator)) {
            return newChunkGenerator;
        }
        NoiseBasedChunkGenerator newNoiseBasedChunkGenerator = (NoiseBasedChunkGenerator)newChunkGenerator;
        NoiseGeneratorSettings newNoiseGeneratorSettings = (NoiseGeneratorSettings)newNoiseBasedChunkGenerator.f_64318_.get();
        SurfaceRules.RuleSource surfaceRules = getSurfaceRules.apply(biomeProvider);
        NoiseGeneratorSettings mergedNoiseGeneratorSettings = createNoiseGeneratorSettings.apply(newNoiseGeneratorSettings.m_64481_(), surfaceRules);
        return new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)registryAccess.m_175515_(Registry.f_194568_), preset.biomeSource((Registry<Biome>)registryAccess.m_175515_(Registry.f_122885_), false), currentSettings.m_64619_(), () -> mergedNoiseGeneratorSettings);
    }

    private static boolean shouldAttemptMerge(WorldGenSettings settings) {
        return DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63971_, settings) || DataPackManager.shouldMergeStem((ResourceKey<LevelStem>)LevelStem.f_63972_, settings);
    }

    private static boolean shouldMergeStem(ResourceKey<LevelStem> key, WorldGenSettings settings) {
        ChunkGenerator generator = DataPackManager.chunkGeneratorForStem(key, settings);
        return generator != null && generator.m_62218_() instanceof MultiNoiseBiomeSource && !(generator.m_62218_() instanceof TBMultiNoiseBiomeSource);
    }

    private static ChunkGenerator chunkGeneratorForStem(ResourceKey<LevelStem> key, WorldGenSettings settings) {
        LevelStem stem = (LevelStem)settings.m_64663_().m_6246_(key);
        return stem == null ? null : stem.m_63990_();
    }

    private static DataResult<WorldGenSettings> correctParameterDiscrepancies(RegistryAccess registryAccess, WorldGenSettings settings, boolean forceDiscrepancyCorrection) {
        Registry biomeRegistry = registryAccess.m_175515_(Registry.f_122885_);
        Registry dimensionTypeRegistry = registryAccess.m_175515_(Registry.f_122818_);
        MappedRegistry dimensions = new MappedRegistry(Registry.f_122820_, Lifecycle.experimental());
        for (Map.Entry entry : settings.m_64663_().m_6579_()) {
            ResourceKey key = (ResourceKey)entry.getKey();
            LevelStem stem = (LevelStem)entry.getValue();
            if (key == LevelStem.f_63971_ && (DataPackManager.shouldCorrectUniquenessDiscrepancy(stem.m_63990_(), BiomeProvider::getOverworldWeight) || DataPackManager.isChunkGeneratorCorrectable(stem.m_63990_()) && forceDiscrepancyCorrection)) {
                chunkGenerator = (TBNoiseBasedChunkGenerator)stem.m_63990_();
                stem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_123013_(DimensionType.f_63845_), (ChunkGenerator)new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)chunkGenerator.f_188604_, TBMultiNoiseBiomeSource.Preset.OVERWORLD.biomeSource((Registry<Biome>)biomeRegistry, false), chunkGenerator.f_64333_, chunkGenerator.f_64318_));
            } else if (key == LevelStem.f_63972_ && (DataPackManager.shouldCorrectUniquenessDiscrepancy(stem.m_63990_(), BiomeProvider::getNetherWeight) || DataPackManager.isChunkGeneratorCorrectable(stem.m_63990_()) && forceDiscrepancyCorrection)) {
                chunkGenerator = (TBNoiseBasedChunkGenerator)stem.m_63990_();
                stem = new LevelStem(() -> (DimensionType)dimensionTypeRegistry.m_123013_(DimensionType.f_63846_), (ChunkGenerator)new TBNoiseBasedChunkGenerator((Registry<NormalNoise.NoiseParameters>)chunkGenerator.f_188604_, TBMultiNoiseBiomeSource.Preset.NETHER.biomeSource((Registry<Biome>)biomeRegistry, false), chunkGenerator.f_64333_, chunkGenerator.f_64318_));
            }
            dimensions.m_7135_(key, (Object)stem, Lifecycle.stable());
        }
        return DataResult.success((Object)new WorldGenSettings(settings.m_64619_(), settings.m_64657_(), settings.m_64660_(), dimensions));
    }

    private static boolean shouldCorrectUniquenessDiscrepancy(ChunkGenerator chunkGenerator, Function<BiomeProvider, Integer> getWeight) {
        if (!DataPackManager.isChunkGeneratorCorrectable(chunkGenerator)) {
            return false;
        }
        TBNoiseBasedChunkGenerator noiseBasedChunkGenerator = (TBNoiseBasedChunkGenerator)chunkGenerator;
        TBMultiNoiseBiomeSource multiNoiseBiomeSource = (TBMultiNoiseBiomeSource)noiseBasedChunkGenerator.m_62218_();
        List<Integer> uniquenessValues = BiomeProviderUtils.getUniquenessValues(multiNoiseBiomeSource.parameters().values());
        if (TerraBlender.CONFIG.forceResetBiomeParameters) {
            TerraBlender.LOGGER.info("Forcibly resetting biome parameters");
            return true;
        }
        int currentUniquenessCount = uniquenessValues.size();
        int expectedUniquenessCount = 0;
        for (BiomeProvider provider : BiomeProviders.get()) {
            if (getWeight.apply(provider) <= 0) continue;
            ++expectedUniquenessCount;
        }
        if (currentUniquenessCount != expectedUniquenessCount) {
            TerraBlender.LOGGER.warn("Discrepancy detected between current uniqueness count " + currentUniquenessCount + " and expected uniqueness count " + expectedUniquenessCount);
            return true;
        }
        return false;
    }

    private static boolean isChunkGeneratorCorrectable(ChunkGenerator chunkGenerator) {
        return chunkGenerator != null && chunkGenerator instanceof TBNoiseBasedChunkGenerator && chunkGenerator.m_62218_() instanceof TBMultiNoiseBiomeSource;
    }
}

