/*
 * Decompiled with CFR 0.152.
 */
package terrablender.worldgen;

import java.util.function.Supplier;
import net.minecraft.core.QuartPos;
import net.minecraft.util.Mth;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.levelgen.Aquifer;
import net.minecraft.world.level.levelgen.NoiseChunk;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseSampler;
import net.minecraft.world.level.levelgen.NoiseSettings;
import net.minecraft.world.level.levelgen.TerrainInfo;
import net.minecraft.world.level.levelgen.blending.Blender;
import terrablender.worldgen.TBNoiseSampler;

public class TBNoiseChunk
extends NoiseChunk {
    private final TBNoiseSampler.TBFlatNoiseData[][] tbNoiseData;

    public static TBNoiseChunk forChunk(ChunkAccess chunkAccess, TBNoiseSampler sampler, Supplier<NoiseChunk.NoiseFiller> noiseFiller, NoiseGeneratorSettings noiseGenSettings, Aquifer.FluidPicker p_188778_, Blender blender) {
        ChunkPos chunkpos = chunkAccess.m_7697_();
        NoiseSettings noisesettings = noiseGenSettings.m_64481_();
        int i = Math.max(noisesettings.f_158688_(), chunkAccess.m_141937_());
        int j = Math.min(noisesettings.f_158688_() + noisesettings.f_64508_(), chunkAccess.m_151558_());
        int cellNoiseMinY = Mth.m_14042_((int)i, (int)noisesettings.m_189212_());
        int cellCountY = Mth.m_14042_((int)(j - i), (int)noisesettings.m_189212_());
        return new TBNoiseChunk(16 / noisesettings.m_189213_(), cellCountY, cellNoiseMinY, sampler, chunkpos.m_45604_(), chunkpos.m_45605_(), noiseFiller.get(), noiseGenSettings, p_188778_, blender);
    }

    public static TBNoiseChunk forColumn(int x, int z, int cellNoiseMinY, int cellCountY, TBNoiseSampler sampler, NoiseGeneratorSettings noiseGenSettings, Aquifer.FluidPicker fluidPicker) {
        return new TBNoiseChunk(1, cellCountY, cellNoiseMinY, sampler, x, z, (noiseX, noiseY, noiseZ) -> 0.0, noiseGenSettings, fluidPicker, Blender.m_190153_());
    }

    private TBNoiseChunk(int cellCountXZ, int cellCountY, int cellNoiseMinY, TBNoiseSampler sampler, int chunkX, int chunkZ, NoiseChunk.NoiseFiller noiseFiller, NoiseGeneratorSettings noiseGenSettings, Aquifer.FluidPicker fluidPicker, Blender blender) {
        super(cellCountXZ, cellCountY, cellNoiseMinY, (NoiseSampler)sampler, chunkX, chunkZ, noiseFiller, noiseGenSettings, fluidPicker, blender);
        int cellWidth = this.f_188717_.m_189213_();
        int j = QuartPos.m_175400_((int)(cellCountXZ * cellWidth));
        this.tbNoiseData = new TBNoiseSampler.TBFlatNoiseData[j + 1][];
        for (int k = 0; k <= j; ++k) {
            int l = this.f_188723_ + k;
            this.tbNoiseData[k] = new TBNoiseSampler.TBFlatNoiseData[j + 1];
            for (int i1 = 0; i1 <= j; ++i1) {
                int j1 = this.f_188724_ + i1;
                this.tbNoiseData[k][i1] = sampler.noiseDataTB(l, j1, blender);
            }
        }
        this.f_188726_ = null;
    }

    public NoiseSampler.FlatNoiseData m_188751_(int x, int z) {
        throw new RuntimeException("Vanilla noiseData called on TBNoiseChunk!");
    }

    public TBNoiseSampler.TBFlatNoiseData noiseDataTB(int x, int z) {
        return this.tbNoiseData[x - this.f_188723_][z - this.f_188724_];
    }

    public int m_198256_(int x, int z) {
        return this.f_198238_.computeIfAbsent(ChunkPos.m_45589_((int)QuartPos.m_175400_((int)x), (int)QuartPos.m_175400_((int)z)), this::computePreliminarySurfaceLevel);
    }

    private int computePreliminarySurfaceLevel(long chunkPos) {
        int i = ChunkPos.m_45592_((long)chunkPos);
        int j = ChunkPos.m_45602_((long)chunkPos);
        int k = i - this.f_188723_;
        int l = j - this.f_188724_;
        int i1 = this.tbNoiseData.length;
        TerrainInfo terraininfo = k >= 0 && l >= 0 && k < i1 && l < i1 ? this.tbNoiseData[k][l].terrainInfo() : ((TBNoiseSampler)this.f_198237_).noiseDataTB(i, j, this.f_188731_).terrainInfo();
        return this.f_198237_.m_189005_(QuartPos.m_175402_((int)i), QuartPos.m_175402_((int)j), terraininfo);
    }
}

