/*
 * Decompiled with CFR 0.152.
 */
package com.Apothic0n.EcosphericalExpansion.api.biome;

import com.Apothic0n.EcosphericalExpansion.api.biome.features.ECOBiomeFeatureGroups;
import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.data.worldgen.BiomeDefaultFeatures;
import net.minecraft.data.worldgen.placement.AquaticPlacements;
import net.minecraft.sounds.Music;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.biome.AmbientMoodSettings;
import net.minecraft.world.level.biome.AmbientParticleSettings;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeGenerationSettings;
import net.minecraft.world.level.biome.BiomeSpecialEffects;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.levelgen.GenerationStep;

public class ECOBiomes {
    @Nullable
    private static final Music NORMAL_MUSIC = null;

    protected static int calculateSkyColor(float color) {
        float $$1 = color / 3.0f;
        $$1 = Mth.m_14036_((float)$$1, (float)-1.0f, (float)1.0f);
        return Mth.m_14169_((float)(0.62222224f - $$1 * 0.05f), (float)(0.5f + $$1 * 0.1f), (float)1.0f);
    }

    private static Biome biome(Biome.Precipitation precipitation, Biome.BiomeCategory category, float temperature, float downfall, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music, BiomeSpecialEffects specialEffects) {
        return ECOBiomes.biome2(precipitation, category, temperature, downfall, 4159204, 329011, spawnBuilder, biomeBuilder, music, specialEffects);
    }

    private static Biome biome2(Biome.Precipitation precipitation, Biome.BiomeCategory category, float temperature, float downfall, int waterColor, int waterFogColor, MobSpawnSettings.Builder spawnBuilder, BiomeGenerationSettings.Builder biomeBuilder, @Nullable Music music, BiomeSpecialEffects specialEffects) {
        return new Biome.BiomeBuilder().m_47597_(precipitation).m_47595_(category).m_47609_(temperature).m_47611_(downfall).m_47603_(new BiomeSpecialEffects.Builder().m_48034_(waterColor).m_48037_(waterFogColor).m_48019_(12638463).m_48040_(ECOBiomes.calculateSkyColor(temperature)).m_48027_(AmbientMoodSettings.f_47387_).m_48021_(music).m_48018_()).m_47605_(spawnBuilder.m_48381_()).m_47601_(biomeBuilder.m_47831_()).m_47603_(specialEffects).m_47592_();
    }

    private static void globalOverworldGeneration(BiomeGenerationSettings.Builder builder) {
        BiomeDefaultFeatures.m_194720_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_176857_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126806_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126810_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126765_((BiomeGenerationSettings.Builder)builder);
        BiomeDefaultFeatures.m_126771_((BiomeGenerationSettings.Builder)builder);
    }

    public static Biome lushOak() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126792_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)2, (int)3);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126828_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addLushOakTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126844_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126728_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_194735_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addRootedCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addLushOceanVegetationFeatures(biomeBuilder);
        biomeBuilder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.01f)).m_48019_(12638463).m_48037_(329011).m_48034_(4159204).m_48040_(ECOBiomes.calculateSkyColor(0.7f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.FOREST, 0.6f, 0.8f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome lushJungle() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)6, (int)3);
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addLushJungleTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addAzaleaTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126696_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_176863_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addTuffCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addLushOceanVegetationFeatures(biomeBuilder);
        biomeBuilder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123783_, 0.02f)).m_48019_(12638463).m_48037_(329011).m_48034_(2218432).m_48040_(ECOBiomes.calculateSkyColor(0.7f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.JUNGLE, 0.8f, 0.9f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome enrichedRoofedForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)2, (int)3);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addBigDarkOakTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addNormalDarkOakTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addSmallDarkOakTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addRootedCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addNormalOceanVegetationFeatures(biomeBuilder);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48031_(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).m_48019_(12638463).m_48037_(329011).m_48034_(4159204).m_48040_(ECOBiomes.calculateSkyColor(0.7f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.FOREST, 0.3f, 0.8f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome frozenRoofedForest() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126740_((MobSpawnSettings.Builder)spawnBuilder, (int)1, (int)5, (int)4);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addBigDarkOakTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addNormalDarkOakTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addSmallDarkOakTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addGrassyIceCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addColdOceanVegetationFeatures(biomeBuilder);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48031_(BiomeSpecialEffects.GrassColorModifier.DARK_FOREST).m_48019_(12638463).m_48037_(329011).m_48034_(4159204).m_48040_(ECOBiomes.calculateSkyColor(0.1f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.SNOW, Biome.BiomeCategory.ICY, -0.2f, 0.8f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome glacialPlains() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126796_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126740_((MobSpawnSettings.Builder)spawnBuilder, (int)1, (int)5, (int)4);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addColdOceanVegetationFeatures(biomeBuilder);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48037_(329011).m_48034_(4159204).m_48040_(ECOBiomes.calculateSkyColor(0.1f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.SNOW, Biome.BiomeCategory.ICY, -0.8f, 0.3f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome lushBirch() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)1, (int)3);
        BiomeDefaultFeatures.m_126796_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126834_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addVeryTallBirchTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addAzaleaTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126708_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126745_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addCalciteCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addLushOceanVegetationFeatures(biomeBuilder);
        biomeBuilder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195219_);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48029_(new AmbientParticleSettings((ParticleOptions)ParticleTypes.f_123790_, 0.01f)).m_48019_(12638463).m_48037_(329011).m_48034_(8028646).m_48040_(ECOBiomes.calculateSkyColor(0.7f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.MOUNTAIN, 0.6f, 0.8f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome megaSavanna() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)6, (int)3);
        BiomeDefaultFeatures.m_126808_((MobSpawnSettings.Builder)spawnBuilder);
        spawnBuilder.m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20457_, 2, 2, 3)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20560_, 1, 1, 1)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20466_, 8, 4, 5)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_20452_, 5, 1, 4)).m_48376_(MobCategory.CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147035_, 4, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126822_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addMegaSavannaTrees(biomeBuilder);
        BiomeDefaultFeatures.m_126698_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126702_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126720_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addGrassyTerracottaCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addLushOceanVegetationFeatures(biomeBuilder);
        biomeBuilder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195218_);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48019_(12638463).m_48037_(329011).m_48034_(2218432).m_48040_(ECOBiomes.calculateSkyColor(0.1f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.SAVANNA, 2.0f, 0.0f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }

    public static Biome megaSwamp() {
        MobSpawnSettings.Builder spawnBuilder = new MobSpawnSettings.Builder();
        BiomeDefaultFeatures.m_126788_((MobSpawnSettings.Builder)spawnBuilder);
        BiomeDefaultFeatures.m_126736_((MobSpawnSettings.Builder)spawnBuilder, (int)6, (int)3);
        spawnBuilder.m_48376_(MobCategory.WATER_CREATURE, new MobSpawnSettings.SpawnerData(EntityType.f_147039_, 2, 2, 3)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20526_, 1, 1, 1)).m_48376_(MobCategory.MONSTER, new MobSpawnSettings.SpawnerData(EntityType.f_20495_, 3, 1, 3));
        BiomeGenerationSettings.Builder biomeBuilder = new BiomeGenerationSettings.Builder();
        ECOBiomes.globalOverworldGeneration(biomeBuilder);
        BiomeDefaultFeatures.m_126814_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126824_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addMegaSwampTrees(biomeBuilder);
        ECOBiomeFeatureGroups.addTreelessSwampVegetation(biomeBuilder);
        BiomeDefaultFeatures.m_126730_((BiomeGenerationSettings.Builder)biomeBuilder);
        BiomeDefaultFeatures.m_126753_((BiomeGenerationSettings.Builder)biomeBuilder);
        ECOBiomeFeatureGroups.addDeadTuffCavesVegetationFeatures(biomeBuilder);
        ECOBiomeFeatureGroups.addLushOceanVegetationFeatures(biomeBuilder);
        biomeBuilder.m_186664_(GenerationStep.Decoration.VEGETAL_DECORATION, AquaticPlacements.f_195222_);
        BiomeSpecialEffects specialEffects = new BiomeSpecialEffects.Builder().m_48031_(BiomeSpecialEffects.GrassColorModifier.SWAMP).m_48043_(6975545).m_48019_(12638463).m_48037_(2302743).m_48034_(6388580).m_48040_(ECOBiomes.calculateSkyColor(0.8f)).m_48018_();
        return ECOBiomes.biome(Biome.Precipitation.RAIN, Biome.BiomeCategory.SWAMP, 0.8f, 0.9f, spawnBuilder, biomeBuilder, NORMAL_MUSIC, specialEffects);
    }
}

