/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions.entity;

import com.github.justinwon777.humancompanions.core.EntityInit;
import com.github.justinwon777.humancompanions.entity.AvoidCreeperGoal;
import com.github.justinwon777.humancompanions.entity.CompanionData;
import com.github.justinwon777.humancompanions.entity.CustomOwnerHurtByTargetGoal;
import com.github.justinwon777.humancompanions.entity.CustomOwnerHurtTargetGoal;
import com.github.justinwon777.humancompanions.entity.LowHealthGoal;
import javax.annotation.Nullable;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.OpenDoorGoal;
import net.minecraft.entity.ai.goal.SitGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.passive.TameableEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.ChestContainer;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.inventory.container.SimpleNamedContainerProvider;
import net.minecraft.item.ArmorItem;
import net.minecraft.item.ArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.pathfinding.GroundPathNavigator;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class AbstractHumanCompanionEntity
extends TameableEntity {
    private static final DataParameter<Integer> DATA_TYPE_ID = EntityDataManager.func_187226_a(CatEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    public Inventory inventory = new Inventory(27);
    public EquipmentSlotType[] armorTypes = new EquipmentSlotType[]{EquipmentSlotType.FEET, EquipmentSlotType.LEGS, EquipmentSlotType.CHEST, EquipmentSlotType.HEAD};

    public AbstractHumanCompanionEntity(EntityType<? extends TameableEntity> entityType, World level) {
        super(entityType, level);
        this.func_70903_f(false);
        ((GroundPathNavigator)this.func_70661_as()).func_179688_b(true);
        this.func_70661_as().func_212239_d(true);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new SitGoal((TameableEntity)this));
        this.field_70714_bg.func_75776_a(2, new AvoidCreeperGoal<CreeperEntity>(this, CreeperEntity.class, 10.0f, 1.5, 1.5));
        this.field_70714_bg.func_75776_a(3, (Goal)new FollowOwnerGoal((TameableEntity)this, 1.3, 8.0f, 2.0f, false));
        this.field_70714_bg.func_75776_a(4, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(7, (Goal)new OpenDoorGoal((MobEntity)this, true));
        this.field_70714_bg.func_75776_a(9, (Goal)new LowHealthGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new CustomOwnerHurtByTargetGoal(this));
        this.field_70715_bh.func_75776_a(2, (Goal)new CustomOwnerHurtTargetGoal(this));
        this.field_70715_bh.func_75776_a(3, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]).func_220794_a(new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 20.0).func_233815_a_(Attributes.field_233823_f_, 1.0).func_233815_a_(Attributes.field_233821_d_, 0.32);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setCompanionSkin(this.field_70146_Z.nextInt(CompanionData.maleSkins.length));
        this.func_200203_b((ITextComponent)new StringTextComponent(CompanionData.getRandomName()));
        for (int i = 0; i < 4; ++i) {
            EquipmentSlotType armorType = this.armorTypes[i];
            ItemStack itemstack = this.getSpawnArmor(armorType);
            if (itemstack.func_190926_b()) continue;
            this.inventory.func_70299_a(i, itemstack);
            this.checkArmor();
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(DATA_TYPE_ID, (Object)1);
    }

    public ResourceLocation getResourceLocation() {
        return CompanionData.maleSkins[this.getCompanionSkin()];
    }

    public int getCompanionSkin() {
        return (Integer)this.field_70180_af.func_187225_a(DATA_TYPE_ID);
    }

    public void setCompanionSkin(int skinIndex) {
        this.field_70180_af.func_187227_b(DATA_TYPE_ID, (Object)skinIndex);
    }

    public AgeableEntity func_241840_a(ServerWorld level, AgeableEntity parent) {
        return (AgeableEntity)((EntityType)EntityInit.KnightEntity.get()).func_200721_a((World)level);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        Item item = itemstack.func_77973_b();
        if (!this.field_70170_p.field_72995_K && hand == Hand.MAIN_HAND) {
            if (!this.func_70909_n()) {
                if (itemstack.func_222117_E()) {
                    itemstack.func_190918_g(1);
                    if (this.field_70146_Z.nextInt(4) == 0) {
                        this.func_193101_c(player);
                        player.func_145747_a((ITextComponent)new StringTextComponent("Companion added"), this.func_110124_au());
                    } else {
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.type.text", new Object[]{this.func_145748_c_(), CompanionData.tameFail[this.field_70146_Z.nextInt(CompanionData.tameFail.length)]}), this.func_110124_au());
                    }
                } else {
                    player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.type.text", new Object[]{this.func_145748_c_(), CompanionData.notTamed[this.field_70146_Z.nextInt(CompanionData.notTamed.length)]}), this.func_110124_au());
                }
            } else {
                if (player.func_225608_bj_()) {
                    if (!this.func_233685_eM_()) {
                        this.func_233687_w_(true);
                        StringTextComponent text = new StringTextComponent("I'll stay here.");
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.type.text", new Object[]{this.func_145748_c_(), text}), this.func_110124_au());
                    } else {
                        this.func_233687_w_(false);
                        StringTextComponent text = new StringTextComponent("I'll follow you.");
                        player.func_145747_a((ITextComponent)new TranslationTextComponent("chat.type.text", new Object[]{this.func_145748_c_(), text}), this.func_110124_au());
                    }
                } else if (itemstack.func_222117_E()) {
                    if (this.func_110143_aJ() < this.func_110138_aP()) {
                        if (!player.field_71075_bZ.field_75098_d) {
                            itemstack.func_190918_g(1);
                        }
                        this.func_70691_i(item.func_219967_s().func_221466_a());
                        StringTextComponent text = new StringTextComponent(this.func_200200_C_().getString() + "'s health: " + this.func_110143_aJ() + "/" + this.func_110138_aP());
                        player.func_145747_a((ITextComponent)text, this.func_110124_au());
                        return ActionResultType.SUCCESS;
                    }
                } else {
                    this.openGui((ServerPlayerEntity)player);
                }
                return ActionResultType.SUCCESS;
            }
            return ActionResultType.SUCCESS;
        }
        return super.func_230254_b_(player, hand);
    }

    public void openGui(ServerPlayerEntity player) {
        player.func_213829_a((INamedContainerProvider)new SimpleNamedContainerProvider((p_53124_, p_53125_, p_53126_) -> ChestContainer.func_216992_a((int)p_53124_, (PlayerInventory)p_53125_, (IInventory)this.inventory), this.func_145748_c_()));
    }

    public void checkArmor() {
        ItemStack head = this.func_184582_a(EquipmentSlotType.HEAD);
        ItemStack chest = this.func_184582_a(EquipmentSlotType.CHEST);
        ItemStack legs = this.func_184582_a(EquipmentSlotType.LEGS);
        ItemStack feet = this.func_184582_a(EquipmentSlotType.FEET);
        block6: for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (!(itemstack.func_77973_b() instanceof ArmorItem)) continue;
            switch (((ArmorItem)itemstack.func_77973_b()).func_185083_B_()) {
                case HEAD: {
                    if (head.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200881_e() > ((ArmorItem)head.func_77973_b()).func_200881_e()) {
                        this.func_184201_a(EquipmentSlotType.HEAD, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200880_d() != ArmorMaterial.NETHERITE || ((ArmorItem)head.func_77973_b()).func_200880_d() == ArmorMaterial.NETHERITE) continue block6;
                    this.func_184201_a(EquipmentSlotType.HEAD, itemstack);
                    continue block6;
                }
                case CHEST: {
                    if (chest.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200881_e() > ((ArmorItem)chest.func_77973_b()).func_200881_e()) {
                        this.func_184201_a(EquipmentSlotType.CHEST, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200880_d() != ArmorMaterial.NETHERITE || ((ArmorItem)chest.func_77973_b()).func_200880_d() == ArmorMaterial.NETHERITE) continue block6;
                    this.func_184201_a(EquipmentSlotType.CHEST, itemstack);
                    continue block6;
                }
                case LEGS: {
                    if (legs.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200881_e() > ((ArmorItem)legs.func_77973_b()).func_200881_e()) {
                        this.func_184201_a(EquipmentSlotType.LEGS, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200880_d() != ArmorMaterial.NETHERITE || ((ArmorItem)legs.func_77973_b()).func_200880_d() == ArmorMaterial.NETHERITE) continue block6;
                    this.func_184201_a(EquipmentSlotType.LEGS, itemstack);
                    continue block6;
                }
                case FEET: {
                    if (feet.func_190926_b()) {
                        this.func_184201_a(EquipmentSlotType.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200881_e() > ((ArmorItem)feet.func_77973_b()).func_200881_e()) {
                        this.func_184201_a(EquipmentSlotType.FEET, itemstack);
                        continue block6;
                    }
                    if (((ArmorItem)itemstack.func_77973_b()).func_200880_d() != ArmorMaterial.NETHERITE || ((ArmorItem)feet.func_77973_b()).func_200880_d() == ArmorMaterial.NETHERITE) continue block6;
                    this.func_184201_a(EquipmentSlotType.FEET, itemstack);
                }
            }
        }
    }

    public void func_213281_b(CompoundNBT tag) {
        super.func_213281_b(tag);
        tag.func_218657_a("inventory", (INBT)this.inventory.func_70487_g());
        tag.func_74768_a("skin", this.getCompanionSkin());
    }

    public void func_70037_a(CompoundNBT tag) {
        super.func_70037_a(tag);
        this.setCompanionSkin(tag.func_74762_e("skin"));
        if (tag.func_150297_b("inventory", 9)) {
            this.inventory.func_70486_a(tag.func_150295_c("inventory", 10));
        }
        this.func_184201_a(EquipmentSlotType.FEET, ItemStack.field_190927_a);
        this.func_184201_a(EquipmentSlotType.LEGS, ItemStack.field_190927_a);
        this.func_184201_a(EquipmentSlotType.CHEST, ItemStack.field_190927_a);
        this.func_184201_a(EquipmentSlotType.HEAD, ItemStack.field_190927_a);
        this.checkArmor();
    }

    public boolean func_70097_a(DamageSource p_34288_, float p_34289_) {
        if (p_34288_.func_76346_g() instanceof TameableEntity && this.func_70909_n() && ((TameableEntity)p_34288_.func_76346_g()).func_70909_n() && this.func_70902_q().func_70028_i((Entity)((TameableEntity)p_34288_.func_76346_g()).func_70902_q())) {
            return false;
        }
        this.func_230294_b_(p_34288_, p_34289_);
        return super.func_70097_a(p_34288_, p_34289_);
    }

    public void func_230294_b_(DamageSource p_150073_, float p_150074_) {
        if (!(p_150074_ <= 0.0f)) {
            if ((p_150074_ /= 4.0f) < 1.0f) {
                p_150074_ = 1.0f;
            }
            for (ItemStack itemstack : this.func_184193_aE()) {
                if (p_150073_.func_76347_k() && itemstack.func_77973_b().func_234687_u_() || !(itemstack.func_77973_b() instanceof ArmorItem)) continue;
                itemstack.func_222118_a((int)p_150074_, (LivingEntity)this, p_35997_ -> p_35997_.func_213361_c(((ArmorItem)itemstack.func_77973_b()).func_185083_B_()));
            }
        }
    }

    public void func_70645_a(DamageSource source) {
        super.func_70645_a(source);
    }

    protected void func_213337_cE() {
        for (int i = 0; i < this.inventory.func_70302_i_(); ++i) {
            ItemStack itemstack = this.inventory.func_70301_a(i);
            if (itemstack.func_190926_b() || EnchantmentHelper.func_190939_c((ItemStack)itemstack)) continue;
            this.func_199701_a_(itemstack);
        }
    }

    public boolean func_70652_k(Entity entity) {
        ItemStack itemstack = this.func_184614_ca();
        System.out.println(itemstack);
        if (!this.field_70170_p.field_72995_K && !itemstack.func_190926_b() && entity instanceof LivingEntity) {
            itemstack.func_222118_a(1, (LivingEntity)this, p_43296_ -> p_43296_.func_213361_c(EquipmentSlotType.MAINHAND));
            if (this.func_184614_ca().func_190926_b()) {
                StringTextComponent broken = new StringTextComponent("My sword broke!");
                if (this.func_70909_n()) {
                    this.func_70902_q().func_145747_a((ITextComponent)new TranslationTextComponent("chat.type.text", new Object[]{this.func_145748_c_(), broken}), this.func_110124_au());
                }
            }
        }
        return super.func_70652_k(entity);
    }

    public ItemStack getSpawnArmor(EquipmentSlotType armorType) {
        float materialFloat = this.field_70146_Z.nextFloat();
        if (materialFloat <= 0.4f) {
            return ItemStack.field_190927_a;
        }
        if (materialFloat < 0.7f) {
            switch (armorType) {
                case HEAD: {
                    return Items.field_151024_Q.func_190903_i();
                }
                case CHEST: {
                    return Items.field_151027_R.func_190903_i();
                }
                case LEGS: {
                    return Items.field_151026_S.func_190903_i();
                }
                case FEET: {
                    return Items.field_151021_T.func_190903_i();
                }
            }
        } else if (materialFloat < 0.9f) {
            switch (armorType) {
                case HEAD: {
                    return Items.field_151020_U.func_190903_i();
                }
                case CHEST: {
                    return Items.field_151023_V.func_190903_i();
                }
                case LEGS: {
                    return Items.field_151022_W.func_190903_i();
                }
                case FEET: {
                    return Items.field_151029_X.func_190903_i();
                }
            }
        } else {
            switch (armorType) {
                case HEAD: {
                    return Items.field_151028_Y.func_190903_i();
                }
                case CHEST: {
                    return Items.field_151030_Z.func_190903_i();
                }
                case LEGS: {
                    return Items.field_151165_aa.func_190903_i();
                }
                case FEET: {
                    return Items.field_151167_ab.func_190903_i();
                }
            }
        }
        return ItemStack.field_190927_a;
    }
}

