/*
 * Decompiled with CFR 0.152.
 */
package com.github.justinwon777.humancompanions.world;

import com.mojang.serialization.Codec;
import java.util.List;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.util.SharedSeedRandom;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.DynamicRegistries;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.provider.BiomeProvider;
import net.minecraft.world.gen.ChunkGenerator;
import net.minecraft.world.gen.GenerationStage;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.gen.feature.jigsaw.JigsawManager;
import net.minecraft.world.gen.feature.structure.AbstractVillagePiece;
import net.minecraft.world.gen.feature.structure.Structure;
import net.minecraft.world.gen.feature.structure.StructurePiece;
import net.minecraft.world.gen.feature.structure.StructureStart;
import net.minecraft.world.gen.feature.structure.VillageConfig;
import net.minecraft.world.gen.feature.template.TemplateManager;

public class CompanionHouseStructure
extends Structure<VillageConfig> {
    public CompanionHouseStructure(Codec<VillageConfig> codec) {
        super(codec);
    }

    public Structure.IStartFactory<VillageConfig> func_214557_a() {
        return Start::new;
    }

    public GenerationStage.Decoration func_236396_f_() {
        return GenerationStage.Decoration.SURFACE_STRUCTURES;
    }

    protected boolean isFeatureChunk(ChunkGenerator chunkGenerator, BiomeProvider biomeSource, long seed, SharedSeedRandom chunkRandom, int chunkX, int chunkZ, Biome biome, ChunkPos chunkPos, VillageConfig featureConfig) {
        BlockPos centerOfChunk = new BlockPos(chunkX * 16, 0, chunkZ * 16);
        int landHeight = chunkGenerator.func_222531_c(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p(), Heightmap.Type.WORLD_SURFACE_WG);
        IBlockReader columnOfBlocks = chunkGenerator.func_230348_a_(centerOfChunk.func_177958_n(), centerOfChunk.func_177952_p());
        BlockState topBlock = columnOfBlocks.func_180495_p(centerOfChunk.func_177981_b(landHeight));
        return topBlock.func_204520_s().func_206888_e();
    }

    public static class Start
    extends StructureStart<VillageConfig> {
        public Start(Structure<VillageConfig> structureIn, int chunkX, int chunkZ, MutableBoundingBox mutableBoundingBox, int referenceIn, long seedIn) {
            super(structureIn, chunkX, chunkZ, mutableBoundingBox, referenceIn, seedIn);
        }

        public void generatePieces(DynamicRegistries dynamicRegistryManager, ChunkGenerator chunkGenerator, TemplateManager templateManagerIn, int chunkX, int chunkZ, Biome biomeIn, VillageConfig config) {
            int x = chunkX * 16;
            int z = chunkZ * 16;
            BlockPos centerPos = new BlockPos(x, 0, z);
            JigsawManager.func_242837_a((DynamicRegistries)dynamicRegistryManager, (VillageConfig)config, AbstractVillagePiece::new, (ChunkGenerator)chunkGenerator, (TemplateManager)templateManagerIn, (BlockPos)centerPos, (List)this.field_75075_a, (Random)this.field_214631_d, (boolean)false, (boolean)true);
            Vector3i structureCenter = ((StructurePiece)this.field_75075_a.get(0)).func_74874_b().func_215126_f();
            int xOffset = centerPos.func_177958_n() - structureCenter.func_177958_n();
            int zOffset = centerPos.func_177952_p() - structureCenter.func_177952_p();
            for (StructurePiece structurePiece : this.field_75075_a) {
                structurePiece.func_181138_a(xOffset, 0, zOffset);
            }
            this.func_202500_a();
        }
    }
}

