/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.Events;

import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedDiverEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedIGEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedPlayerEntity;
import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionDamage;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionHandler;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManagerCapability;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import java.util.ArrayList;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.GoalSelector;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.ai.goal.PrioritizedGoal;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.PillagerEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.passive.GolemEntity;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="immortuoscalyx", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityInfectionEventManager {
    @SubscribeEvent
    public static void InfectionTicker(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof PlayerEntity)) {
            entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= 1) {
                    h.addInfectionTimer(1);
                    int timer = -1;
                    timer = entity instanceof VillagerEntity ? ImmortuosCalyx.config.VILLAGERINFECTIONTIMER.get() : (entity instanceof IronGolemEntity ? ImmortuosCalyx.config.IRONGOLEMTIMER.get().intValue() : ImmortuosCalyx.config.INFECTIONTIMER.get().intValue());
                    if (h.getInfectionTimer() >= timer) {
                        h.addInfectionProgress(1);
                        h.addInfectionTimer(-timer);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void InfectionLogic(LivingEvent.LivingUpdateEvent event) {
        AtomicInteger infectionlevel = new AtomicInteger(0);
        LivingEntity entity = event.getEntityLiving();
        entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> infectionlevel.getAndSet(h.getInfectionProgress()));
        int level = infectionlevel.get();
        if (level > 0) {
            if (entity instanceof VillagerEntity) {
                EntityInfectionEventManager.VillagerLogic((VillagerEntity)entity, level);
            }
            if (entity instanceof IronGolemEntity && !(entity instanceof InfectedIGEntity)) {
                EntityInfectionEventManager.IGLogic((IronGolemEntity)entity, level);
            }
        }
    }

    public static void VillagerLogic(VillagerEntity entity, int level) {
        Random rand;
        int random;
        if (level >= ImmortuosCalyx.config.VILLAGERSLOWTWO.get()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 2, false, false));
        } else if (level >= ImmortuosCalyx.config.VILLAGERSLOWONE.get()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        }
        if (level >= ImmortuosCalyx.config.VILLAGERLETHAL.get() && (random = (rand = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
            entity.func_70097_a(InfectionDamage.causeInfectionDamage((Entity)entity), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
        }
    }

    public static void IGLogic(IronGolemEntity entity, int level) {
        Random rand;
        int random;
        if (level >= ImmortuosCalyx.config.IRONGOLEMSLOW.get()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76421_d, 5, 1, false, false));
        }
        if (level >= ImmortuosCalyx.config.IRONGOLEMWEAK.get()) {
            entity.func_195064_c(new EffectInstance(Effects.field_76437_t, 5, 1, false, false));
        }
        if (level >= ImmortuosCalyx.config.IRONGOLEMLETHAL.get() && (random = (rand = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
            entity.func_70097_a(InfectionDamage.causeInfectionDamage((Entity)entity), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
        }
    }

    @SubscribeEvent
    public static void antiTrade(PlayerInteractEvent.EntityInteract event) {
        if (!event.getTarget().func_130014_f_().func_201670_d() && event.getHand() == Hand.MAIN_HAND && event.getTarget() instanceof VillagerEntity) {
            VillagerEntity villager = (VillagerEntity)event.getTarget();
            villager.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.VILLAGERNOTRADE.get()) {
                    event.setCanceled(true);
                    villager.func_213720_r(40);
                    villager.func_130014_f_().func_184148_a(null, villager.func_226277_ct_(), villager.func_226278_cu_(), villager.func_226281_cx_(), (SoundEvent)Register.VILIDLE.get(), SoundCategory.NEUTRAL, 1.0f, 1.0f);
                }
            });
        }
    }

    @SubscribeEvent
    public static void deathEntityReplacement(LivingDeathEvent event) {
        World world;
        LivingEntity entity = event.getEntityLiving();
        if (event.getSource().field_76373_n.equals("infection") && !(world = event.getEntityLiving().func_130014_f_()).func_201670_d()) {
            ServerWorld serverWorld = (ServerWorld)world;
            if (entity instanceof PlayerEntity) {
                InfectedPlayerEntity infectedPlayerEntity = new InfectedPlayerEntity((EntityType<InfectedPlayerEntity>)((EntityType)Register.INFECTEDPLAYER.get()), world);
                infectedPlayerEntity.func_200203_b(entity.func_200200_C_());
                infectedPlayerEntity.setPUUID(entity.func_110124_au());
                infectedPlayerEntity.func_70107_b(entity.func_226277_ct_(), entity.func_226278_cu_() + 0.1, entity.func_226281_cx_());
                world.func_217376_c((Entity)infectedPlayerEntity);
            } else if (entity instanceof AbstractVillagerEntity) {
                ((EntityType)Register.INFECTEDVILLAGER.get()).func_220331_a(serverWorld, new ItemStack((IItemProvider)Items.field_190931_a), null, entity.func_233580_cy_(), SpawnReason.TRIGGERED, true, false);
            } else if (entity instanceof IronGolemEntity) {
                ((EntityType)Register.INFECTEDIG.get()).func_220331_a(serverWorld, new ItemStack((IItemProvider)Items.field_190931_a), null, entity.func_233580_cy_(), SpawnReason.TRIGGERED, true, false);
            }
        }
    }

    @SubscribeEvent
    public static void AerosolInfection(LivingEvent.LivingUpdateEvent event) {
        block12: {
            LivingEntity sourceEntity = event.getEntityLiving();
            Random rand = new Random();
            if (ImmortuosCalyx.DimensionExclusion.contains(sourceEntity.field_70170_p.func_234923_W_().func_240901_a_()) && ImmortuosCalyx.commonConfig.HOSTILEAEROSOLINFECTIONINCLEANSE.get().booleanValue() || sourceEntity.field_70170_p.func_201670_d()) break block12;
            int AerosolRate = Integer.MAX_VALUE;
            boolean common = false;
            if (sourceEntity instanceof InfectedEntity) {
                AerosolRate = ImmortuosCalyx.config.INFECTEDAERIALRATE.get();
            } else if (sourceEntity instanceof ZombieEntity) {
                AerosolRate = ImmortuosCalyx.config.ZOMBIEAERIALRATE.get();
            } else if (sourceEntity instanceof VillagerEntity) {
                AerosolRate = ImmortuosCalyx.config.FOLLOWERAERIALRATE.get();
            } else {
                common = true;
                AerosolRate = ImmortuosCalyx.config.COMMONAERIALRATE.get();
            }
            if (AerosolRate != Integer.MAX_VALUE && rand.nextInt(AerosolRate) == 2) {
                ArrayList entities = (ArrayList)sourceEntity.field_70170_p.func_175674_a((Entity)sourceEntity, sourceEntity.func_174813_aQ().func_186662_g(2.0), null);
                ArrayList<LivingEntity> livingEntityList = new ArrayList<LivingEntity>();
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    livingEntityList.add((LivingEntity)entity);
                }
                if (!common) {
                    for (LivingEntity victim : livingEntityList) {
                        InfectionHandler.bioInfect(victim, AerosolRate, 1);
                    }
                } else {
                    for (LivingEntity victim : livingEntityList) {
                        InfectionHandler.commonAerosol(victim, sourceEntity, 1);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void InfectedIGSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof InfectedIGEntity && !sEntity.field_70170_p.func_201670_d()) {
            InfectedIGEntity entity = (InfectedIGEntity)sEntity;
            Set prioritizedGoals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)entity.field_70715_bh, (String)"availableGoals");
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            if (prioritizedGoals != null) {
                for (PrioritizedGoal prioritizedGoal : prioritizedGoals) {
                    toRemove.add(prioritizedGoal.func_220772_j());
                }
            }
            for (Goal goal : toRemove) {
                entity.field_70715_bh.func_85156_a(goal);
            }
            entity.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PillagerEntity.class, 16, true, false, entity::shouldAttack));
            entity.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, MonsterEntity.class, 16, true, false, entity::shouldAttackMonster));
            entity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, AbstractVillagerEntity.class, 16, true, false, entity::shouldAttack));
            entity.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 16, true, false, entity::shouldAttack));
            entity.field_70715_bh.func_75776_a(5, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, GolemEntity.class, 16, true, false, entity::shouldAttackMonster));
        }
    }

    @SubscribeEvent
    public static void GolemSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof GolemEntity && !sEntity.field_70170_p.func_201670_d() && !(sEntity instanceof InfectedEntity)) {
            GolemEntity golemEntity = (GolemEntity)sEntity;
            golemEntity.field_70715_bh.func_75776_a(4, (Goal)new NearestAttackableTargetGoal((MobEntity)golemEntity, InfectedIGEntity.class, true, false));
        }
    }

    @SubscribeEvent
    public static void DiverSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof InfectedDiverEntity && !sEntity.field_70170_p.func_201670_d()) {
            InfectedDiverEntity entity = (InfectedDiverEntity)sEntity;
            Set prioritizedGoals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)entity.field_70715_bh, (String)"availableGoals");
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            if (prioritizedGoals != null) {
                for (PrioritizedGoal prioritizedGoal : prioritizedGoals) {
                    toRemove.add(prioritizedGoal.func_220772_j());
                }
            }
            for (Goal goal : toRemove) {
                entity.field_70715_bh.func_85156_a(goal);
            }
            entity.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, PlayerEntity.class, 10, true, false, entity::func_204714_e));
            entity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, AbstractVillagerEntity.class, 10, true, false, entity::func_204714_e));
            entity.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)entity, GolemEntity.class, 10, true, false, entity::shouldAttackMonster));
        }
    }

    @SubscribeEvent
    public static void VillagerSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof VillagerEntity && !((VillagerEntity)sEntity).func_70631_g_() && !event.getWorld().field_72995_K) {
            sEntity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (event.getWorld().func_201674_k().nextInt(ImmortuosCalyx.config.VILLAGERFOLLOWERCHANCE.get()) < 2) {
                    h.setInfectionProgressIfLower(1);
                    h.setFollower(true);
                }
            });
        }
    }
}

