/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.Events;

import com.cartoonishvillain.ImmortuosCalyx.Configs.CommonConfig;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedDiverEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedHumanEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedIGEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedVillagerEntity;
import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManagerCapability;
import com.cartoonishvillain.ImmortuosCalyx.InternalOrganDamage;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import com.cartoonishvillain.ImmortuosCalyx.commands.SetInfectionRateCommand;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.brigadier.CommandDispatcher;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immortuoscalyx", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NonInfectionEvents {
    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        SetInfectionRateCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            AtomicInteger infectionProgress = new AtomicInteger(Integer.MAX_VALUE);
            AtomicInteger infectionTimer = new AtomicInteger(Integer.MAX_VALUE);
            AtomicDouble resistance = new AtomicDouble(Double.MAX_VALUE);
            PlayerEntity originalPlayer = event.getOriginal();
            PlayerEntity newPlayer = event.getPlayer();
            originalPlayer.revive();
            originalPlayer.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                infectionProgress.set(h.getInfectionProgress());
                infectionTimer.set(h.getInfectionTimer());
                resistance.set(h.getResistance());
            });
            originalPlayer.func_174812_G();
            newPlayer.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                h.setInfectionProgress(infectionProgress.get());
                h.setInfectionTimer(infectionTimer.get());
                h.setResistance(resistance.get());
            });
        }
    }

    @SubscribeEvent
    public static void selfUseCalyxide(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b().equals(Register.CALYXANIDE.get()) && (player = (PlayerEntity)event.getEntity()).func_213453_ef()) {
            NonInfectionEvents.CalyxideCure((Entity)player);
            event.getItemStack().func_190918_g(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void selfUseAntiParasite(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b().equals(Register.GENERALANTIPARASITIC.get()) && (player = (PlayerEntity)event.getEntity()).func_213453_ef()) {
            NonInfectionEvents.AntiParasiticCure((Entity)player);
            event.getItemStack().func_190918_g(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void selfUseCEggs(PlayerInteractEvent.RightClickItem event) {
        PlayerEntity player;
        if (event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b().equals(Register.IMMORTUOSCALYXEGGS.get()) && (player = (PlayerEntity)event.getEntity()).func_213453_ef()) {
            player.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() == 0) {
                    h.addInfectionProgress(ImmortuosCalyx.config.EGGINFECTIONSTART.get());
                }
            });
            event.getItemStack().func_190918_g(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useCalyxide(AttackEntityEvent event) {
        Entity target = event.getTarget();
        PlayerEntity user = (PlayerEntity)event.getEntity();
        if (user.func_184614_ca().func_77973_b().equals(Register.CALYXANIDE.get())) {
            user.func_184614_ca().func_190918_g(1);
            NonInfectionEvents.CalyxideCure(target);
            event.setCanceled(true);
            if (!event.getTarget().field_70170_p.func_201670_d()) {
                target.func_130014_f_().func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useAntiParasite(AttackEntityEvent event) {
        Entity target = event.getTarget();
        PlayerEntity user = (PlayerEntity)event.getEntity();
        if (user.func_184614_ca().func_77973_b().equals(Register.GENERALANTIPARASITIC.get())) {
            user.func_184614_ca().func_190918_g(1);
            NonInfectionEvents.AntiParasiticCure(target);
            event.setCanceled(true);
            if (!event.getTarget().field_70170_p.func_201670_d()) {
                target.func_130014_f_().func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useCEggs(AttackEntityEvent event) {
        Entity target = event.getTarget();
        PlayerEntity user = (PlayerEntity)event.getEntity();
        if (user.func_184614_ca().func_77973_b().equals(Register.IMMORTUOSCALYXEGGS.get())) {
            user.func_184614_ca().func_190918_g(1);
            target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() == 0) {
                    h.addInfectionProgress(ImmortuosCalyx.config.EGGINFECTIONSTART.get());
                }
            });
            event.setCanceled(true);
            if (!event.getTarget().field_70170_p.func_201670_d()) {
                target.func_130014_f_().func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)Register.INJECT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
            }
            if (target instanceof InfectedDiverEntity || target instanceof InfectedHumanEntity || target instanceof InfectedVillagerEntity) {
                ((MonsterEntity)target).func_195064_c(new EffectInstance(Effects.field_76424_c, 600, 2, true, false));
                ((MonsterEntity)target).func_195064_c(new EffectInstance(Effects.field_76420_g, 600, 1, true, false));
            }
        }
    }

    @SubscribeEvent
    public static void playerResistanceDownTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            PlayerEntity playerEntity = event.player;
            playerEntity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                h.addResistance(-0.001);
                if (h.getResistance() < 1.0) {
                    h.setResistance(1.0);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerExtract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == Hand.MAIN_HAND) {
            PlayerEntity player;
            if (event.getTarget() instanceof SlimeEntity && event.getEntity() instanceof PlayerEntity) {
                PlayerEntity player2 = (PlayerEntity)event.getEntity();
                if (player2.func_184614_ca().func_77973_b().equals(((Item)Register.SYRINGE.get()).getItem())) {
                    ItemStack olditemstack = player2.func_184614_ca();
                    olditemstack.func_190918_g(1);
                    ItemStack itemStack = new ItemStack((IItemProvider)Register.GENERALANTIPARASITIC.get());
                    player2.field_71071_by.func_70441_a(itemStack);
                    if (!event.getEntity().field_70170_p.func_201670_d()) {
                        target.func_130014_f_().func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)Register.EXTRACT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                    }
                }
            } else if ((event.getTarget() instanceof InfectedHumanEntity || event.getTarget() instanceof InfectedDiverEntity || event.getTarget() instanceof InfectedVillagerEntity || event.getTarget() instanceof InfectedIGEntity && event.getEntity() instanceof PlayerEntity) && (player = (PlayerEntity)event.getEntity()).func_184614_ca().func_77973_b().equals(((Item)Register.SYRINGE.get()).getItem())) {
                ItemStack olditemstack = player.func_184614_ca();
                olditemstack.func_190918_g(1);
                ItemStack itemStack = new ItemStack((IItemProvider)Register.IMMORTUOSCALYXEGGS.get());
                player.field_71071_by.func_70441_a(itemStack);
                if (!target.func_130014_f_().func_201670_d()) {
                    target.func_130014_f_().func_184148_a(null, target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_(), (SoundEvent)Register.EXTRACT.get(), SoundCategory.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void selfScan(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.SERVER && event.getEntity() instanceof PlayerEntity && event.getItemStack().func_77973_b().equals(Register.SCANNER.get()) && event.getEntity().func_213453_ef()) {
            PlayerEntity p = (PlayerEntity)event.getEntity();
            event.getEntity().getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                p.func_145747_a((ITextComponent)new StringTextComponent("===(" + p.func_195047_I_() + "'s stats)==="), p.func_110124_au());
                p.func_145747_a((ITextComponent)new StringTextComponent("Saturation level: " + p.func_71024_bL().func_75115_e()), p.func_110124_au());
                p.func_145747_a((ITextComponent)new StringTextComponent("Infection Level: " + h.getInfectionProgress() + "%"), p.func_110124_au());
                p.func_145747_a((ITextComponent)new StringTextComponent("Resistance Multiplier: " + h.getResistance()), p.func_110124_au());
            });
        }
    }

    @SubscribeEvent
    public static void Scan(AttackEntityEvent event) {
        if (!event.getEntity().func_130014_f_().func_201670_d() && event.getEntity() instanceof PlayerEntity && ((PlayerEntity)event.getEntity()).func_184614_ca().func_77973_b().equals(Register.SCANNER.get())) {
            event.setCanceled(true);
            if (event.getTarget() instanceof PlayerEntity) {
                PlayerEntity t = (PlayerEntity)event.getTarget();
                PlayerEntity a = (PlayerEntity)event.getEntity();
                t.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                    a.func_145747_a((ITextComponent)new StringTextComponent("===(" + t.func_195047_I_() + "'s stats)==="), a.func_110124_au());
                    a.func_145747_a((ITextComponent)new StringTextComponent("Health: " + t.func_110143_aJ()), a.func_110124_au());
                    a.func_145747_a((ITextComponent)new StringTextComponent("Food: " + t.func_71024_bL().func_75116_a()), a.func_110124_au());
                    a.func_145747_a((ITextComponent)new StringTextComponent("Infection Level: " + h.getInfectionProgress() + "%"), a.func_110124_au());
                    a.func_145747_a((ITextComponent)new StringTextComponent("Resistance Multiplier: " + h.getResistance()), a.func_110124_au());
                });
            } else if (event.getTarget() instanceof InfectedHumanEntity || event.getTarget() instanceof InfectedDiverEntity || event.getTarget() instanceof InfectedIGEntity || event.getTarget() instanceof InfectedVillagerEntity) {
                event.getEntity().func_145747_a((ITextComponent)new StringTextComponent("===(Target completely infected)==="), event.getEntity().func_110124_au());
            } else if (event.getTarget() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)event.getTarget();
                PlayerEntity player = (PlayerEntity)event.getEntity();
                entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                    player.func_145747_a((ITextComponent)new StringTextComponent("===(" + entity.func_200200_C_().getString() + "'s stats)==="), player.func_110124_au());
                    player.func_145747_a((ITextComponent)new StringTextComponent("Health: " + entity.func_110143_aJ()), player.func_110124_au());
                    player.func_145747_a((ITextComponent)new StringTextComponent("Infection Rate: " + h.getInfectionProgress() + "%"), player.func_110124_au());
                    if (player.func_184812_l_() && entity instanceof VillagerEntity) {
                        player.func_145747_a((ITextComponent)new StringTextComponent("Immortuos Follower: " + h.isFollower()), player.func_110124_au());
                    }
                });
            } else {
                event.getEntity().func_145747_a((ITextComponent)new StringTextComponent("Invalid Target."), event.getEntity().func_110124_au());
            }
        }
    }

    private static void AntiParasiticCure(Entity target) {
        target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() <= 40) {
                h.addInfectionProgress(-10);
            }
            if (h.getInfectionProgress() < 0) {
                h.setInfectionProgress(0);
            }
            h.setResistance(ImmortuosCalyx.config.RESISTGIVENAP.get());
        });
        target.func_70097_a(InternalOrganDamage.causeInternalDamage(target), 2.0f);
    }

    private static void CalyxideCure(Entity target) {
        target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() >= 75) {
                int tempinfection = h.getInfectionProgress();
                target.func_70097_a(InternalOrganDamage.causeInternalDamage(target), (float)((tempinfection -= 70) / 5 * 4));
            }
            h.addInfectionProgress(-40);
            if (h.getInfectionProgress() < 0) {
                h.setInfectionProgress(0);
            }
        });
    }

    @SubscribeEvent
    public static void BiomeLoad(BiomeLoadingEvent event) {
        ImmortuosCalyx.DimensionExclusion = CommonConfig.getDimensions();
    }
}

