/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.Infection;

import com.cartoonishvillain.ImmortuosCalyx.Infection.IInfectionManager;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManagerCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class InfectionManager
implements IInfectionManager,
ICapabilityProvider,
INBTSerializable<CompoundNBT> {
    protected int infectionProgress = 0;
    protected int infectionTimer = 0;
    protected double resistance = 1.0;
    protected boolean follower = false;
    public final LazyOptional<IInfectionManager> holder = LazyOptional.of(() -> this);

    @Override
    public int getInfectionProgress() {
        return this.infectionProgress;
    }

    @Override
    public void setInfectionProgress(int infectionProgress) {
        this.infectionProgress = infectionProgress;
    }

    @Override
    public void setInfectionProgressIfLower(int infectionProgress) {
        if (this.infectionProgress < infectionProgress) {
            this.infectionProgress = infectionProgress;
        }
    }

    @Override
    public void addInfectionProgress(int infectionProgress) {
        this.infectionProgress += infectionProgress;
    }

    @Override
    public int getInfectionTimer() {
        return this.infectionTimer;
    }

    @Override
    public void addInfectionTimer(int Time) {
        this.infectionTimer += Time;
    }

    @Override
    public void setInfectionTimer(int Time) {
        this.infectionTimer = Time;
    }

    @Override
    public double getResistance() {
        return this.resistance;
    }

    @Override
    public void addResistance(double resistance) {
        this.resistance += resistance;
    }

    @Override
    public void setResistance(double resistance) {
        this.resistance = resistance;
    }

    @Override
    public void setFollower(boolean isFollower) {
        this.follower = isFollower;
    }

    @Override
    public boolean isFollower() {
        return this.follower;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == InfectionManagerCapability.INSTANCE) {
            return InfectionManagerCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public CompoundNBT serializeNBT() {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74768_a("infectionProgression", this.infectionProgress);
        tag.func_74768_a("infectionTimer", this.infectionTimer);
        tag.func_74780_a("infectionResistance", this.resistance);
        tag.func_74757_a("infectionFollower", this.follower);
        return tag;
    }

    public void deserializeNBT(CompoundNBT nbt) {
        this.infectionProgress = nbt.func_74762_e("infectionProgression");
        this.infectionTimer = nbt.func_74762_e("infectionTimer");
        this.resistance = nbt.func_74760_g("infectionResistance");
        this.follower = nbt.func_74767_n("infectionFollower");
    }
}

