/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.Events;

import com.cartoonishvillain.ImmortuosCalyx.Configs.CommonConfig;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedDiverEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedHumanEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedIGEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedVillagerEntity;
import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManagerCapability;
import com.cartoonishvillain.ImmortuosCalyx.InternalOrganDamage;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import com.cartoonishvillain.ImmortuosCalyx.commands.SetInfectionRateCommand;
import com.google.common.util.concurrent.AtomicDouble;
import com.mojang.brigadier.CommandDispatcher;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Slime;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immortuoscalyx", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class NonInfectionEvents {
    @SubscribeEvent
    public static void commandRegister(RegisterCommandsEvent event) {
        SetInfectionRateCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
    }

    @SubscribeEvent
    public static void playerCloneEvent(PlayerEvent.Clone event) {
        if (!event.isWasDeath()) {
            AtomicInteger infectionProgress = new AtomicInteger(Integer.MAX_VALUE);
            AtomicInteger infectionTimer = new AtomicInteger(Integer.MAX_VALUE);
            AtomicDouble resistance = new AtomicDouble(Double.MAX_VALUE);
            Player originalPlayer = event.getOriginal();
            Player newPlayer = event.getPlayer();
            originalPlayer.revive();
            originalPlayer.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                infectionProgress.set(h.getInfectionProgress());
                infectionTimer.set(h.getInfectionTimer());
                resistance.set(h.getResistance());
            });
            originalPlayer.m_6074_();
            newPlayer.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                h.setInfectionProgress(infectionProgress.get());
                h.setInfectionTimer(infectionTimer.get());
                h.setResistance(resistance.get());
            });
        }
    }

    @SubscribeEvent
    public static void selfUseCalyxide(PlayerInteractEvent.RightClickItem event) {
        Player player;
        if (event.getEntity() instanceof Player && event.getItemStack().m_41720_().equals(Register.CALYXANIDE.get()) && (player = (Player)event.getEntity()).m_6047_()) {
            NonInfectionEvents.CalyxideCure((Entity)player);
            event.getItemStack().m_41774_(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void selfUseAntiParasite(PlayerInteractEvent.RightClickItem event) {
        Player player;
        if (event.getEntity() instanceof Player && event.getItemStack().m_41720_().equals(Register.GENERALANTIPARASITIC.get()) && (player = (Player)event.getEntity()).m_6047_()) {
            NonInfectionEvents.AntiParasiticCure((Entity)player);
            event.getItemStack().m_41774_(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void selfUseCEggs(PlayerInteractEvent.RightClickItem event) {
        Player player;
        if (event.getEntity() instanceof Player && event.getItemStack().m_41720_().equals(Register.IMMORTUOSCALYXEGGS.get()) && (player = (Player)event.getEntity()).m_6047_()) {
            player.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() == 0) {
                    h.addInfectionProgress(ImmortuosCalyx.config.EGGINFECTIONSTART.get());
                }
            });
            event.getItemStack().m_41774_(1);
            if (event.getSide() == LogicalSide.SERVER) {
                event.getWorld().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useCalyxide(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player user = (Player)event.getEntity();
        if (user.m_21205_().m_41720_().equals(Register.CALYXANIDE.get())) {
            user.m_21205_().m_41774_(1);
            NonInfectionEvents.CalyxideCure(target);
            event.setCanceled(true);
            if (!event.getTarget().f_19853_.m_5776_()) {
                target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useAntiParasite(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player user = (Player)event.getEntity();
        if (user.m_21205_().m_41720_().equals(Register.GENERALANTIPARASITIC.get())) {
            user.m_21205_().m_41774_(1);
            NonInfectionEvents.AntiParasiticCure(target);
            event.setCanceled(true);
            if (!event.getTarget().f_19853_.m_5776_()) {
                target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        }
    }

    @SubscribeEvent
    public static void useCEggs(AttackEntityEvent event) {
        Entity target = event.getTarget();
        Player user = (Player)event.getEntity();
        if (user.m_21205_().m_41720_().equals(Register.IMMORTUOSCALYXEGGS.get())) {
            user.m_21205_().m_41774_(1);
            target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() == 0) {
                    h.addInfectionProgress(ImmortuosCalyx.config.EGGINFECTIONSTART.get());
                }
            });
            event.setCanceled(true);
            if (!event.getTarget().f_19853_.m_5776_()) {
                target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)Register.INJECT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
            if (target instanceof InfectedDiverEntity || target instanceof InfectedHumanEntity || target instanceof InfectedVillagerEntity) {
                ((Monster)target).m_7292_(new MobEffectInstance(MobEffects.f_19596_, 600, 2, true, false));
                ((Monster)target).m_7292_(new MobEffectInstance(MobEffects.f_19600_, 600, 1, true, false));
            }
        }
    }

    @SubscribeEvent
    public static void playerResistanceDownTick(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            Player playerEntity = event.player;
            playerEntity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                h.addResistance(-0.001);
                if (h.getResistance() < 1.0) {
                    h.setResistance(1.0);
                }
            });
        }
    }

    @SubscribeEvent
    public static void playerExtract(PlayerInteractEvent.EntityInteract event) {
        Entity target = event.getTarget();
        if (event.getSide() == LogicalSide.SERVER && event.getHand() == InteractionHand.MAIN_HAND) {
            Player player;
            if (event.getTarget() instanceof Slime && event.getEntity() instanceof Player) {
                Player player2 = (Player)event.getEntity();
                if (player2.m_21205_().m_41720_().equals(Register.SYRINGE.get())) {
                    ItemStack olditemstack = player2.m_21205_();
                    olditemstack.m_41774_(1);
                    ItemStack itemStack = new ItemStack((ItemLike)Register.GENERALANTIPARASITIC.get());
                    player2.m_150109_().m_36054_(itemStack);
                    if (!event.getEntity().f_19853_.m_5776_()) {
                        target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)Register.EXTRACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    }
                }
            } else if ((event.getTarget() instanceof InfectedHumanEntity || event.getTarget() instanceof InfectedDiverEntity || event.getTarget() instanceof InfectedVillagerEntity || event.getTarget() instanceof InfectedIGEntity && event.getEntity() instanceof Player) && (player = (Player)event.getEntity()).m_21205_().m_41720_().equals(Register.SYRINGE.get())) {
                ItemStack olditemstack = player.m_21205_();
                olditemstack.m_41774_(1);
                ItemStack itemStack = new ItemStack((ItemLike)Register.IMMORTUOSCALYXEGGS.get());
                player.m_150109_().m_36054_(itemStack);
                if (!target.m_20193_().m_5776_()) {
                    target.m_20193_().m_6263_(null, target.m_20185_(), target.m_20186_(), target.m_20189_(), (SoundEvent)Register.EXTRACT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                }
            }
        }
    }

    @SubscribeEvent
    public static void selfScan(PlayerInteractEvent.RightClickItem event) {
        if (event.getSide() == LogicalSide.SERVER && event.getEntity() instanceof Player && event.getItemStack().m_41720_().equals(Register.SCANNER.get()) && event.getEntity().m_6047_()) {
            Player p = (Player)event.getEntity();
            event.getEntity().getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                p.m_6352_((Component)new TextComponent("===(" + p.m_6302_() + "'s stats)==="), p.m_142081_());
                p.m_6352_((Component)new TextComponent("Saturation level: " + p.m_36324_().m_38722_()), p.m_142081_());
                p.m_6352_((Component)new TextComponent("Infection Level: " + h.getInfectionProgress() + "%"), p.m_142081_());
                p.m_6352_((Component)new TextComponent("Resistance Multiplier: " + h.getResistance()), p.m_142081_());
            });
        }
    }

    @SubscribeEvent
    public static void Scan(AttackEntityEvent event) {
        if (!event.getEntity().m_20193_().m_5776_() && event.getEntity() instanceof Player && ((Player)event.getEntity()).m_21205_().m_41720_().equals(Register.SCANNER.get())) {
            event.setCanceled(true);
            if (event.getTarget() instanceof Player) {
                Player t = (Player)event.getTarget();
                Player a = (Player)event.getEntity();
                t.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                    a.m_6352_((Component)new TextComponent("===(" + t.m_6302_() + "'s stats)==="), a.m_142081_());
                    a.m_6352_((Component)new TextComponent("Health: " + t.m_21223_()), a.m_142081_());
                    a.m_6352_((Component)new TextComponent("Food: " + t.m_36324_().m_38702_()), a.m_142081_());
                    a.m_6352_((Component)new TextComponent("Infection Level: " + h.getInfectionProgress() + "%"), a.m_142081_());
                    a.m_6352_((Component)new TextComponent("Resistance Multiplier: " + h.getResistance()), a.m_142081_());
                });
            } else if (event.getTarget() instanceof InfectedHumanEntity || event.getTarget() instanceof InfectedDiverEntity || event.getTarget() instanceof InfectedIGEntity || event.getTarget() instanceof InfectedVillagerEntity) {
                event.getEntity().m_6352_((Component)new TextComponent("===(Target completely infected)==="), event.getEntity().m_142081_());
            } else if (event.getTarget() instanceof LivingEntity) {
                LivingEntity entity = (LivingEntity)event.getTarget();
                Player player = (Player)event.getEntity();
                entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                    player.m_6352_((Component)new TextComponent("===(" + entity.m_7755_().getString() + "'s stats)==="), player.m_142081_());
                    player.m_6352_((Component)new TextComponent("Health: " + entity.m_21223_()), player.m_142081_());
                    player.m_6352_((Component)new TextComponent("Infection Rate: " + h.getInfectionProgress() + "%"), player.m_142081_());
                    if (player.m_7500_() && entity instanceof Villager) {
                        player.m_6352_((Component)new TextComponent("Immortuos Follower: " + h.isFollower()), player.m_142081_());
                    }
                });
            } else {
                event.getEntity().m_6352_((Component)new TextComponent("Invalid Target."), event.getEntity().m_142081_());
            }
        }
    }

    private static void AntiParasiticCure(Entity target) {
        target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() <= 40) {
                h.addInfectionProgress(-10);
            }
            if (h.getInfectionProgress() < 0) {
                h.setInfectionProgress(0);
            }
            h.setResistance(ImmortuosCalyx.config.RESISTGIVENAP.get());
        });
        target.m_6469_(InternalOrganDamage.causeInternalDamage(target), 2.0f);
    }

    private static void CalyxideCure(Entity target) {
        target.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() >= 75) {
                int tempinfection = h.getInfectionProgress();
                target.m_6469_(InternalOrganDamage.causeInternalDamage(target), (float)((tempinfection -= 70) / 5 * 4));
            }
            h.addInfectionProgress(-40);
            if (h.getInfectionProgress() < 0) {
                h.setInfectionProgress(0);
            }
        });
    }

    @SubscribeEvent
    public static void BiomeLoad(BiomeLoadingEvent event) {
        ImmortuosCalyx.DimensionExclusion = CommonConfig.getDimensions();
    }
}

