/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.Events;

import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedDiverEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedHumanEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedIGEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedPlayerEntity;
import com.cartoonishvillain.ImmortuosCalyx.Entity.InfectedVillagerEntity;
import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Infection.IInfectionManager;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionDamage;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionHandler;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManager;
import com.cartoonishvillain.ImmortuosCalyx.Infection.InfectionManagerCapability;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Random;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.ServerChatEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="immortuoscalyx", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class PlayerInfectionEventManager {
    static ArrayList<Item> rawItem = new ArrayList<Item>(Arrays.asList(Items.f_42579_, Items.f_42697_, Items.f_42581_, Items.f_42485_, Items.f_42658_, Items.f_42526_, Items.f_42527_, Items.f_42583_));

    @SubscribeEvent
    public static void onAttachCapabilitiesEvent(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            InfectionManager provider = new InfectionManager();
            event.addCapability(new ResourceLocation("immortuoscalyx", "infection"), (ICapabilityProvider)provider);
        }
    }

    @SubscribeEvent
    public static void InfectionTicker(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START) {
            Player player = event.player;
            player.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= 1 && PlayerInfectionEventManager.ValidPlayer(event.player)) {
                    h.addInfectionTimer(1);
                    int timer = ImmortuosCalyx.config.INFECTIONTIMER.get();
                    if (h.getInfectionTimer() >= timer) {
                        h.addInfectionProgress(1);
                        h.addInfectionTimer(-timer);
                        PlayerInfectionEventManager.EffectController(event.player);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void InfectionTickEffects(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.SERVER && event.phase == TickEvent.Phase.START && PlayerInfectionEventManager.ValidPlayer(event.player)) {
            Player player = event.player;
            player.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                Random random;
                int randomValue;
                float temperature;
                BlockPos CurrentPosition;
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTSPEED.get()) {
                    CurrentPosition = new BlockPos(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    temperature = player.f_19853_.m_7062_().m_47881_(CurrentPosition).m_47505_(CurrentPosition);
                    if ((double)temperature > 0.9 && ImmortuosCalyx.config.HEATSLOW.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 0, true, false));
                    } else if ((double)temperature < 0.275 && ImmortuosCalyx.config.COLDFAST.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19596_, 5, 0, true, false));
                    }
                }
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTSTRENGTH.get()) {
                    CurrentPosition = new BlockPos(player.m_20185_(), player.m_20186_(), player.m_20189_());
                    temperature = player.f_19853_.m_7062_().m_47881_(CurrentPosition).m_47505_(CurrentPosition);
                    if ((double)temperature > 0.275 && ImmortuosCalyx.config.WARMWEAKNESS.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 5, 0, true, false));
                    } else if ((double)temperature <= 0.275 && ImmortuosCalyx.config.COLDSTRENGTH.get().booleanValue()) {
                        player.m_7292_(new MobEffectInstance(MobEffects.f_19600_, 5, 0, true, false));
                    }
                }
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTBLIND.get() && ImmortuosCalyx.config.BLINDNESS.get().booleanValue()) {
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19610_, 50, 1, true, false));
                }
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTDAMAGE.get() && (randomValue = (random = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
                    player.m_6469_(InfectionDamage.causeInfectionDamage((Entity)player), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
                }
            });
        }
    }

    @SubscribeEvent
    public static void InfectionChat(ServerChatEvent event) {
        ServerPlayer player = event.getPlayer();
        if (PlayerInfectionEventManager.ValidPlayer((Player)player)) {
            player.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(arg_0 -> PlayerInfectionEventManager.lambda$InfectionChat$2((Player)player, event, arg_0));
        }
    }

    @SubscribeEvent
    public static void InfectMobFromAttack(LivingAttackEvent event) {
        if (!(!(event.getSource().m_7639_() instanceof LivingEntity) || event.getEntityLiving().f_19853_.f_46443_ || ImmortuosCalyx.DimensionExclusion.contains(event.getEntity().f_19853_.m_46472_().m_135782_()) && (ImmortuosCalyx.commonConfig.HOSTILEINFECTIONINCLEANSE.get().booleanValue() || event.getEntityLiving().f_19853_.m_5776_()))) {
            LivingEntity aggro = (LivingEntity)event.getSource().m_7639_();
            LivingEntity victim = event.getEntityLiving();
            if (aggro instanceof Player && PlayerInfectionEventManager.ValidPlayer((Player)aggro)) {
                if (victim instanceof Player) {
                    InfectionHandler.infectPlayerByPlayer((Player)aggro, (Player)victim, 1);
                } else {
                    InfectionHandler.infectEntityByPlayer((Player)aggro, victim, 1);
                }
            } else if (aggro instanceof InfectedHumanEntity || aggro instanceof InfectedDiverEntity || aggro instanceof InfectedPlayerEntity) {
                InfectionHandler.infectEntity(victim, 95.0f, 1);
            } else if (aggro instanceof InfectedIGEntity) {
                InfectionHandler.infectEntity(victim, 75.0f, 1);
            } else if (aggro instanceof InfectedVillagerEntity) {
                if (victim instanceof Villager || victim instanceof AbstractGolem) {
                    InfectionHandler.infectEntity(victim, 100.0f, 1);
                } else {
                    InfectionHandler.infectEntity(victim, 55.0f, 1);
                }
            } else if (!(aggro instanceof Player)) {
                InfectionHandler.infectEntity(aggro, victim, 1);
            }
        }
    }

    @SubscribeEvent
    public static void rawFood(LivingEntityUseItemEvent.Finish event) {
        if (!(!(event.getEntity() instanceof Player) || ImmortuosCalyx.DimensionExclusion.contains(event.getEntity().f_19853_.m_46472_().m_135782_()) && ImmortuosCalyx.commonConfig.RAWFOODINFECTIONINCLEANSE.get().booleanValue())) {
            Player player = (Player)event.getEntity();
            boolean raw = rawItem.contains(event.getItem().m_41720_());
            if (raw) {
                InfectionHandler.bioInfect((LivingEntity)player, ImmortuosCalyx.config.RAWFOODINFECTIONVALUE.get().intValue(), 1);
            }
        }
    }

    private static void EffectController(Player inflictedPlayer) {
        inflictedPlayer.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            int progressionLogic = h.getInfectionProgress();
            if (progressionLogic == ImmortuosCalyx.config.EFFECTMESSAGEONE.get()) {
                inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "Your throat feels sore"), inflictedPlayer.m_142081_());
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTMESSAGETWO.get()) {
                inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "Your mind feels foggy"), inflictedPlayer.m_142081_());
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTCHAT.get()) {
                if (ImmortuosCalyx.config.ANTICHAT.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You feel something moving around in your head, you try to yell, but nothing comes out"), inflictedPlayer.m_142081_());
                }
            } else if (progressionLogic == ImmortuosCalyx.config.PLAYERINFECTIONTHRESHOLD.get()) {
                if (ImmortuosCalyx.config.PVPCONTAGION.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "There is something on your skin and you can't get it off.."), inflictedPlayer.m_142081_());
                }
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTSPEED.get()) {
                if (ImmortuosCalyx.config.COLDFAST.get().booleanValue() && ImmortuosCalyx.config.HEATSLOW.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You start feeling ill in warm environments, and better in cool ones.."), inflictedPlayer.m_142081_());
                } else if (ImmortuosCalyx.config.COLDFAST.get().booleanValue() && !ImmortuosCalyx.config.HEATSLOW.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You begin to feel better in cool environments.."), inflictedPlayer.m_142081_());
                } else if (ImmortuosCalyx.config.HEATSLOW.get().booleanValue() && !ImmortuosCalyx.config.COLDFAST.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You begin feeling ill in warm environments..."), inflictedPlayer.m_142081_());
                }
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTSTRENGTH.get()) {
                if (ImmortuosCalyx.config.COLDSTRENGTH.get().booleanValue() && ImmortuosCalyx.config.WARMWEAKNESS.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You begin to feel weak in all but the coldest environments.."), inflictedPlayer.m_142081_());
                } else if (ImmortuosCalyx.config.COLDSTRENGTH.get().booleanValue() && !ImmortuosCalyx.config.WARMWEAKNESS.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You begin to feel strong in cold environments.."), inflictedPlayer.m_142081_());
                } else if (ImmortuosCalyx.config.WARMWEAKNESS.get().booleanValue() && !ImmortuosCalyx.config.COLDSTRENGTH.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You begin to feel weak in warm environments.."), inflictedPlayer.m_142081_());
                }
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTBLIND.get()) {
                if (ImmortuosCalyx.config.BLINDNESS.get().booleanValue()) {
                    inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "Your vision gets darker and darker.."), inflictedPlayer.m_142081_());
                }
            } else if (progressionLogic == ImmortuosCalyx.config.EFFECTDAMAGE.get() && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
                inflictedPlayer.m_6352_((Component)new TextComponent(ChatFormatting.RED + "You feel an overwhelming pain in your head..."), inflictedPlayer.m_142081_());
            }
        });
    }

    private static boolean ValidPlayer(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    private static /* synthetic */ void lambda$InfectionChat$2(Player player, ServerChatEvent event, IInfectionManager h) {
        String name = player.m_7755_().getString();
        String format = "<" + name + "> ";
        if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTCHAT.get() && ImmortuosCalyx.config.ANTICHAT.get().booleanValue() && ImmortuosCalyx.config.FORMATTEDINFECTCHAT.get().booleanValue()) {
            event.setComponent((Component)new TextComponent(format + ChatFormatting.OBFUSCATED + event.getMessage()));
        }
        if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTCHAT.get() && ImmortuosCalyx.config.ANTICHAT.get().booleanValue() && !ImmortuosCalyx.config.FORMATTEDINFECTCHAT.get().booleanValue()) {
            event.setCanceled(true);
        }
        if (h.getInfectionProgress() >= ImmortuosCalyx.config.EFFECTCHAT.get() && !player.m_20193_().m_5776_() && ImmortuosCalyx.config.INFECTEDCHATNOISE.get().booleanValue()) {
            player.f_19853_.m_5594_(null, player.m_142538_(), (SoundEvent)Register.HUMANAMBIENT.get(), SoundSource.PLAYERS, 0.5f, 2.0f);
        }
    }
}

