/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.entity;

import com.cartoonishvillain.ImmortuosCalyx.Register;
import com.cartoonishvillain.ImmortuosCalyx.entity.InfectedEntity;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionManagerCapability;
import java.util.ArrayList;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

public class InfectedIGEntity
extends IronGolem
implements InfectedEntity {
    public InfectedIGEntity(EntityType<InfectedIGEntity> type, Level worldIn) {
        super(type, worldIn);
    }

    public static AttributeSupplier.Builder customAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 125.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 5.0).m_22268_(Attributes.f_22278_, 1.0);
    }

    protected void m_8099_() {
        super.m_8099_();
        InfectedIGEntity entity = this;
        if (!entity.f_19853_.m_5776_()) {
            Set prioritizedGoals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)entity.f_21346_, (String)"f_25345_");
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            if (prioritizedGoals != null) {
                for (WrappedGoal prioritizedGoal : prioritizedGoals) {
                    toRemove.add(prioritizedGoal.m_26015_());
                }
            }
            for (Goal goal : toRemove) {
                entity.f_21346_.m_25363_(goal);
            }
            entity.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)entity, Pillager.class, 16, true, false, entity::shouldAttack));
            entity.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)entity, Monster.class, 16, true, false, entity::shouldAttackMonster));
            entity.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, AbstractVillager.class, 16, true, false, entity::shouldAttack));
            entity.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, 16, true, false, entity::shouldAttack));
            entity.f_21346_.m_25352_(5, (Goal)new NearestAttackableTargetGoal((Mob)entity, AbstractGolem.class, 16, true, false, entity::shouldAttackMonster));
        }
    }

    public boolean shouldAttack(@Nullable LivingEntity entity) {
        if (entity != null) {
            AtomicBoolean infectedThreshold = new AtomicBoolean(false);
            entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= 50) {
                    infectedThreshold.set(true);
                }
            });
            return !infectedThreshold.get();
        }
        return false;
    }

    @Override
    public boolean shouldAttackMonster(@Nullable LivingEntity entity) {
        if (entity != null) {
            return !(entity instanceof InfectedEntity);
        }
        return false;
    }

    public boolean m_6785_(double distanceToClosestPlayer) {
        return false;
    }

    protected boolean m_8028_() {
        return true;
    }

    protected int m_6552_(Player player) {
        return 5 + this.f_19853_.f_46441_.nextInt(5);
    }

    protected SoundEvent m_5592_() {
        return (SoundEvent)Register.IGDEATH.get();
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return (SoundEvent)Register.IGHURT.get();
    }

    protected void m_7355_(BlockPos pos, BlockState blockIn) {
        this.m_5496_(SoundEvents.f_12010_, 0.15f, 1.0f);
    }

    public void m_8107_() {
        super.m_8107_();
        this.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() < 100) {
                h.setInfectionProgress(100);
            }
        });
    }
}

