/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.events;

import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import com.cartoonishvillain.ImmortuosCalyx.entity.InfectedDiverEntity;
import com.cartoonishvillain.ImmortuosCalyx.entity.InfectedEntity;
import com.cartoonishvillain.ImmortuosCalyx.entity.InfectedIGEntity;
import com.cartoonishvillain.ImmortuosCalyx.entity.InfectedPlayerEntity;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionDamage;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionHandler;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionManagerCapability;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.GoalSelector;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.animal.AbstractGolem;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.util.ObfuscationReflectionHelper;

@Mod.EventBusSubscriber(modid="immortuoscalyx", bus=Mod.EventBusSubscriber.Bus.FORGE)
public class EntityInfectionEventManager {
    private static final ArrayList<String> DISQUALIFYINGDAMAGE = new ArrayList<String>(List.of("lightningBolt", "lava", "outOfWorld", "explosion"));

    @SubscribeEvent
    public static void InfectionTicker(LivingEvent.LivingUpdateEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!(entity instanceof Player)) {
            entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= 1) {
                    h.addInfectionTimer(1);
                    int timer = -1;
                    timer = entity instanceof Villager ? ImmortuosCalyx.config.VILLAGERINFECTIONTIMER.get() : (entity instanceof IronGolem ? ImmortuosCalyx.config.IRONGOLEMTIMER.get().intValue() : ImmortuosCalyx.config.INFECTIONTIMER.get().intValue());
                    if (h.getInfectionTimer() >= timer) {
                        if (h.isResistant() && h.getInfectionProgress() == ImmortuosCalyx.config.EFFECTIMPEDEMENT.get().intValue()) {
                            return;
                        }
                        if (h.isResistant() && h.getInfectionProgress() > ImmortuosCalyx.config.EFFECTIMPEDEMENT.get()) {
                            h.setInfectionProgress(ImmortuosCalyx.config.EFFECTIMPEDEMENT.get());
                            return;
                        }
                        h.addInfectionProgress(1);
                        h.addInfectionTimer(-timer);
                    }
                }
            });
        }
    }

    @SubscribeEvent
    public static void InfectionLogic(LivingEvent.LivingUpdateEvent event) {
        AtomicInteger infectionlevel = new AtomicInteger(0);
        AtomicBoolean isFollower = new AtomicBoolean(false);
        LivingEntity entity = event.getEntityLiving();
        entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            infectionlevel.getAndSet(h.getInfectionProgress());
            isFollower.set(h.isFollower());
        });
        int level = infectionlevel.get();
        if (level > 0) {
            if (entity instanceof Villager) {
                EntityInfectionEventManager.VillagerLogic((Villager)entity, level, isFollower.get());
            }
            if (entity instanceof IronGolem && !(entity instanceof InfectedIGEntity)) {
                EntityInfectionEventManager.IGLogic((IronGolem)entity, level);
            }
        }
    }

    public static void VillagerLogic(Villager entity, int level, boolean isFollower) {
        if (!isFollower) {
            Random rand;
            int random;
            if (level >= ImmortuosCalyx.config.VILLAGERSLOWTWO.get()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 2, false, false));
            } else if (level >= ImmortuosCalyx.config.VILLAGERSLOWONE.get()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 1, false, false));
            }
            if (level >= ImmortuosCalyx.config.VILLAGERLETHAL.get() && (random = (rand = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
                entity.m_6469_(InfectionDamage.causeInfectionDamage((Entity)entity), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
            }
        } else {
            Random rand;
            int random;
            if (level >= ImmortuosCalyx.config.VILLAGERSLOWTWO.get() * ImmortuosCalyx.config.VILLAGERFOLLOWERIMMUNITY.get()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 2, false, false));
            } else if (level >= ImmortuosCalyx.config.VILLAGERSLOWONE.get() * ImmortuosCalyx.config.VILLAGERFOLLOWERIMMUNITY.get()) {
                entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 1, false, false));
            }
            if (level >= ImmortuosCalyx.config.VILLAGERLETHAL.get() * ImmortuosCalyx.config.VILLAGERFOLLOWERIMMUNITY.get() && (random = (rand = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
                entity.m_6469_(InfectionDamage.causeInfectionDamage((Entity)entity), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
            }
        }
    }

    public static void IGLogic(IronGolem entity, int level) {
        Random rand;
        int random;
        if (level >= ImmortuosCalyx.config.IRONGOLEMSLOW.get()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19597_, 5, 1, false, false));
        }
        if (level >= ImmortuosCalyx.config.IRONGOLEMWEAK.get()) {
            entity.m_7292_(new MobEffectInstance(MobEffects.f_19613_, 5, 1, false, false));
        }
        if (level >= ImmortuosCalyx.config.IRONGOLEMLETHAL.get() && (random = (rand = new Random()).nextInt(100)) < 1 && ImmortuosCalyx.config.INFECTIONDAMAGE.get() > 0) {
            entity.m_6469_(InfectionDamage.causeInfectionDamage((Entity)entity), (float)ImmortuosCalyx.config.INFECTIONDAMAGE.get().intValue());
        }
    }

    @SubscribeEvent
    public static void antiTrade(PlayerInteractEvent.EntityInteract event) {
        if (!event.getTarget().m_20193_().m_5776_() && event.getHand() == InteractionHand.MAIN_HAND && event.getTarget() instanceof Villager) {
            Villager villager = (Villager)event.getTarget();
            villager.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.VILLAGERNOTRADE.get()) {
                    event.setCanceled(true);
                    villager.m_35319_(40);
                    villager.m_20193_().m_6263_(null, villager.m_20185_(), villager.m_20186_(), villager.m_20189_(), (SoundEvent)Register.VILIDLE.get(), SoundSource.NEUTRAL, 1.0f, 1.0f);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void deathEntityReplacement(LivingDeathEvent event) {
        LivingEntity entity = event.getEntityLiving();
        if (!event.isCanceled()) {
            Level world;
            if (event.getSource().f_19326_.equals("infection")) {
                Level world2 = event.getEntityLiving().m_20193_();
                if (!world2.m_5776_()) {
                    ServerLevel serverWorld = (ServerLevel)world2;
                    EntityInfectionEventManager.summonConversion(serverWorld, entity);
                }
            } else if (!DISQUALIFYINGDAMAGE.contains(event.getSource().f_19326_) && ImmortuosCalyx.config.INFECTONDEATH.get().booleanValue() && !(world = event.getEntity().m_20193_()).m_5776_() && !(entity instanceof Villager)) {
                entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                    float chance = (h.getInfectionProgress() - 50) * 2;
                    if (chance > (float)world.m_5822_().nextInt(100)) {
                        ServerLevel serverWorld = (ServerLevel)world;
                        EntityInfectionEventManager.summonConversion(serverWorld, entity);
                    }
                });
            }
        }
    }

    private static void summonConversion(ServerLevel serverWorld, LivingEntity entity) {
        if (entity instanceof Player) {
            InfectedPlayerEntity infectedPlayerEntity = new InfectedPlayerEntity((EntityType<InfectedPlayerEntity>)((EntityType)Register.INFECTEDPLAYER.get()), (Level)serverWorld);
            infectedPlayerEntity.m_6593_(entity.m_7755_());
            infectedPlayerEntity.setPUUID(entity.m_142081_());
            infectedPlayerEntity.m_6034_(entity.m_20185_(), entity.m_20186_() + 0.1, entity.m_20189_());
            serverWorld.m_7967_((Entity)infectedPlayerEntity);
        } else if (entity instanceof AbstractVillager) {
            ((EntityType)Register.INFECTEDVILLAGER.get()).m_20592_(serverWorld, new ItemStack((ItemLike)Items.f_41852_), null, entity.m_142538_(), MobSpawnType.TRIGGERED, true, false);
        } else if (entity instanceof IronGolem) {
            ((EntityType)Register.INFECTEDIG.get()).m_20592_(serverWorld, new ItemStack((ItemLike)Items.f_41852_), null, entity.m_142538_(), MobSpawnType.TRIGGERED, true, false);
        }
    }

    @SubscribeEvent
    public static void InfectionByAir(LivingEvent.LivingUpdateEvent event) {
        block12: {
            LivingEntity sourceEntity = event.getEntityLiving();
            Random rand = new Random();
            if (ImmortuosCalyx.DimensionExclusion.contains(sourceEntity.f_19853_.m_46472_().m_135782_()) && ImmortuosCalyx.commonConfig.HOSTILEAEROSOLINFECTIONINCLEANSE.get().booleanValue() || sourceEntity.f_19853_.m_5776_()) break block12;
            int AerosolRate = Integer.MAX_VALUE;
            boolean common = false;
            if (sourceEntity instanceof InfectedEntity) {
                AerosolRate = ImmortuosCalyx.config.INFECTEDAERIALRATE.get();
            } else if (sourceEntity instanceof Zombie) {
                AerosolRate = ImmortuosCalyx.config.ZOMBIEAERIALRATE.get();
            } else if (sourceEntity instanceof Villager) {
                AerosolRate = ImmortuosCalyx.config.FOLLOWERAERIALRATE.get();
            } else {
                common = true;
                AerosolRate = ImmortuosCalyx.config.COMMONAERIALRATE.get();
            }
            if (AerosolRate != Integer.MAX_VALUE && rand.nextInt(AerosolRate) == 2) {
                ArrayList entities = (ArrayList)sourceEntity.f_19853_.m_6249_((Entity)sourceEntity, sourceEntity.m_142469_().m_82400_(2.0), entity -> true);
                ArrayList<LivingEntity> livingEntityList = new ArrayList<LivingEntity>();
                for (Entity entity2 : entities) {
                    if (!(entity2 instanceof LivingEntity)) continue;
                    livingEntityList.add((LivingEntity)entity2);
                }
                if (!common) {
                    for (LivingEntity victim : livingEntityList) {
                        InfectionHandler.bioInfect(victim, AerosolRate, 1);
                    }
                } else {
                    for (LivingEntity victim : livingEntityList) {
                        InfectionHandler.commonAerosol(victim, sourceEntity, 1);
                    }
                }
            }
        }
    }

    @SubscribeEvent
    public static void GolemSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof AbstractGolem && !sEntity.f_19853_.m_5776_() && !(sEntity instanceof InfectedEntity)) {
            AbstractGolem golemEntity = (AbstractGolem)sEntity;
            golemEntity.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)golemEntity, InfectedIGEntity.class, true, false));
        }
    }

    @SubscribeEvent
    public static void DiverSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof InfectedDiverEntity && !sEntity.f_19853_.m_5776_()) {
            InfectedDiverEntity entity = (InfectedDiverEntity)sEntity;
            Set prioritizedGoals = (Set)ObfuscationReflectionHelper.getPrivateValue(GoalSelector.class, (Object)entity.f_21346_, (String)"f_25345_");
            ArrayList<Goal> toRemove = new ArrayList<Goal>();
            if (prioritizedGoals != null) {
                for (WrappedGoal prioritizedGoal : prioritizedGoals) {
                    toRemove.add(prioritizedGoal.m_26015_());
                }
            }
            for (Goal goal : toRemove) {
                entity.f_21346_.m_25363_(goal);
            }
            entity.f_21346_.m_25352_(1, (Goal)new NearestAttackableTargetGoal((Mob)entity, Player.class, 10, true, false, entity::m_32395_));
            entity.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, AbstractVillager.class, 10, true, false, entity::m_32395_));
            entity.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)entity, AbstractGolem.class, 10, true, false, entity::shouldAttackMonster));
        }
    }

    @SubscribeEvent
    public static void VillagerSpawnEvent(EntityJoinWorldEvent event) {
        Entity sEntity = event.getEntity();
        if (sEntity instanceof Villager && !((Villager)sEntity).m_6162_() && !event.getWorld().m_5776_()) {
            sEntity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (event.getWorld().m_5822_().nextInt(ImmortuosCalyx.config.VILLAGERFOLLOWERCHANCE.get()) < 2) {
                    h.setInfectionProgressIfLower(1);
                    h.setFollower(true);
                }
            });
        }
    }
}

