/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.infection;

import com.cartoonishvillain.ImmortuosCalyx.ImmortuosCalyx;
import com.cartoonishvillain.ImmortuosCalyx.Register;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionManagerCapability;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class InfectionHandler {
    public static void infectEntity(LivingEntity victim, float infectChance, int amount) {
        victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            double bioResist;
            int armorProtection = (int)((double)victim.m_21230_() * ImmortuosCalyx.config.ARMORRESISTMULTIPLIER.get());
            int InfectThreshold = (int)((double)(infectChance - (float)armorProtection) / (bioResist = h.getResistance()));
            if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                h.setInfectionProgressIfLower(amount);
            }
        });
    }

    public static void infectEntity(LivingEntity aggressor, LivingEntity victim, int amount) {
        AtomicInteger infectChance = new AtomicInteger(0);
        aggressor.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> infectChance.set(h.getInfectionProgress()));
        victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            int armorProtection = (int)((double)victim.m_21230_() * ImmortuosCalyx.config.ARMORRESISTMULTIPLIER.get());
            double bioResist = h.getResistance();
            int InfectThreshold = (int)((double)(infectChance.get() - armorProtection) / bioResist);
            if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                h.setInfectionProgressIfLower(amount);
            }
        });
    }

    public static void infectEntityByPlayer(Player aggressor, LivingEntity victim, int amount) {
        AtomicInteger infectChance = new AtomicInteger(0);
        aggressor.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            if (h.getInfectionProgress() >= ImmortuosCalyx.config.PLAYERINFECTIONTHRESHOLD.get()) {
                infectChance.set(h.getInfectionProgress());
            }
        });
        victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            int armorProtection = (int)((double)victim.m_21230_() * ImmortuosCalyx.config.ARMORRESISTMULTIPLIER.get());
            double bioResist = h.getResistance();
            int InfectThreshold = (int)((double)(infectChance.get() - armorProtection) / bioResist);
            if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                h.setInfectionProgressIfLower(amount);
            }
        });
    }

    public static void infectPlayerByPlayer(Player aggressor, Player victim, int amount) {
        if (!(!ImmortuosCalyx.config.PVPCONTAGION.get().booleanValue() || ImmortuosCalyx.DimensionExclusion.contains(victim.f_19853_.m_46472_().m_135782_()) && ImmortuosCalyx.commonConfig.PLAYERINFECTIONINCLEANSE.get().booleanValue())) {
            AtomicInteger infectChance = new AtomicInteger(0);
            aggressor.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                if (h.getInfectionProgress() >= ImmortuosCalyx.config.PLAYERINFECTIONTHRESHOLD.get()) {
                    infectChance.set(h.getInfectionProgress());
                }
            });
            AtomicBoolean successfulTransfer = new AtomicBoolean(false);
            victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
                int armorProtection = (int)((double)victim.m_21230_() * ImmortuosCalyx.config.ARMORRESISTMULTIPLIER.get());
                double bioResist = h.getResistance();
                int InfectThreshold = (int)((double)(infectChance.get() - armorProtection) / bioResist);
                if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                    if (h.getInfectionProgress() == 0) {
                        successfulTransfer.set(true);
                    }
                    h.setInfectionProgressIfLower(amount);
                }
            });
            if (successfulTransfer.get()) {
                aggressor.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> h.addInfectionProgress(-ImmortuosCalyx.config.PVPCONTAGIONRELIEF.get().intValue()));
                if (!aggressor.f_19853_.f_46443_) {
                    aggressor.f_19853_.m_5594_(null, aggressor.m_142538_(), (SoundEvent)Register.HUMANHURT.get(), SoundSource.PLAYERS, 1.0f, 1.2f);
                }
            }
        }
    }

    public static void staticInfect(LivingEntity entity, int amount) {
        entity.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> h.setInfectionProgressIfLower(amount));
    }

    public static void bioInfect(LivingEntity victim, float infectChance, int amount) {
        victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            double bioResist = h.getResistance();
            int InfectThreshold = (int)((double)infectChance / bioResist);
            if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                h.setInfectionProgressIfLower(amount);
            }
        });
    }

    public static void commonAerosol(LivingEntity victim, LivingEntity transmissionVector, int amount) {
        AtomicInteger infectChance = new AtomicInteger(0);
        transmissionVector.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> infectChance.set(h.getInfectionProgress()));
        victim.getCapability(InfectionManagerCapability.INSTANCE).ifPresent(h -> {
            double bioResist = h.getResistance();
            int InfectThreshold = (int)((double)infectChance.get() / bioResist);
            if (InfectThreshold > victim.m_21187_().nextInt(100)) {
                h.setInfectionProgressIfLower(amount);
            }
        });
    }
}

