/*
 * Decompiled with CFR 0.152.
 */
package com.cartoonishvillain.ImmortuosCalyx.infection;

import com.cartoonishvillain.ImmortuosCalyx.infection.IInfectionManager;
import com.cartoonishvillain.ImmortuosCalyx.infection.InfectionManagerCapability;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;

public class InfectionManager
implements IInfectionManager,
ICapabilityProvider,
INBTSerializable<CompoundTag> {
    protected int infectionProgress = 0;
    protected int infectionTimer = 0;
    protected double resistance = 1.0;
    protected boolean follower = false;
    protected boolean resistantDosage = false;
    public final LazyOptional<IInfectionManager> holder = LazyOptional.of(() -> this);

    @Override
    public int getInfectionProgress() {
        return this.infectionProgress;
    }

    @Override
    public void setInfectionProgress(int infectionProgress) {
        this.infectionProgress = infectionProgress;
    }

    @Override
    public void setInfectionProgressIfLower(int infectionProgress) {
        if (this.infectionProgress < infectionProgress) {
            this.infectionProgress = infectionProgress;
        }
    }

    @Override
    public void addInfectionProgress(int infectionProgress) {
        this.infectionProgress += infectionProgress;
    }

    @Override
    public int getInfectionTimer() {
        return this.infectionTimer;
    }

    @Override
    public void addInfectionTimer(int Time) {
        this.infectionTimer += Time;
    }

    @Override
    public void setInfectionTimer(int Time) {
        this.infectionTimer = Time;
    }

    @Override
    public double getResistance() {
        return this.resistance;
    }

    @Override
    public void addResistance(double resistance) {
        this.resistance += resistance;
    }

    @Override
    public void setResistance(double resistance) {
        this.resistance = resistance;
    }

    @Override
    public void setFollower(boolean isFollower) {
        this.follower = isFollower;
    }

    @Override
    public boolean isFollower() {
        return this.follower;
    }

    @Override
    public boolean isResistant() {
        return this.resistantDosage;
    }

    @Override
    public void setResistant(boolean isResistant) {
        this.resistantDosage = isResistant;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == InfectionManagerCapability.INSTANCE) {
            return InfectionManagerCapability.INSTANCE.orEmpty(cap, this.holder);
        }
        return LazyOptional.empty();
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("infectionProgression", this.infectionProgress);
        tag.m_128405_("infectionTimer", this.infectionTimer);
        tag.m_128347_("infectionResistance", this.resistance);
        tag.m_128379_("infectionFollower", this.follower);
        tag.m_128379_("infectionImpedement", this.resistantDosage);
        return tag;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.infectionProgress = nbt.m_128451_("infectionProgression");
        this.infectionTimer = nbt.m_128451_("infectionTimer");
        this.resistance = nbt.m_128457_("infectionResistance");
        this.follower = nbt.m_128471_("infectionFollower");
        this.resistantDosage = nbt.m_128471_("infectionImpedement");
    }
}

