/*
 * Decompiled with CFR 0.152.
 */
package cn.rainspace.lootbag;

import cn.rainspace.lootbag.block.ModBlocks;
import cn.rainspace.lootbag.config.Config;
import cn.rainspace.lootbag.gui.screen.BackpackChestScreen;
import cn.rainspace.lootbag.inventory.container.ModContainerType;
import cn.rainspace.lootbag.item.ModItems;
import cn.rainspace.lootbag.loot.ModLootTables;
import cn.rainspace.lootbag.tileentity.ModTileEntityType;
import java.util.Set;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.loot.LootTableManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lootbag")
public class LootBag {
    private static final Logger LOGGER = LogManager.getLogger();

    public LootBag() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModTileEntityType.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModContainerType.CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> ScreenManager.func_216911_a((ContainerType)((ContainerType)ModContainerType.BACKPACK_CHEST_CONTAINER.get()), BackpackChestScreen::new));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WorldEvents {
        @SubscribeEvent
        public static void onLoad(WorldEvent.Load event) {
            World world = (World)event.getWorld();
            if (world instanceof ServerWorld) {
                Set<ResourceLocation> lootTables = ModLootTables.all();
                LootTableManager manager = world.func_73046_m().func_200249_aQ();
                lootTables.forEach(e -> MinecraftForge.EVENT_BUS.post((Event)new LootTableLoadEvent(e, manager.func_186521_a(e), manager)));
            }
        }
    }
}

