/*
 * Decompiled with CFR 0.152.
 */
package cn.rainspace.lootbag;

import cn.rainspace.lootbag.block.ModBlocks;
import cn.rainspace.lootbag.block.entity.ModBlockEntityType;
import cn.rainspace.lootbag.config.Config;
import cn.rainspace.lootbag.gui.screen.BackpackChestScreen;
import cn.rainspace.lootbag.inventory.container.ModMenuType;
import cn.rainspace.lootbag.item.ModItems;
import cn.rainspace.lootbag.loot.ModLootTables;
import java.util.Set;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lootbag")
public class LootBag {
    private static final Logger LOGGER = LogManager.getLogger();

    public LootBag() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::doClientStuff);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModItems.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlocks.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModBlockEntityType.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModMenuType.CONTAINERS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)Config.SERVER_CONFIG);
    }

    private void doClientStuff(FMLClientSetupEvent event) {
        event.enqueueWork(() -> MenuScreens.m_96206_((MenuType)((MenuType)ModMenuType.BACKPACK_CHEST_CONTAINER.get()), BackpackChestScreen::new));
    }

    @Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
    public static class WorldEvents {
        @SubscribeEvent
        public static void onLoad(WorldEvent.Load event) {
            Level level = (Level)event.getWorld();
            if (level instanceof ServerLevel) {
                Set<ResourceLocation> lootTables = ModLootTables.all();
                LootTables manager = level.m_142572_().m_129898_();
                lootTables.forEach(e -> MinecraftForge.EVENT_BUS.post((Event)new LootTableLoadEvent(e, manager.m_79217_(e), manager)));
            }
        }
    }
}

