/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.capability;

import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.util.Utils;
import cofh.redstonearsenal.capability.CapabilityFluxShielding;
import cofh.redstonearsenal.capability.IFluxShieldedItem;
import cofh.redstonearsenal.util.FluxShieldingScheduler;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Direction;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;

public class FluxShieldedEnergyItemWrapper
extends EnergyContainerItemWrapper
implements IFluxShieldedItem {
    private final LazyOptional<IFluxShieldedItem> holder = LazyOptional.of(() -> this);
    protected final ItemStack shieldedItem;
    protected final int COOLDOWN = 600;
    protected int energyPerUse;
    protected long availableTime = -1L;

    public FluxShieldedEnergyItemWrapper(ItemStack shieldedItemContainer, int energyPerUse) {
        super(shieldedItemContainer, (IEnergyContainerItem)shieldedItemContainer.func_77973_b(), ((IEnergyContainerItem)shieldedItemContainer.func_77973_b()).getEnergyCapability());
        this.shieldedItem = shieldedItemContainer;
        this.energyPerUse = energyPerUse;
    }

    @Override
    public int currCharges(LivingEntity entity) {
        CompoundNBT nbt = this.shieldedItem.func_196082_o();
        if (this.energyPerUse > 0 && this.getEnergyStored() < this.energyPerUse) {
            return 0;
        }
        if (this.availableTime <= -1L) {
            if (!nbt.func_74764_b("FluxShield")) {
                this.availableTime = 0L;
                return 1;
            }
            this.availableTime = nbt.func_74763_f("FluxShield");
        }
        return entity.field_70170_p.func_82737_E() >= this.availableTime ? 1 : 0;
    }

    @Override
    public int maxCharges(LivingEntity entity) {
        return 1;
    }

    @Override
    public boolean useCharge(LivingEntity entity) {
        if (this.currCharges(entity) < 1 || this.energyPerUse > 0 && this.getEnergyStored() >= this.energyPerUse && this.extractEnergy(this.energyPerUse, Utils.isCreativePlayer((Entity)entity)) != this.energyPerUse) {
            return false;
        }
        this.availableTime = entity.field_70170_p.func_82737_E() + 600L;
        this.shieldedItem.func_196082_o().func_74772_a("FluxShield", this.availableTime);
        return true;
    }

    @Override
    public void scheduleUpdate(ServerPlayerEntity player, long currTime) {
        if (this.availableTime <= -1L) {
            CompoundNBT nbt = this.shieldedItem.func_196082_o();
            this.availableTime = !nbt.func_74764_b("FluxShield") ? 0L : nbt.func_74763_f("FluxShield");
        }
        if (this.availableTime > currTime) {
            FluxShieldingScheduler.scheduleUpdate(this.availableTime, player);
        }
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY) {
            return CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY.orEmpty(cap, this.holder);
        }
        return super.getCapability(cap, side);
    }
}

