/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.client.renderer;

import cofh.redstonearsenal.entity.ShockwaveEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockRendererDispatcher;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.container.PlayerContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class ShockwaveRenderer
extends EntityRenderer<ShockwaveEntity> {
    public static List<List<int[]>> offsetsByTick = ShockwaveRenderer.getOffsetsByTick(10);
    protected static final BlockRendererDispatcher blockRenderer = Minecraft.func_71410_x().func_175602_ab();
    protected static final List<RenderType> renderTypes = RenderType.func_228661_n_();

    public ShockwaveRenderer(EntityRendererManager manager) {
        super(manager);
    }

    public void render(ShockwaveEntity entity, float entityYaw, float partialTicks, MatrixStack matrixStack, IRenderTypeBuffer buffer, int packedLight) {
        BlockPos origin = entity.func_233580_cy_();
        World world = entity.field_70170_p;
        for (int i = Math.max(0, entity.field_70173_aa - 5); i <= entity.field_70173_aa && i < offsetsByTick.size(); ++i) {
            List<int[]> offsets = offsetsByTick.get(i);
            block1: for (int[] offset : offsets) {
                float ticks = (float)(entity.field_70173_aa - i) + partialTicks;
                double yOffset = 0.5 * (double)ticks * (1.2 - 0.3 * (double)ticks);
                for (int y = 1; y >= -1; --y) {
                    BlockPos pos = origin.func_177982_a(offset[0], y, offset[1]);
                    BlockState state = world.func_180495_p(pos);
                    if (state.isAir((IBlockReader)world, pos) || !state.func_215686_e((IBlockReader)world, pos) || state.getHarvestLevel() > 5 || !state.func_235785_r_((IBlockReader)world, pos) || state.hasTileEntity() || world.func_180495_p(pos.func_177984_a()).func_235785_r_((IBlockReader)world, pos.func_177984_a())) continue;
                    if (state.func_185901_i() != BlockRenderType.MODEL) continue block1;
                    matrixStack.func_227860_a_();
                    matrixStack.func_227861_a_(-0.5 + (double)offset[0], -0.5 + yOffset + (double)y, -0.5 + (double)offset[1]);
                    matrixStack.func_227862_a_(1.01f, 1.01f, 1.01f);
                    for (RenderType type : renderTypes) {
                        if (!RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                        ForgeHooksClient.setRenderLayer((RenderType)type);
                        blockRenderer.func_175019_b().renderModel((IBlockDisplayReader)world, blockRenderer.func_184389_a(state), state, pos.func_177972_a(Direction.UP), matrixStack, buffer.getBuffer(type), false, new Random(), state.func_209533_a(pos), OverlayTexture.field_229196_a_, (IModelData)EmptyModelData.INSTANCE);
                    }
                    matrixStack.func_227865_b_();
                    continue block1;
                }
            }
        }
        ForgeHooksClient.setRenderLayer(null);
        super.func_225623_a_((Entity)entity, entityYaw, partialTicks, matrixStack, buffer, packedLight);
    }

    public ResourceLocation getTextureLocation(ShockwaveEntity entity) {
        return PlayerContainer.field_226615_c_;
    }

    protected static List<List<int[]>> getOffsetsByTick(int maxTicks) {
        List<List<int[]>> ticks = IntStream.range(0, maxTicks).mapToObj(i -> new ArrayList()).collect(Collectors.toList());
        float max = (float)maxTicks * 1.0f;
        float max2 = max * max;
        for (int x = 0; x <= MathHelper.func_76123_f((float)max); ++x) {
            for (int z = 0; z <= x; ++z) {
                int index;
                int distSqr = x * x + z * z;
                if (!((float)distSqr < max2) || (index = Math.round(MathHelper.func_76129_c((float)distSqr) / 1.0f)) >= ticks.size()) continue;
                ShockwaveRenderer.addReflections(ticks.get(index), x, z);
            }
        }
        return ticks;
    }

    protected static void addReflections(List<int[]> list, int x, int z) {
        list.add(new int[]{x, z});
        list.add(new int[]{-x, -z});
        if (z != 0) {
            list.add(new int[]{-x, z});
            list.add(new int[]{x, -z});
        }
        if (x != 0 && x != z) {
            list.add(new int[]{z, x});
            list.add(new int[]{-z, -x});
            if (z != 0) {
                list.add(new int[]{-z, x});
                list.add(new int[]{z, -x});
            }
        }
    }
}

