/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.redstonearsenal.init.RSAReferences;
import cofh.redstonearsenal.item.IFluxItem;
import com.google.common.collect.Lists;
import it.unimi.dsi.fastutil.ints.IntOpenHashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SChangeGameStatePacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluxArrowEntity
extends AbstractArrowEntity {
    protected static final DataParameter<Byte> RSA_FLAGS = EntityDataManager.func_187226_a(FluxArrowEntity.class, (IDataSerializer)DataSerializers.field_187191_a);
    protected static final int LIFESPAN = 100;
    protected static final float EXPLOSION_RANGE = 4.0f;

    public FluxArrowEntity(EntityType<? extends FluxArrowEntity> entityIn, World worldIn) {
        super(entityIn, worldIn);
    }

    public FluxArrowEntity(World worldIn, LivingEntity shooter) {
        super(RSAReferences.FLUX_ARROW_ENTITY, shooter, worldIn);
    }

    public FluxArrowEntity(World worldIn, double x, double y, double z) {
        super(RSAReferences.FLUX_ARROW_ENTITY, x, y, z, worldIn);
    }

    protected ItemStack func_184550_j() {
        return ItemStack.field_190927_a;
    }

    public void setExplodeArrow(boolean explode) {
        this.setRSAFlag(1, explode);
    }

    public boolean isExplodeArrow() {
        return ((Byte)this.field_70180_af.func_187225_a(RSA_FLAGS) & 1) != 0;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(RSA_FLAGS, (Object)0);
    }

    private void setRSAFlag(int flag, boolean value) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(RSA_FLAGS);
        if (value) {
            this.field_70180_af.func_187227_b(RSA_FLAGS, (Object)((byte)(b0 | flag)));
        } else {
            this.field_70180_af.func_187227_b(RSA_FLAGS, (Object)((byte)(b0 & ~flag)));
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public DamageSource getDamageSource(AbstractArrowEntity arrow, @Nullable Entity shooter) {
        return IFluxItem.fluxRangedDamage((ProjectileEntity)arrow, (Entity)(shooter == null ? arrow : shooter));
    }

    public void explode(Vector3d pos) {
        if (!this.field_70170_p.func_201670_d()) {
            ((ServerWorld)this.field_70170_p).func_195598_a((IParticleData)ParticleTypes.field_197627_t, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
            this.field_70170_p.func_184148_a(null, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187539_bB, SoundCategory.BLOCKS, 0.5f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
            double r2 = 16.0;
            AxisAlignedBB searchArea = this.func_174813_aQ().func_191194_a(pos.func_178788_d(this.func_213303_ch())).func_186662_g(4.0);
            Predicate<Entity> filter = EntityPredicates.field_188444_d.and(entity -> entity instanceof LivingEntity);
            for (Entity target : this.field_70170_p.func_175674_a((Entity)this, searchArea, filter)) {
                if (!(pos.func_72436_e(target.func_174813_aQ().func_189972_c()) < r2)) continue;
                target.func_70097_a(this.getDamageSource(this, this.func_234616_v_()), (float)this.func_70242_d());
            }
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.func_201670_d() && this.field_70173_aa > 100) {
            this.func_70106_y();
        } else {
            super.func_70071_h_();
        }
    }

    public float getGravity() {
        return this.func_189652_ae() || this.field_70145_X ? 0.0f : 0.05f;
    }

    public byte func_213874_s() {
        return this.isExplodeArrow() ? (byte)0 : super.func_213874_s();
    }

    protected float func_203044_p() {
        return 0.99f;
    }

    protected void func_70227_a(RayTraceResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.func_216347_e());
        } else {
            RayTraceResult.Type type = result.func_216346_c();
            if (type == RayTraceResult.Type.ENTITY) {
                this.func_213868_a((EntityRayTraceResult)result);
            } else if (type == RayTraceResult.Type.BLOCK) {
                this.func_230299_a_((BlockRayTraceResult)result);
            }
        }
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity target = result.func_216348_a();
        float speed = (float)this.func_213322_ci().func_72433_c();
        int dmg = MathHelper.func_76143_f((double)MathHelper.func_151237_a((double)((double)speed * this.field_70255_ao), (double)0.0, (double)2.147483647E9));
        if (this.func_213874_s() > 0) {
            if (this.field_213878_az == null) {
                this.field_213878_az = new IntOpenHashSet(5);
            }
            if (this.field_213875_aA == null) {
                this.field_213875_aA = Lists.newArrayListWithCapacity((int)5);
            }
            if (this.field_213878_az.size() >= this.func_213874_s() + 1) {
                this.func_70106_y();
                return;
            }
            this.field_213878_az.add(target.func_145782_y());
        }
        if (this.func_70241_g()) {
            dmg = Math.min(this.field_70146_Z.nextInt(dmg / 2 + 2) + dmg, Integer.MAX_VALUE);
        }
        Entity owner = this.func_234616_v_();
        DamageSource dmgSource = this.getDamageSource(this, owner);
        if (owner instanceof LivingEntity) {
            ((LivingEntity)owner).func_130011_c(target);
        }
        boolean canHurt = this.canHurtEntity(target);
        if (target.func_70097_a(dmgSource, (float)dmg)) {
            if (!canHurt) {
                return;
            }
            if (target instanceof LivingEntity) {
                Vector3d vector3d;
                LivingEntity living = (LivingEntity)target;
                if (this.field_70256_ap > 0 && (vector3d = this.func_213322_ci().func_216372_d(1.0, 0.0, 1.0).func_72432_b().func_186678_a((double)this.field_70256_ap * 0.6)).func_189985_c() > 0.0) {
                    living.func_70024_g(vector3d.field_72450_a, 0.1, vector3d.field_72449_c);
                }
                if (!this.field_70170_p.field_72995_K && owner instanceof LivingEntity) {
                    EnchantmentHelper.func_151384_a((LivingEntity)living, (Entity)owner);
                    EnchantmentHelper.func_151385_b((LivingEntity)((LivingEntity)owner), (Entity)living);
                }
                this.func_184548_a(living);
                if (living != owner && living instanceof PlayerEntity && owner instanceof ServerPlayerEntity && !this.func_174814_R()) {
                    ((ServerPlayerEntity)owner).field_71135_a.func_147359_a((IPacket)new SChangeGameStatePacket(SChangeGameStatePacket.field_241770_g_, 0.0f));
                }
                if (!target.func_70089_S() && this.field_213875_aA != null) {
                    this.field_213875_aA.add(living);
                }
                if (!this.field_70170_p.field_72995_K && owner instanceof ServerPlayerEntity) {
                    ServerPlayerEntity serverplayerentity = (ServerPlayerEntity)owner;
                    if (this.field_213875_aA != null && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, (Collection)this.field_213875_aA);
                    } else if (!target.func_70089_S() && this.func_213873_r()) {
                        CriteriaTriggers.field_215100_G.func_234941_a_(serverplayerentity, Arrays.asList(target));
                    }
                }
            }
            this.func_184185_a(this.func_213867_k(), 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            if (this.func_213874_s() <= 0) {
                this.func_70106_y();
            }
        } else {
            this.func_213317_d(this.func_213322_ci().func_186678_a(-0.1));
            this.field_70177_z += 180.0f;
            this.field_70126_B += 180.0f;
            if (!this.field_70170_p.field_72995_K && this.func_213322_ci().func_189985_c() < 1.0E-7) {
                this.func_70106_y();
            }
        }
    }

    protected boolean canHurtEntity(Entity entity) {
        return entity.func_200600_R() != EntityType.field_200803_q;
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        if (this.isExplodeArrow()) {
            this.explode(result.func_216347_e());
            return;
        }
        this.field_70170_p.func_72960_a((Entity)this, (byte)3);
        this.func_70106_y();
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        nbt.func_74757_a("explode", this.isExplodeArrow());
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        this.setExplodeArrow(nbt.func_74767_n("explode"));
    }
}

