/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.lib.util.helpers.ArcheryHelper;
import cofh.redstonearsenal.init.RSAReferences;
import cofh.redstonearsenal.item.IFluxItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.network.IPacket;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluxSlashEntity
extends ProjectileEntity {
    public static float defaultSpeed = 2.0f;
    public float damage = 2.0f;
    public int duration = 5;
    public final float zRot;

    public FluxSlashEntity(EntityType<? extends ProjectileEntity> type, World worldIn) {
        super(type, worldIn);
        this.zRot = (worldIn.func_201674_k().nextFloat() - 0.5f) * 50.0f;
    }

    public FluxSlashEntity(World worldIn, double x, double y, double z) {
        this(RSAReferences.FLUX_SLASH_ENTITY, worldIn);
        this.func_70107_b(x, y, z);
    }

    public FluxSlashEntity(World worldIn, LivingEntity livingEntityIn) {
        this(worldIn, livingEntityIn.func_226277_ct_(), 0.7 * livingEntityIn.func_226280_cw_() + 0.3 * livingEntityIn.func_226278_cu_(), livingEntityIn.func_226281_cx_());
        this.func_212361_a((Entity)livingEntityIn);
        this.func_234612_a_((Entity)livingEntityIn, livingEntityIn.field_70125_A, livingEntityIn.field_70177_z, 0.0f, defaultSpeed, 0.5f);
    }

    public FluxSlashEntity(World worldIn, LivingEntity livingEntityIn, int damageModifier) {
        this(worldIn, livingEntityIn);
        this.damage += (float)damageModifier;
    }

    public FluxSlashEntity(World worldIn, LivingEntity livingEntityIn, int damageModifier, int durationModifier) {
        this(worldIn, livingEntityIn, damageModifier);
        this.duration += durationModifier;
    }

    protected void func_70088_a() {
    }

    protected void func_71061_d_() {
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        super.func_213868_a(result);
        result.func_216348_a().func_70097_a(IFluxItem.fluxRangedDamage(this, this.func_234616_v_()), this.damage);
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        super.func_230299_a_(result);
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70173_aa > this.duration) {
            this.func_70106_y();
        }
        this.calculateCollision(this.field_70170_p);
        this.func_145775_I();
        Vector3d velocity = this.func_213322_ci();
        this.func_70107_b(this.func_226277_ct_() + velocity.field_72450_a, this.func_226278_cu_() + velocity.field_72448_b, this.func_226281_cx_() + velocity.field_72449_c);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_70112_a(double p_70112_1_) {
        double d0 = this.func_174813_aQ().func_72320_b() * 10.0;
        if (Double.isNaN(d0)) {
            d0 = 1.0;
        }
        return p_70112_1_ < (d0 = d0 * 64.0 * FluxSlashEntity.func_184183_bd()) * d0;
    }

    protected void calculateCollision(World world) {
        Vector3d start = this.func_213303_ch();
        Vector3d end = start.func_178787_e(this.func_213322_ci());
        BlockRayTraceResult blockResult = this.getBlockHitResult(world, start, end);
        boolean blockCollision = false;
        if (blockResult.func_216346_c() != RayTraceResult.Type.MISS) {
            end = blockResult.func_216347_e();
            blockCollision = true;
        }
        this.hitEntities(this.field_70170_p, start, end);
        if (blockCollision && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)blockResult)) {
            this.func_230299_a_(blockResult);
        }
    }

    protected BlockRayTraceResult getBlockHitResult(World world, Vector3d startPos, Vector3d endPos) {
        return world.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
    }

    protected void hitEntities(World world, Vector3d startPos, Vector3d endPos) {
        ArcheryHelper.findHitEntities((World)world, (ProjectileEntity)this, (Vector3d)startPos, (Vector3d)endPos, arg_0 -> ((FluxSlashEntity)this).func_230298_a_(arg_0)).filter(result -> !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)).forEach(this::func_213868_a);
    }
}

