/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.redstonearsenal.RedstoneArsenal;
import cofh.redstonearsenal.init.RSAReferences;
import cofh.redstonearsenal.item.FluxWrenchItem;
import cofh.redstonearsenal.item.IFluxItem;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.CreatureAttribute;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ProjectileEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.tileentity.EndGatewayTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.network.NetworkHooks;

public class FluxWrenchEntity
extends ProjectileEntity {
    protected static final DataParameter<ItemStack> DATA_ITEM_STACK = EntityDataManager.func_187226_a(FluxWrenchEntity.class, (IDataSerializer)DataSerializers.field_187196_f);
    public float speed = 1.3f;
    public float range = 16.0f;
    public boolean hitSomething = false;

    public FluxWrenchEntity(EntityType<? extends ProjectileEntity> type, World worldIn) {
        super(type, worldIn);
    }

    public FluxWrenchEntity(World worldIn, double x, double y, double z) {
        this(RSAReferences.FLUX_WRENCH_ENTITY, worldIn);
        this.func_70107_b(x, y, z);
    }

    public FluxWrenchEntity(World worldIn, LivingEntity livingEntityIn, ItemStack stackIn) {
        this(worldIn, livingEntityIn.func_226277_ct_(), livingEntityIn.func_226280_cw_() - (double)0.1f, livingEntityIn.func_226281_cx_());
        this.func_212361_a((Entity)livingEntityIn);
        this.setItem(stackIn);
        this.func_234612_a_((Entity)livingEntityIn, livingEntityIn.field_70125_A, livingEntityIn.field_70177_z, 0.0f, this.speed, 0.5f);
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(DATA_ITEM_STACK, (Object)new ItemStack((IItemProvider)this.getDefaultItem()));
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    protected Item getDefaultItem() {
        return ((Item)RedstoneArsenal.ITEMS.get("flux_wrench")).getItem();
    }

    protected ItemStack getItemRaw() {
        return (ItemStack)this.func_184212_Q().func_187225_a(DATA_ITEM_STACK);
    }

    public ItemStack getItem() {
        ItemStack itemstack = this.getItemRaw();
        return itemstack.func_190926_b() ? new ItemStack((IItemProvider)this.getDefaultItem()) : itemstack;
    }

    public void setItem(ItemStack stack) {
        if (stack.func_77973_b() != this.getDefaultItem() || stack.func_77942_o()) {
            this.func_184212_Q().func_187227_b(DATA_ITEM_STACK, Util.func_200696_a((Object)stack.func_77946_l(), itemStack -> itemStack.func_190920_e(1)));
        }
    }

    public boolean isEmpowered() {
        ItemStack stack = this.getItem();
        return ((FluxWrenchItem)stack.func_77973_b()).isEmpowered(stack);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.calculateCollision(this.field_70170_p);
        this.func_145775_I();
        if (!this.func_70089_S()) {
            return;
        }
        Vector3d velocity = this.func_213322_ci();
        Entity owner = this.func_234616_v_();
        if (owner != null) {
            Vector3d relPos = owner.func_174824_e(0.0f).func_178788_d(this.func_213303_ch());
            double distance = relPos.func_72433_c();
            if (distance > (double)this.range) {
                this.hitSomething = true;
            }
            if (this.hitSomething) {
                if (distance < 1.5) {
                    this.returnToInventory();
                } else {
                    this.func_213317_d(relPos.func_186678_a((double)this.speed / distance));
                }
            }
        }
        if (this.func_70090_H()) {
            for (int i = 0; i < 4; ++i) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197612_e, this.func_226277_ct_() + velocity.field_72450_a * 0.75, this.func_226278_cu_() + velocity.field_72448_b * 0.75, this.func_226281_cx_() + velocity.field_72449_c * 0.75, velocity.field_72450_a, velocity.field_72448_b, velocity.field_72449_c);
            }
        }
        this.func_70107_b(this.func_226277_ct_() + velocity.field_72450_a, this.func_226278_cu_() + velocity.field_72448_b, this.func_226281_cx_() + velocity.field_72449_c);
    }

    public void calculateCollision(World world) {
        Vector3d start = this.func_213303_ch();
        Vector3d end = start.func_178787_e(this.func_213322_ci());
        BlockRayTraceResult blockResult = this.getBlockHitResult(world, start, end);
        boolean blockCollision = false;
        if (blockResult.func_216346_c() != RayTraceResult.Type.MISS) {
            end = blockResult.func_216347_e();
            BlockPos blockpos = blockResult.func_216350_a();
            BlockState blockstate = world.func_180495_p(blockpos);
            if (blockstate.func_203425_a(Blocks.field_150427_aO)) {
                this.func_181015_d(blockpos);
            } else if (blockstate.func_203425_a(Blocks.field_185775_db)) {
                TileEntity tileentity = world.func_175625_s(blockpos);
                if (tileentity instanceof EndGatewayTileEntity && EndGatewayTileEntity.func_242690_a((Entity)this)) {
                    ((EndGatewayTileEntity)tileentity).func_195496_a((Entity)this);
                }
            } else {
                blockCollision = true;
            }
        }
        this.hitEntities(this.field_70170_p, start, end);
        if (blockCollision && !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)blockResult)) {
            this.func_230299_a_(blockResult);
        }
    }

    public BlockRayTraceResult getBlockHitResult(World world, Vector3d startPos, Vector3d endPos) {
        return world.func_217299_a(new RayTraceContext(startPos, endPos, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, (Entity)this));
    }

    public void hitEntities(World world, Vector3d startPos, Vector3d endPos) {
        ArcheryHelper.findHitEntities((World)world, (ProjectileEntity)this, (Vector3d)startPos, (Vector3d)endPos, arg_0 -> ((FluxWrenchEntity)this).func_230298_a_(arg_0)).filter(result -> !ForgeEventFactory.onProjectileImpact((Entity)this, (RayTraceResult)result)).forEach(this::func_213868_a);
    }

    protected void func_70227_a(RayTraceResult result) {
        if (!this.hitSomething) {
            Entity owner = this.func_234616_v_();
            if (owner != null) {
                Vector3d relPos = owner.func_174824_e(1.0f).func_178788_d(this.func_213303_ch());
                double distance = relPos.func_72433_c();
                if (distance < 1.5) {
                    this.returnToInventory();
                } else {
                    this.func_213317_d(relPos.func_186678_a((double)this.speed * 0.5 / distance));
                }
            } else {
                this.func_213317_d(this.func_213322_ci().func_186678_a(-0.5));
            }
            this.hitSomething = true;
        }
    }

    protected void returnToInventory() {
        Entity owner = this.func_234616_v_();
        if (owner == null) {
            return;
        }
        if (!(owner instanceof PlayerEntity) || !((PlayerEntity)owner).field_71071_by.func_70441_a(this.getItem())) {
            this.field_70170_p.func_217376_c((Entity)new ItemEntity(this.field_70170_p, owner.func_226277_ct_(), owner.func_226278_cu_(), owner.func_226281_cx_(), this.getItem()));
        }
        this.func_70106_y();
    }

    protected void func_213868_a(EntityRayTraceResult result) {
        Entity owner;
        if (!this.func_70089_S() || this.field_70170_p.func_201670_d()) {
            return;
        }
        Entity target = result.func_216348_a();
        if (target.equals((Object)(owner = this.func_234616_v_()))) {
            this.returnToInventory();
        } else if (result.func_216348_a().func_70097_a(IFluxItem.fluxRangedDamage(this, owner), this.calculateDamage(target)) && target.func_200600_R() != EntityType.field_200803_q) {
            int fireAspect = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_77334_n, (ItemStack)this.getItem());
            if (this.func_70027_ad() || fireAspect > 0) {
                target.func_70015_d(Math.max(this.func_70027_ad() ? 5 : 0, fireAspect * 4));
            }
        }
        this.func_70227_a((RayTraceResult)result);
    }

    protected float calculateDamage(Entity target) {
        ItemStack stack = this.getItem();
        Entity owner = this.func_234616_v_();
        float damage = ((FluxWrenchItem)stack.func_77973_b()).getRangedAttackDamage(stack);
        if (target instanceof LivingEntity) {
            damage += EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)((LivingEntity)target).func_70668_bt());
            if (owner instanceof LivingEntity) {
                stack.func_77973_b().func_77644_a(stack, (LivingEntity)target, (LivingEntity)owner);
            }
        } else {
            damage += EnchantmentHelper.func_152377_a((ItemStack)stack, (CreatureAttribute)CreatureAttribute.field_223222_a_);
        }
        return damage;
    }

    protected void func_230299_a_(BlockRayTraceResult result) {
        if (!this.func_70089_S() || this.field_70170_p.func_201670_d()) {
            return;
        }
        BlockState state = this.field_70170_p.func_180495_p(result.func_216350_a());
        state.func_215690_a(this.field_70170_p, state, result, (ProjectileEntity)this);
        Entity owner = this.func_234616_v_();
        ItemStack stack = this.getItem();
        if (owner instanceof PlayerEntity && stack.func_77973_b() instanceof FluxWrenchItem) {
            ((FluxWrenchItem)stack.func_77973_b()).useRanged(this.field_70170_p, stack, (PlayerEntity)owner, result);
        }
        this.func_70227_a((RayTraceResult)result);
    }

    public void func_70037_a(CompoundNBT nbt) {
        super.func_70037_a(nbt);
        ItemStack itemstack = ItemStack.func_199557_a((CompoundNBT)nbt.func_74775_l("item"));
        this.setItem(itemstack);
        this.hitSomething = nbt.func_74767_n("hit");
    }

    public void func_213281_b(CompoundNBT nbt) {
        super.func_213281_b(nbt);
        ItemStack itemstack = this.getItemRaw();
        if (!itemstack.func_190926_b()) {
            nbt.func_218657_a("item", (INBT)itemstack.func_77955_b(new CompoundNBT()));
        }
        nbt.func_74757_a("hit", this.hitSomething);
    }
}

