/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.entity;

import cofh.lib.util.references.CoreReferences;
import cofh.redstonearsenal.init.RSAReferences;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityPredicates;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.network.NetworkHooks;

public class ShockwaveEntity
extends Entity {
    public static final float defaultSpeed = 1.0f;
    public static final int duration = 10;
    public static final int animDuration = 5;
    public float damage = 8.0f;
    public int debuffDuration = 100;
    protected LivingEntity owner = null;

    public ShockwaveEntity(EntityType<?> type, World world) {
        super(type, world);
    }

    public ShockwaveEntity(World world, LivingEntity attacker, Vector3d pos, float yRot) {
        this(RSAReferences.SHOCKWAVE_ENTITY, world);
        this.owner = attacker;
        this.func_70107_b(pos.func_82615_a(), pos.func_82617_b(), pos.func_82616_c());
        this.func_70101_b(yRot, 0.0f);
    }

    public ShockwaveEntity(World world, LivingEntity attacker, Vector3d pos, float yRot, int damageModifier) {
        this(world, attacker, pos, yRot);
        this.damage += (float)damageModifier;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT nbt) {
    }

    protected void func_213281_b(CompoundNBT nbt) {
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.func_201670_d()) {
            if (this.field_70173_aa > 15) {
                this.func_70106_y();
            } else if (this.field_70173_aa < 10 && this.attack()) {
                this.owner.func_195064_c(new EffectInstance(Effects.field_76420_g, 70, 0));
            }
        }
        super.func_70071_h_();
    }

    public boolean attack() {
        boolean hitSomething = false;
        float lower = Math.max((float)(this.field_70173_aa - 1) * 1.0f, 0.0f);
        float upper = lower + 1.5f;
        float lowerSqr = lower * lower;
        float upperSqr = upper * upper;
        for (LivingEntity entity : this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_72314_b((double)(upper + 1.0f), 2.0, (double)(upper + 1.0f)).func_186662_g(0.5), EntityPredicates.field_188444_d)) {
            float falloff;
            DamageSource source;
            Vector3d relPos;
            double distSqr;
            if (entity.equals((Object)this.owner) || !((double)lowerSqr < (distSqr = (relPos = new Vector3d(entity.func_226277_ct_() - this.func_226277_ct_(), 0.0, entity.func_226281_cx_() - this.func_226281_cx_())).func_189985_c())) || !(distSqr < (double)upperSqr) || !entity.func_70097_a(source = this.owner instanceof PlayerEntity ? DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)this.owner)) : DamageSource.func_76358_a((LivingEntity)this.owner), this.damage * (falloff = (10.0f - (float)this.field_70173_aa * 0.5f) / 10.0f))) continue;
            hitSomething = true;
            entity.func_195064_c(new EffectInstance(CoreReferences.SUNDERED, this.debuffDuration, 0, false, false));
            entity.func_233627_a_(0.8f, -relPos.func_82615_a(), -relPos.func_82616_c());
        }
        return hitSomething;
    }
}

