/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.event;

import cofh.core.event.ShieldEvents;
import cofh.lib.capability.CapabilityShieldItem;
import cofh.lib.util.Utils;
import cofh.redstonearsenal.capability.CapabilityFluxShielding;
import cofh.redstonearsenal.init.RSAReferences;
import cofh.redstonearsenal.item.FluxAxeItem;
import cofh.redstonearsenal.item.FluxCrossbowItem;
import cofh.redstonearsenal.item.FluxShieldItem;
import cofh.redstonearsenal.item.FluxShovelItem;
import cofh.redstonearsenal.item.FluxTridentItem;
import cofh.redstonearsenal.util.FluxShieldingHelper;
import cofh.redstonearsenal.util.FluxShieldingScheduler;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraftforge.common.Tags;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEquipmentChangeEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.CriticalHitEvent;
import net.minecraftforge.event.entity.player.PlayerFlyableFallEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="redstone_arsenal")
public class RSAEvents {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleAttackEntityEvent(AttackEntityEvent event) {
        FluxTridentItem trident;
        if (event.isCanceled()) {
            return;
        }
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof FluxTridentItem && player.func_204805_cN() && (trident = (FluxTridentItem)stack.func_77973_b()).plungeAttack(player.field_70170_p, (LivingEntity)player, stack)) {
            FluxTridentItem.stopSpinAttack((LivingEntity)player);
            player.func_195064_c(new EffectInstance(Effects.field_204839_B, 35));
            player.field_70143_R = 0.0f;
            event.getTarget().field_70172_ad = 0;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handleLivingFallEvent(LivingFallEvent event) {
        LivingEntity living = event.getEntityLiving();
        ItemStack stack = living.func_184614_ca();
        if (stack.func_77973_b() instanceof FluxTridentItem && living.func_204805_cN()) {
            FluxTridentItem trident = (FluxTridentItem)stack.func_77973_b();
            if (trident.plungeAttack(living.field_70170_p, living, stack)) {
                FluxTridentItem.stopSpinAttack(living);
                if (event.isCancelable()) {
                    event.setCanceled(true);
                }
            } else {
                event.setDamageMultiplier(0.4f);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    public static void handlePlayerFlyableFallEvent(PlayerFlyableFallEvent event) {
        FluxTridentItem trident;
        PlayerEntity player = event.getPlayer();
        ItemStack stack = player.func_184614_ca();
        if (stack.func_77973_b() instanceof FluxTridentItem && player.func_204805_cN() && (trident = (FluxTridentItem)stack.func_77973_b()).plungeAttack(player.field_70170_p, (LivingEntity)player, stack)) {
            FluxTridentItem.stopSpinAttack((LivingEntity)player);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleCriticalHitEvent(CriticalHitEvent event) {
        if (event.isCanceled() || !event.isVanillaCritical()) {
            return;
        }
        ItemStack stack = event.getPlayer().func_184614_ca();
        if (stack.func_77973_b() instanceof FluxAxeItem) {
            ((FluxAxeItem)stack.func_77973_b()).handleCritHit(stack, event);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingEquipmentChangeEvent(LivingEquipmentChangeEvent event) {
        ItemStack from = event.getFrom();
        ItemStack to = event.getTo();
        LivingEntity entity = event.getEntityLiving();
        if (entity instanceof ServerPlayerEntity && !FluxShieldingHelper.equalCharges(entity, from, to)) {
            FluxShieldingScheduler.updateHUD((ServerPlayerEntity)entity);
            to.getCapability(CapabilityFluxShielding.FLUX_SHIELDED_ITEM_CAPABILITY).ifPresent(cap -> cap.scheduleUpdate((ServerPlayerEntity)entity));
        }
        if (from.func_77973_b() instanceof FluxCrossbowItem) {
            EquipmentSlotType slot = event.getSlot();
            if (!(!slot.equals((Object)EquipmentSlotType.MAINHAND) && (!slot.equals((Object)EquipmentSlotType.OFFHAND) || entity.func_184614_ca().func_190926_b()) || to.func_77973_b() instanceof FluxCrossbowItem && to.func_77986_q().equals((Object)from.func_77986_q()) && from.func_82838_A() == to.func_82838_A())) {
                ((FluxCrossbowItem)from.func_77973_b()).startCooldown(entity, from);
            }
        } else if (event.getSlot().equals((Object)EquipmentSlotType.MAINHAND) && entity.func_204805_cN() && from.func_77973_b() instanceof FluxTridentItem && !(to.func_77973_b() instanceof FluxTridentItem)) {
            FluxTridentItem.stopSpinAttack(entity);
        }
    }

    @SubscribeEvent
    public static void handleBlockToolInteractEvent(BlockEvent.BlockToolInteractEvent event) {
        if (event.isCanceled()) {
            return;
        }
        ItemStack stack = event.getHeldItemStack();
        BlockState state = event.getState();
        if (stack.func_77973_b() instanceof FluxShovelItem) {
            FluxShovelItem shovel = (FluxShovelItem)stack.func_77973_b();
            if (state.func_203425_a(Blocks.field_185774_da) || state.func_203425_a(RSAReferences.FLUX_PATH) || state.func_203425_a(Blocks.field_150458_ak)) {
                event.setFinalState(Blocks.field_150346_d.func_176223_P());
            } else if (shovel.isEmpowered(stack)) {
                if (state.func_235714_a_((ITag)Tags.Blocks.DIRT)) {
                    event.setFinalState(RSAReferences.FLUX_PATH.func_176223_P());
                }
            } else if (state.func_203425_a(Blocks.field_150346_d)) {
                event.setFinalState(Blocks.field_185774_da.func_176223_P());
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingAttackEvent(LivingAttackEvent event) {
        ItemStack shield;
        LivingEntity target = event.getEntityLiving();
        DamageSource source = event.getSource();
        if (event.isCanceled() || ShieldEvents.canBlockDamageSource((LivingEntity)target, (DamageSource)source)) {
            return;
        }
        if (target.func_184585_cz() && source.func_76355_l().equals("flux") && (shield = target.func_184607_cu()).func_77973_b() instanceof FluxShieldItem && ShieldEvents.canBlockDamagePosition((LivingEntity)target, (Vector3d)source.func_188404_v())) {
            shield.getCapability(CapabilityShieldItem.SHIELD_ITEM_CAPABILITY).ifPresent(cap -> cap.onBlock(target, source, event.getAmount()));
            event.setCanceled(true);
            return;
        }
        if (event.getAmount() > 500.0f || Utils.isCreativePlayer((Entity)target)) {
            return;
        }
        ItemStack shieldedItem = FluxShieldingHelper.findShieldedItem(target);
        if (shieldedItem.func_190926_b()) {
            return;
        }
        if (target.field_70172_ad > 0) {
            event.setCanceled(true);
        } else if (FluxShieldingHelper.useFluxShieldCharge(target, shieldedItem)) {
            target.field_70172_ad = 10;
            event.setCanceled(true);
            if (target instanceof ServerPlayerEntity) {
                FluxShieldingScheduler.updateHUD((ServerPlayerEntity)target);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public static void handleLivingHurtEvent(LivingHurtEvent event) {
        if (event.isCanceled()) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        float amount = event.getAmount();
        if (amount > 0.0f && FluxShieldingHelper.useFluxShieldCharge(target)) {
            event.setAmount(Math.max(amount - 500.0f, 0.0f));
            if (target instanceof ServerPlayerEntity) {
                FluxShieldingScheduler.updateHUD((ServerPlayerEntity)target);
            }
        }
    }

    @SubscribeEvent
    public static void handleEntityJoinWorldEvent(EntityJoinWorldEvent event) {
        Entity entity = event.getEntity();
        if (entity instanceof ServerPlayerEntity) {
            FluxShieldingScheduler.loadSchedule(event.getWorld().func_82737_E(), (ServerPlayerEntity)entity);
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.WorldTickEvent event) {
        if (event.phase == TickEvent.Phase.END && event.side.isServer()) {
            FluxShieldingScheduler.handleSchedule(event.world.func_82737_E());
        }
    }
}

