/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.init;

import cofh.redstonearsenal.util.RSAEnergyHelper;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;

public class RSAConfig {
    private static boolean registered = false;
    private static final ForgeConfigSpec.Builder SERVER_CONFIG = new ForgeConfigSpec.Builder();
    private static ForgeConfigSpec serverSpec;
    private static final ForgeConfigSpec.Builder CLIENT_CONFIG;
    private static ForgeConfigSpec clientSpec;
    public static ForgeConfigSpec.BooleanValue standaloneRedstoneFlux;

    public static void register() {
        if (registered) {
            return;
        }
        FMLJavaModLoadingContext.get().getModEventBus().register(RSAConfig.class);
        registered = true;
        RSAConfig.genServerConfig();
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, serverSpec);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, clientSpec);
    }

    private RSAConfig() {
    }

    private static void genServerConfig() {
        standaloneRedstoneFlux = SERVER_CONFIG.comment("If TRUE, Redstone Flux will act as its own energy system and will NOT be interoperable with 'Forge Energy' - only enable this if you absolutely know what you are doing and want Redstone Arsenal to use a unique energy system.").define("Standalone Redstone Flux", false);
        serverSpec = SERVER_CONFIG.build();
        RSAConfig.refreshServerConfig();
    }

    private static void refreshServerConfig() {
        RSAEnergyHelper.standaloneRedstoneFlux = (Boolean)standaloneRedstoneFlux.get();
    }

    private static void refreshClientConfig() {
    }

    @SubscribeEvent
    public static void configLoading(ModConfig.Loading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                RSAConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                RSAConfig.refreshServerConfig();
            }
        }
    }

    @SubscribeEvent
    public static void configReloading(ModConfig.Reloading event) {
        switch (event.getConfig().getType()) {
            case CLIENT: {
                RSAConfig.refreshClientConfig();
                break;
            }
            case SERVER: {
                RSAConfig.refreshServerConfig();
            }
        }
    }

    static {
        CLIENT_CONFIG = new ForgeConfigSpec.Builder();
    }
}

