/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.item.ArmorItemCoFH;
import cofh.core.util.ProxyUtils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.capability.FluxShieldedEnergyItemWrapper;
import cofh.redstonearsenal.item.IFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxArmorItem
extends ArmorItemCoFH
implements IFluxItem {
    protected int maxEnergy;
    protected int extract;
    protected int receive;

    public FluxArmorItem(IArmorMaterial material, EquipmentSlotType slot, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(material, slot, builder);
        this.maxEnergy = maxEnergy;
        this.extract = maxTransfer;
        this.receive = maxTransfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxShieldedEnergyItemWrapper(stack, this.getEnergyPerUse(true));
    }

    public boolean isDamageable(ItemStack stack) {
        return this.hasEnergy(stack, false);
    }

    public boolean isDamaged(ItemStack stack) {
        return false;
    }

    public void setDamage(ItemStack stack, int damage) {
        this.setEnergyStored(stack, this.getMaxEnergyStored(stack) - this.getEnergyPerUse(false) * damage);
    }

    public int getDamage(ItemStack stack) {
        return (this.getMaxEnergyStored(stack) - this.getEnergyStored(stack)) / this.getEnergyPerUse(false);
    }

    public int getMaxDamage(ItemStack stack) {
        return this.getMaxEnergyStored(stack) / this.getEnergyPerUse(false);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

