/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.impl.AxeItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IFluxItem;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.entity.player.CriticalHitEvent;

public class FluxAxeItem
extends AxeItemCoFH
implements IMultiModeFluxItem {
    protected float empoweredCritMod = 2.0f;
    protected final float damage = this.func_234675_d_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxAxeItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.field_77864_a : 1.0f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) ? this.getEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public void handleCritHit(ItemStack stack, CriticalHitEvent event) {
        PlayerEntity player = event.getPlayer();
        if (this.isEmpowered(stack) && this.useEnergy(stack, true, player.field_71075_bZ.field_75098_d)) {
            event.getTarget().func_70097_a(IFluxItem.fluxDirectDamage((LivingEntity)player), (event.getDamageModifier() - 1.0f) * this.empoweredCritMod * (this.getAttackDamage(stack) + 1.0f));
            event.setDamageModifier(1.0f);
            event.getTarget().field_70172_ad = 0;
        }
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

