/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityArchery;
import cofh.lib.capability.IArcheryAmmoItem;
import cofh.lib.capability.IArcheryBowItem;
import cofh.lib.capability.templates.ArcheryAmmoItemWrapper;
import cofh.lib.capability.templates.ArcheryBowItemWrapper;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.impl.BowItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.helpers.MathHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.references.EnsorcReferences;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.AbstractArrowEntity;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxBowItem
extends BowItemCoFH
implements IMultiModeFluxItem {
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxBowItem(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.setParams(enchantability, accuracyModifier, damageModifier, velocityModifier);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("pull"), this::getPullModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxBowItemWrapper(stack, this);
    }

    public float getPullModelProperty(ItemStack stack, World world, LivingEntity entity) {
        if (entity == null || !entity.func_184607_cu().equals(stack)) {
            return 0.0f;
        }
        return MathHelper.clamp((float)((float)entity.func_184612_cw() / 20.0f), (float)0.0f, (float)1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasEnergy(stack, this.isEmpowered(stack))) {
            return super.func_77659_a(world, player, hand);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxBowItemWrapper
    extends EnergyContainerItemWrapper
    implements IArcheryBowItem {
        private final LazyOptional<IArcheryBowItem> holder;
        private final float accuracyModifier;
        private final float damageModifier;
        private final float velocityModifier;
        protected final int simulateTicks = 100;
        final ItemStack bowItem;

        FluxBowItemWrapper(ItemStack bowItemContainer, FluxBowItem item) {
            super(bowItemContainer, (IEnergyContainerItem)item, item.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
            this.simulateTicks = 100;
            this.bowItem = bowItemContainer;
            this.accuracyModifier = MathHelper.clamp((float)item.accuracyModifier, (float)0.1f, (float)10.0f);
            this.damageModifier = MathHelper.clamp((float)item.damageModifier, (float)0.1f, (float)10.0f);
            this.velocityModifier = MathHelper.clamp((float)item.velocityModifier, (float)0.1f, (float)10.0f);
        }

        public float getAccuracyModifier(PlayerEntity shooter) {
            int duration;
            if (FluxBowItem.this.isEmpowered(this.bowItem) && (duration = shooter.func_184612_cw()) > 20) {
                return Math.max(this.accuracyModifier * 20.0f / (float)duration, 0.01f);
            }
            return this.accuracyModifier;
        }

        public float getDamageModifier(PlayerEntity shooter) {
            return this.damageModifier;
        }

        public float getVelocityModifier(PlayerEntity shooter) {
            return this.velocityModifier;
        }

        public void onArrowLoosed(PlayerEntity shooter) {
            FluxBowItem.this.useEnergy(this.bowItem, FluxBowItem.this.isEmpowered(this.bowItem), shooter.field_71075_bZ.field_75098_d);
        }

        public boolean fireArrow(ItemStack arrow, PlayerEntity shooter, int charge, World world) {
            if (FluxBowItem.this.isEmpowered(this.bowItem) && FluxBowItem.this.hasEnergy(this.bowItem, true)) {
                return this.fireInstantArrow(this.bowItem, arrow, shooter, charge, world);
            }
            return ArcheryHelper.fireArrow((ItemStack)this.bowItem, (ItemStack)arrow, (PlayerEntity)shooter, (int)charge, (World)world);
        }

        public boolean fireInstantArrow(ItemStack bow, ItemStack ammo, PlayerEntity shooter, int charge, World world) {
            boolean infinite;
            IArcheryBowItem bowCap = (IArcheryBowItem)bow.getCapability(CapabilityArchery.BOW_ITEM_CAPABILITY).orElse((Object)new ArcheryBowItemWrapper(bow));
            IArcheryAmmoItem ammoCap = (IArcheryAmmoItem)ammo.getCapability(CapabilityArchery.AMMO_ITEM_CAPABILITY).orElse((Object)new ArcheryAmmoItemWrapper(ammo));
            boolean bl = infinite = shooter.field_71075_bZ.field_75098_d || ammoCap.isInfinite(bow, shooter) || ArcheryHelper.isArrow((ItemStack)ammo) && ((ArrowItem)ammo.func_77973_b()).isInfinite(ammo, bow, shooter) || ammo.func_190926_b() && Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185312_x, (ItemStack)bow) > 0;
            if (!ammo.func_190926_b() || infinite) {
                if (ammo.func_190926_b()) {
                    ammo = new ItemStack((IItemProvider)Items.field_151032_g);
                }
                float arrowVelocity = BowItem.func_185059_b((int)charge);
                float accuracyMod = bowCap.getAccuracyModifier(shooter);
                float damageMod = bowCap.getDamageModifier(shooter);
                float velocityMod = bowCap.getVelocityModifier(shooter);
                if (arrowVelocity >= 0.1f) {
                    if (Utils.isServerWorld((World)world)) {
                        int encVolley = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.VOLLEY, (ItemStack)bow);
                        int encTrueshot = Utils.getItemEnchantmentLevel((Enchantment)EnsorcReferences.TRUESHOT, (ItemStack)bow);
                        int encPunch = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185310_v, (ItemStack)bow);
                        int encPower = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185309_u, (ItemStack)bow);
                        int encFlame = Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_185311_w, (ItemStack)bow);
                        if (encTrueshot > 0) {
                            accuracyMod *= 1.5f / (float)(1 + encTrueshot);
                            damageMod *= 1.0f + 0.25f * (float)encTrueshot;
                            arrowVelocity = MathHelper.clamp((float)0.1f, (float)(arrowVelocity + 0.05f * (float)encTrueshot), (float)1.75f);
                        }
                        int numArrows = encVolley > 0 ? 3 : 1;
                        float volleyPitch = encVolley > 0 ? MathHelper.clamp((float)(90.0f + shooter.field_70125_A / (float)encVolley), (float)0.0f, (float)5.0f) : 0.0f;
                        BowItem bowItem = bow.func_77973_b() instanceof BowItem ? (BowItem)bow.func_77973_b() : null;
                        for (int shot = 0; shot < numArrows; ++shot) {
                            AbstractArrowEntity arrow = ArcheryHelper.createArrow((World)world, (ItemStack)ammo, (PlayerEntity)shooter);
                            if (bowItem != null) {
                                arrow = bowItem.customArrow(arrow);
                            }
                            arrow.func_234612_a_((Entity)shooter, shooter.field_70125_A - volleyPitch * (float)shot, shooter.field_70177_z, 0.0f, arrowVelocity * 3.0f * velocityMod, accuracyMod);
                            arrow.func_70239_b(arrow.func_70242_d() * (double)damageMod);
                            if (arrowVelocity >= 1.0f) {
                                arrow.func_70243_d(true);
                            }
                            if (encTrueshot > 0) {
                                arrow.func_213872_b((byte)encTrueshot);
                            }
                            if (encPower > 0 && arrow.func_70242_d() > 0.0) {
                                arrow.func_70239_b(arrow.func_70242_d() + (double)encPower * 0.5 + 0.5);
                            }
                            if (encPunch > 0) {
                                arrow.func_70240_a(encPunch);
                            }
                            if (encFlame > 0) {
                                arrow.func_70015_d(100);
                            }
                            if (infinite || shot > 0) {
                                arrow.field_70251_a = AbstractArrowEntity.PickupStatus.CREATIVE_ONLY;
                            }
                            this.simulateArrow(arrow, world, 100);
                            if (!arrow.func_70089_S()) continue;
                            world.func_217376_c((Entity)arrow);
                        }
                        bowCap.onArrowLoosed(shooter);
                    }
                    world.func_184148_a(null, shooter.func_226277_ct_(), shooter.func_226278_cu_(), shooter.func_226281_cx_(), SoundEvents.field_187737_v, SoundCategory.PLAYERS, 1.0f, 1.0f / (world.field_73012_v.nextFloat() * 0.4f + 1.2f) + arrowVelocity * 0.5f);
                    if (!infinite && !shooter.field_71075_bZ.field_75098_d) {
                        ammoCap.onArrowLoosed(shooter);
                        if (ammo.func_190926_b()) {
                            shooter.field_71071_by.func_184437_d(ammo);
                        }
                    }
                    shooter.func_71029_a(Stats.field_75929_E.func_199076_b((Object)bow.func_77973_b()));
                }
                return true;
            }
            return false;
        }

        public void simulateArrow(AbstractArrowEntity arrow, World world, int maxTicks) {
            for (int i = 0; i < maxTicks && arrow.func_70089_S() && !arrow.func_233570_aj_() && arrow.field_70252_j <= 1; ++i) {
                arrow.func_70071_h_();
                Vector3d velocity = arrow.func_213322_ci();
                if (!world.func_201670_d()) {
                    Vector3d prevPos = velocity.func_186678_a(-0.5).func_178787_e(arrow.func_213303_ch());
                    ((ServerWorld)world).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, prevPos.func_82615_a(), prevPos.func_82617_b(), prevPos.func_82616_c(), 1, 0.0, 0.0, 0.0, 0.0);
                    ((ServerWorld)world).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, arrow.func_226277_ct_(), arrow.func_226278_cu_(), arrow.func_226281_cx_(), 1, 0.0, 0.0, 0.0, 0.0);
                }
                if (velocity.func_189985_c() < (double)0.02f) break;
            }
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityArchery.BOW_ITEM_CAPABILITY) {
                return CapabilityArchery.BOW_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

