/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.impl.CrossbowItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.ArcheryHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxCrossbowItem
extends CrossbowItemCoFH
implements IMultiModeFluxItem {
    protected int repeatStartDelay = 20;
    protected int maxRepeats;
    protected int maxCooldown = 200;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;
    protected int repeats = 0;
    protected int cooldown = 0;

    public FluxCrossbowItem(int enchantability, float accuracyModifier, float damageModifier, float velocityModifier, int maxRepeats, Item.Properties builder, int energy, int xfer) {
        super(enchantability, accuracyModifier, damageModifier, velocityModifier, builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.maxRepeats = maxRepeats;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (!this.getLoadedAmmo(stack).func_190926_b()) {
            tooltip.add((ITextComponent)new TranslationTextComponent("info.cofh.crossbow_loaded").func_240702_b_(" ").func_230529_a_(this.getLoadedAmmo(stack).func_151000_E()));
        }
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    public float getPullModelProperty(ItemStack stack, World world, LivingEntity entity) {
        if (entity == null || !entity.func_184607_cu().equals(stack)) {
            return 0.0f;
        }
        int totalDuration = this.func_77626_a(stack);
        int duration = totalDuration - entity.func_184605_cv();
        if (this.isEmpowered(stack)) {
            totalDuration = this.getRepeatInterval(stack);
            if ((duration -= this.getRepeatStartDelay(stack)) <= 0) {
                return 0.0f;
            }
            return MathHelper.func_76131_a((float)((float)(duration % totalDuration) / (float)totalDuration), (float)0.0f, (float)1.0f);
        }
        return MathHelper.func_76131_a((float)((float)duration / (float)totalDuration), (float)0.0f, (float)1.0f);
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (this.hasEnergy(stack, false)) {
            if (!this.isEmpowered(stack) && FluxCrossbowItem.func_220012_d((ItemStack)stack)) {
                FluxCrossbowItem.func_220011_a((ItemStack)stack, (boolean)this.shootLoadedAmmo(world, (LivingEntity)player, hand, stack));
            } else if (!ArcheryHelper.findAmmo((PlayerEntity)player, (ItemStack)stack).func_190926_b() || player.field_71075_bZ.field_75098_d) {
                this.repeats = 0;
                player.func_184598_c(hand);
            }
            return ActionResult.func_226249_b_((Object)stack);
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int durationRemaining) {
        if (!world.func_201670_d() && this.hasEnergy(stack, false)) {
            int totalDuration = this.func_77626_a(stack);
            int duration = totalDuration - durationRemaining;
            if (this.isEmpowered(stack)) {
                if (this.repeats >= this.maxRepeats) {
                    return;
                }
                ++this.cooldown;
                totalDuration = this.getRepeatInterval(stack);
                if ((duration -= this.getRepeatStartDelay(stack) + totalDuration * this.repeats) >= totalDuration - 2 && !this.isLoaded(stack)) {
                    if ((this.hasEnergy(stack, false) || Utils.isCreativePlayer((Entity)living)) && this.loadAmmo(living, stack)) {
                        this.useEnergy(stack, false, (Entity)living);
                    } else {
                        living.func_184597_cx();
                        return;
                    }
                }
                if (duration >= totalDuration) {
                    if (this.shootLoadedAmmo(world, living, living.func_184600_cs(), stack) || ++this.repeats >= this.maxRepeats) {
                        living.func_184597_cx();
                    }
                    return;
                }
            }
            if (duration == totalDuration / 4) {
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), this.func_220025_a(Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_222193_H, (ItemStack)stack)), SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
            if (duration == totalDuration / 2 + 1) {
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_219611_bC, SoundCategory.PLAYERS, 0.5f, 1.0f);
            }
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int durationRemaining) {
        if (!world.func_201670_d()) {
            if (this.isEmpowered(stack)) {
                this.repeats = this.maxRepeats + 1;
                this.startCooldown(living, stack, this.func_77626_a(stack) - durationRemaining);
            } else if (durationRemaining < 0 && !FluxCrossbowItem.func_220012_d((ItemStack)stack) && this.loadAmmo(living, stack)) {
                FluxCrossbowItem.func_220011_a((ItemStack)stack, (boolean)true);
                world.func_184148_a(null, living.func_226277_ct_(), living.func_226278_cu_(), living.func_226281_cx_(), SoundEvents.field_219610_bB, living instanceof PlayerEntity ? SoundCategory.PLAYERS : SoundCategory.HOSTILE, 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.5f + 1.0f) + 0.2f);
            }
        }
    }

    public boolean onDroppedByPlayer(ItemStack stack, PlayerEntity player) {
        this.startCooldown((LivingEntity)player, stack, this.func_77626_a(stack) - player.func_184605_cv());
        return true;
    }

    public int getRepeatInterval(ItemStack stack) {
        return 14 - 2 * MathHelper.func_76125_a((int)Utils.getItemEnchantmentLevel((Enchantment)Enchantments.field_222193_H, (ItemStack)stack), (int)0, (int)3);
    }

    public int getRepeatStartDelay(ItemStack stack) {
        return this.repeatStartDelay;
    }

    public void startCooldown(LivingEntity entity, ItemStack stack, int amount) {
        if (!entity.field_70170_p.func_201670_d() && this.isEmpowered(stack) && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (amount >= this.getRepeatStartDelay(stack) + this.getRepeatInterval(stack)) {
                player.func_184811_cZ().func_185145_a((Item)this, Math.min(amount, this.maxCooldown));
                this.cooldown = 0;
            }
        }
    }

    public void startCooldown(LivingEntity entity, ItemStack stack) {
        this.startCooldown(entity, stack, this.cooldown);
    }

    public void onCrossbowShot(PlayerEntity shooter, Hand hand, ItemStack crossbow, int damage) {
        this.useEnergy(crossbow, Math.min(this.getEnergyPerUse(false) * damage, this.getEnergyStored(crossbow)), shooter.field_71075_bZ.field_75098_d);
        if (shooter instanceof ServerPlayerEntity) {
            if (!shooter.field_70170_p.func_201670_d()) {
                CriteriaTriggers.field_215099_F.func_215111_a((ServerPlayerEntity)shooter, crossbow);
            }
            shooter.func_71029_a(Stats.field_75929_E.func_199076_b((Object)crossbow.func_77973_b()));
        }
    }

    public boolean isLoaded(ItemStack crossbow) {
        return !this.getLoadedAmmo(crossbow).func_190926_b();
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    @Override
    public void onModeChange(PlayerEntity player, ItemStack stack) {
        if (player.func_184605_cv() < 0) {
            this.setMode(stack, this.isEmpowered(stack) ? 0 : 1);
            player.func_184597_cx();
            this.setMode(stack, this.isEmpowered(stack) ? 0 : 1);
        }
        if (this.isEmpowered(stack)) {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
            FluxCrossbowItem.func_220011_a((ItemStack)stack, (boolean)true);
        } else {
            player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
            FluxCrossbowItem.func_220011_a((ItemStack)stack, (boolean)this.isLoaded(stack));
        }
    }
}

