/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.util.ProxyUtils;
import cofh.lib.item.ICoFHItem;
import cofh.lib.item.IMultiModeItem;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.FluxElytraItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxElytraControllerItem
extends Item
implements ICoFHItem,
IMultiModeItem {
    public FluxElytraControllerItem(Item.Properties builder) {
        super(builder);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), (stack, world, entity) -> this.isEmpowered(stack) ? 1.0f : 0.0f);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.isEmpowered(stack)) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.1").func_240699_a_(TextFormatting.RED));
        } else {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.redstone_arsenal.mode.0").func_240699_a_(TextFormatting.GRAY));
        }
        this.addIncrementModeChangeTooltip(stack, worldIn, tooltip, flagIn);
    }

    public boolean isEmpowered(ItemStack stack) {
        return this.getMode(stack) > 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        if (chest.func_77973_b() instanceof FluxElytraItem) {
            FluxElytraItem elytra = (FluxElytraItem)chest.func_77973_b();
            elytra.setMode(chest, this.getMode(stack));
            if (elytra.boost(chest, (LivingEntity)player)) {
                return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
            }
        }
        return ActionResult.func_226251_d_((Object)stack);
    }

    public void onModeChange(PlayerEntity player, ItemStack stack) {
        ItemStack chest = player.func_184582_a(EquipmentSlotType.CHEST);
        if (chest.func_77973_b() instanceof FluxElytraItem) {
            ((FluxElytraItem)chest.func_77973_b()).setMode(chest, this.getMode(stack));
            if (this.isEmpowered(stack)) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187754_de, SoundCategory.PLAYERS, 0.4f, 1.0f);
            } else {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 0.2f, 0.6f);
            }
        } else {
            this.setMode(stack, this.isEmpowered(stack) ? 0 : 1);
        }
    }
}

