/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.FluxArmorItem;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IArmorMaterial;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;

public class FluxElytraItem
extends FluxArmorItem
implements IMultiModeFluxItem {
    public float propelSpeed = 0.85f;
    public float brakeRate = 0.95f;
    public int boostTime = 32;
    public int energyUseInterval = 8;
    protected int propelTime = 0;

    public FluxElytraItem(IArmorMaterial material, EquipmentSlotType slot, Item.Properties builder, int maxEnergy, int maxTransfer) {
        super(material, slot, builder, maxEnergy, maxTransfer);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new EnergyContainerItemWrapper(stack, (IEnergyContainerItem)this, this.getEnergyCapability());
    }

    public boolean canElytraFly(ItemStack stack, LivingEntity entity) {
        return this.hasEnergy(stack, false);
    }

    public boolean elytraFlightTick(ItemStack stack, LivingEntity entity, int flightTicks) {
        boolean isCreative = Utils.isCreativePlayer((Entity)entity);
        boolean shouldExtract = flightTicks % this.energyUseInterval == 0 && !isCreative;
        if (!this.useEnergy(stack, false, !shouldExtract)) {
            return false;
        }
        if (entity.func_225608_bj_() && this.useEnergy(stack, true, !shouldExtract)) {
            this.propelTime = 0;
            this.brake(entity);
        } else if (this.propelTime > 0) {
            this.propel(entity);
            --this.propelTime;
        } else if (this.isEmpowered(stack) && this.useEnergy(stack, true, !shouldExtract)) {
            this.propel(entity);
        }
        return true;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (!world.func_201670_d() && entity instanceof LivingEntity && !((LivingEntity)entity).func_184613_cA()) {
            this.propelTime = 0;
        }
    }

    public boolean boost(ItemStack stack, LivingEntity entity, int time) {
        boolean isCreative;
        if (!entity.func_184582_a(EquipmentSlotType.CHEST).canElytraFly(entity)) {
            return false;
        }
        boolean isPlayer = entity instanceof PlayerEntity;
        boolean bl = isCreative = isPlayer && ((PlayerEntity)entity).field_71075_bZ.field_75098_d;
        if (!this.useEnergy(stack, this.getEnergyPerUse(true) * time / this.energyUseInterval, isCreative)) {
            return false;
        }
        if (!entity.func_184613_cA() && isPlayer) {
            ((PlayerEntity)entity).func_226567_ej_();
        }
        this.propel(entity, this.propelSpeed);
        this.propelTime = time;
        return true;
    }

    public boolean boost(ItemStack stack, LivingEntity entity) {
        return this.boost(stack, entity, this.boostTime);
    }

    public void propel(LivingEntity entity, double speed) {
        if (entity.func_184613_cA()) {
            Vector3d look = entity.func_70040_Z();
            Vector3d velocity = entity.func_213322_ci();
            entity.func_213317_d(velocity.func_72441_c(look.field_72450_a * speed - velocity.field_72450_a * 0.5, look.field_72448_b * speed - velocity.field_72448_b * 0.5, look.field_72449_c * speed - velocity.field_72449_c * 0.5));
            if (entity.field_70170_p.func_201670_d()) {
                entity.field_70170_p.func_195594_a((IParticleData)RedstoneParticleData.field_197564_a, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void propel(LivingEntity entity) {
        this.propel(entity, this.propelSpeed);
    }

    public void brake(LivingEntity entity, double rate) {
        if (entity.func_184613_cA()) {
            Vector3d velocity = entity.func_213322_ci();
            double horzBrake = velocity.func_82615_a() * velocity.func_82615_a() + velocity.func_82616_c() * velocity.func_82616_c() > 0.16 ? rate : 1.0;
            double vertBrake = velocity.func_82617_b() * velocity.func_82617_b() > 0.2 ? rate : 1.0;
            entity.func_213317_d(velocity.func_216372_d(horzBrake, vertBrake, horzBrake));
        }
    }

    public void brake(LivingEntity entity) {
        this.brake(entity, this.brakeRate);
    }
}

