/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.IAreaEffect;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.impl.ExcavatorItem;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AreaEffectHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxExcavatorItem
extends ExcavatorItem
implements IMultiModeFluxItem {
    protected final float damage = this.func_234675_d_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxExcavatorItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxExcavatorItemWrapper(stack, this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        World world = context.func_195991_k();
        BlockPos clickPos = context.func_195995_a();
        ItemStack tool = context.func_195996_i();
        BlockState state = world.func_180495_p(clickPos);
        PlayerEntity player = context.func_195999_j();
        if (player == null || !player.func_175151_a(clickPos, context.func_196000_l(), tool)) {
            return ActionResultType.PASS;
        }
        ImmutableList blocks = AreaEffectHelper.getPlaceableBlocksRadius((ItemStack)tool, (BlockPos)clickPos, (PlayerEntity)player, (int)(1 + this.getMode(tool)));
        if (blocks.size() < 1) {
            return ActionResultType.FAIL;
        }
        if (!world.func_201670_d()) {
            BlockItemUseContext blockContext = new BlockItemUseContext(context);
            BlockPos playerPos = player.func_233580_cy_();
            BlockPos eyePos = new BlockPos(player.func_174824_e(1.0f));
            if (player.field_71075_bZ.field_75098_d) {
                for (BlockPos pos : blocks) {
                    BlockPos fillPos = pos.func_177972_a(context.func_196000_l());
                    if (!world.func_180495_p(fillPos).func_196953_a(blockContext) || fillPos.equals((Object)playerPos) || fillPos.equals((Object)eyePos)) continue;
                    world.func_180501_a(fillPos, world.func_180495_p(pos).func_177230_c().func_176223_P(), 2);
                }
            } else {
                HashMap sorted = new HashMap();
                for (BlockPos pos : blocks) {
                    BlockPos fillPos = pos.func_177972_a(context.func_196000_l());
                    if (!world.func_180495_p(fillPos).func_196953_a(blockContext) || fillPos.equals((Object)playerPos) || fillPos.equals((Object)eyePos)) continue;
                    Block block = world.func_180495_p(pos).func_177230_c();
                    sorted.putIfAbsent(block, new ArrayList());
                    ((List)sorted.get(block)).add(fillPos);
                }
                NonNullList inventory = player.field_71071_by.field_70462_a;
                block2: for (Block block : sorted.keySet()) {
                    int slot = -1;
                    if (this.hasEnergy(context.func_195996_i(), false)) {
                        List validItems = Block.func_220070_a((BlockState)block.func_176223_P(), (ServerWorld)((ServerWorld)world), (BlockPos)((BlockPos)((List)sorted.get(block)).get(0)), null).stream().map(ItemStack::func_77973_b).filter(i -> i instanceof BlockItem).collect(Collectors.toList());
                        Predicate<ItemStack> matches = stack -> stack.func_77973_b() instanceof BlockItem && (stack.func_77973_b().equals(block.func_199767_j()) || validItems.contains(stack.func_77973_b()));
                        for (BlockPos pos : (List)sorted.get(block)) {
                            if ((slot < 0 || ((ItemStack)inventory.get(slot)).func_190926_b()) && (slot = FluxExcavatorItem.findFirstInventory((NonNullList<ItemStack>)inventory, matches, slot + 1)) < 0 || !this.useEnergy(context.func_195996_i(), false, false)) continue block2;
                            if (!world.func_180501_a(pos, ((BlockItem)((ItemStack)inventory.get(slot)).func_77973_b()).func_179223_d().func_176223_P(), 2)) continue;
                            ((ItemStack)inventory.get(slot)).func_190918_g(1);
                        }
                        continue;
                    }
                    break;
                }
            }
        } else {
            world.func_184134_a((double)clickPos.func_177958_n() + 0.5, (double)clickPos.func_177956_o() + 0.5, (double)clickPos.func_177952_p() + 0.5, state.func_215695_r().func_185841_e(), SoundCategory.BLOCKS, 1.0f, 1.0f, false);
        }
        return ActionResultType.func_233537_a_((boolean)world.func_201670_d());
    }

    public static int findFirstInventory(NonNullList<ItemStack> inventory, Predicate<ItemStack> filter, int start) {
        for (int i = start; i < inventory.size(); ++i) {
            ItemStack stack = (ItemStack)inventory.get(i);
            if (stack.func_190926_b() || !filter.test(stack)) continue;
            return i;
        }
        return -1;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.field_77864_a : 1.0f;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) ? this.getEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxExcavatorItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffect {
        private final LazyOptional<IAreaEffect> holder;

        FluxExcavatorItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, PlayerEntity player) {
            return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (PlayerEntity)player, (int)(1 + FluxExcavatorItem.this.getMode(this.container)));
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

