/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.impl.FishingRodItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FishingBobberEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.stats.Stats;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxFishingRodItem
extends FishingRodItemCoFH
implements IMultiModeFluxItem {
    protected double reelSpeed = 0.2;
    protected int reelEnergyUseInterval = 8;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxFishingRodItem(int enchantability, int luckModifier, int speedModifier, Item.Properties builder, int energy, int xfer) {
        super(builder);
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        this.setParams(enchantability, luckModifier, speedModifier);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("cast"), (stack, world, entity) -> entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71104_cf != null ? 1.0f : 0.0f);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.field_71104_cf != null) {
            if (this.isEmpowered(stack) && player.field_71104_cf.func_234607_k_() != null) {
                if (player.func_225608_bj_()) {
                    player.field_71104_cf.func_70106_y();
                } else {
                    player.func_184598_c(hand);
                }
            } else {
                player.field_71104_cf.func_146034_e(stack);
                this.useEnergy(stack, false, player.field_71075_bZ.field_75098_d);
                world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_193780_J, SoundCategory.NEUTRAL, 1.0f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            }
        } else if (this.hasEnergy(stack, false)) {
            world.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), SoundEvents.field_187612_G, SoundCategory.NEUTRAL, 0.5f, 0.4f / (field_77697_d.nextFloat() * 0.4f + 0.8f));
            if (!world.field_72995_K) {
                int luck = EnchantmentHelper.func_191529_b((ItemStack)stack) + this.luckModifier;
                int speed = EnchantmentHelper.func_191528_c((ItemStack)stack) + this.speedModifier;
                world.func_217376_c((Entity)new FishingBobberEntity(player, world, luck, speed));
            }
            player.func_71029_a(Stats.field_75929_E.func_199076_b((Object)this));
        } else {
            return ActionResult.func_226251_d_((Object)stack);
        }
        return ActionResult.func_233538_a_((Object)stack, (boolean)world.func_201670_d());
    }

    public void func_219972_a(World world, LivingEntity living, ItemStack stack, int useDuration) {
        if (living instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)living;
            if (player.field_71104_cf != null && player.field_71104_cf.func_234607_k_() != null && this.isEmpowered(stack)) {
                if (living.func_225608_bj_()) {
                    player.field_71104_cf.func_70106_y();
                } else if (this.useEnergy(stack, true, useDuration % this.reelEnergyUseInterval != 0 || player.field_71075_bZ.field_75098_d)) {
                    this.reelIn(stack, player.field_71104_cf);
                    return;
                }
            }
        }
        living.func_184597_cx();
    }

    public void reelIn(ItemStack stack, FishingBobberEntity bobber) {
        Entity owner = bobber.func_234616_v_();
        if (!bobber.field_70170_p.field_72995_K && owner != null) {
            if (bobber.func_234607_k_() != null) {
                Vector3d relPos = owner.func_213303_ch().func_178787_e(owner.func_70040_Z()).func_178788_d(bobber.func_213303_ch()).func_72432_b().func_186678_a(this.reelSpeed);
                bobber.func_234607_k_().func_70024_g(relPos.func_82615_a(), relPos.func_82617_b(), relPos.func_82616_c());
                if (relPos.func_82617_b() > 0.0) {
                    bobber.func_234607_k_().field_70143_R = 0.0f;
                }
                return;
            }
            bobber.func_70106_y();
        }
    }

    public void func_77615_a(ItemStack stack, World world, LivingEntity living, int useDuration) {
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.BOW;
    }

    public int func_77626_a(ItemStack p_77626_1_) {
        return 72000;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (attacker instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)attacker;
            this.useEnergy(stack, false, player.field_71075_bZ.field_75098_d);
            if (this.isEmpowered(stack) && player.field_71104_cf != null) {
                player.field_71104_cf.func_70106_y();
            }
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

