/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.capability.CapabilityAreaEffect;
import cofh.lib.capability.IAreaEffect;
import cofh.lib.energy.EnergyContainerItemWrapper;
import cofh.lib.energy.IEnergyContainerItem;
import cofh.lib.item.impl.HammerItem;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.AreaEffectHelper;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.entity.ShockwaveEntity;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;

public class FluxHammerItem
extends HammerItem
implements IMultiModeFluxItem {
    protected final float damage = this.func_234675_d_();
    protected final float attackSpeed;
    public float knockbackMod = 1.0f;
    public int slamCooldown = 160;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxHammerItem(IItemTier tier, float attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    @Override
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundNBT nbt) {
        return new FluxHammerItemWrapper(stack, this);
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        PlayerEntity player = context.func_195999_j();
        ItemStack stack = context.func_195996_i();
        int energy = this.getEnergyPerUse(true) * 2;
        if (player == null || !player.func_233570_aj_() || !this.isEmpowered(stack) || !this.hasEnergy(stack, energy) && !player.field_71075_bZ.field_75098_d) {
            return ActionResultType.FAIL;
        }
        World world = context.func_195991_k();
        BlockPos pos = context.func_195995_a();
        BlockState state = world.func_180495_p(pos);
        if (!world.func_201670_d() && world.func_217376_c((Entity)new ShockwaveEntity(world, (LivingEntity)player, Vector3d.func_237489_a_((Vector3i)pos), player.field_70177_z))) {
            this.useEnergy(stack, energy, player.field_71075_bZ.field_75098_d);
            player.func_184811_cZ().func_185145_a((Item)this, this.getSlamCooldown(stack));
        }
        world.func_184133_a(player, pos, state.getSoundType((IWorldReader)world, pos, (Entity)player).func_185845_c(), SoundCategory.BLOCKS, 1.0f, 1.0f);
        return ActionResultType.SUCCESS;
    }

    protected int getSlamCooldown(ItemStack stack) {
        return this.slamCooldown;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack, false) && !this.isEmpowered(stack) ? this.field_77864_a : 1.0f;
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) ? this.getEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.useEnergy(stack, this.isEmpowered(stack), (Entity)attacker) && this.isEmpowered(stack)) {
            attacker.func_195064_c(new EffectInstance(Effects.field_76424_c, 40, 0));
            if (attacker.func_70644_a(Effects.field_76420_g)) {
                attacker.func_195064_c(new EffectInstance(Effects.field_76420_g, attacker.func_70660_b(Effects.field_76420_g).func_76459_b() + 10, 0));
            }
            attacker.func_70031_b(true);
        }
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233824_g_, (Object)new AttributeModifier(Constants.UUID_TOOL_KNOCKBACK, "Tool modifier", (double)this.getKnockbackModifier(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? (this.isEmpowered(stack) && this.hasEnergy(stack, true) ? this.damage + 2.0f : this.damage) : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.hasEnergy(stack, false) && this.isEmpowered(stack) && this.hasEnergy(stack, true) ? this.attackSpeed + 0.8f : this.attackSpeed;
    }

    protected float getKnockbackModifier(ItemStack stack) {
        return this.knockbackMod;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }

    protected class FluxHammerItemWrapper
    extends EnergyContainerItemWrapper
    implements IAreaEffect {
        private final LazyOptional<IAreaEffect> holder;

        FluxHammerItemWrapper(ItemStack containerIn, IEnergyContainerItem itemIn) {
            super(containerIn, itemIn, itemIn.getEnergyCapability());
            this.holder = LazyOptional.of(() -> this);
        }

        public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, PlayerEntity player) {
            return AreaEffectHelper.getBreakableBlocksRadius((ItemStack)this.container, (BlockPos)pos, (PlayerEntity)player, (int)1);
        }

        @Nonnull
        public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
            if (cap == CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY) {
                return CapabilityAreaEffect.AREA_EFFECT_ITEM_CAPABILITY.orEmpty(cap, this.holder);
            }
            return super.getCapability(cap, side);
        }
    }
}

