/*
 * Decompiled with CFR 0.152.
 */
package cofh.redstonearsenal.item;

import cofh.core.init.CoreConfig;
import cofh.core.util.ProxyUtils;
import cofh.lib.item.impl.PickaxeItemCoFH;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.StringHelper;
import cofh.redstonearsenal.init.RSAReferences;
import cofh.redstonearsenal.item.IMultiModeFluxItem;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FluxPickaxeItem
extends PickaxeItemCoFH
implements IMultiModeFluxItem {
    protected final int LOW_LIGHT_THRESHOLD = 5;
    protected final int REMOVE_RADIUS = 10;
    protected final float damage = this.func_234675_d_();
    protected final float attackSpeed;
    protected final int maxEnergy;
    protected final int extract;
    protected final int receive;

    public FluxPickaxeItem(IItemTier tier, int attackDamageIn, float attackSpeedIn, Item.Properties builder, int energy, int xfer) {
        super(tier, attackDamageIn, attackSpeedIn, builder);
        this.attackSpeed = attackSpeedIn;
        this.maxEnergy = energy;
        this.extract = xfer;
        this.receive = xfer;
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("charged"), this::getChargedModelProperty);
        ProxyUtils.registerItemModelProperty((Item)this, (ResourceLocation)new ResourceLocation("empowered"), this::getEmpoweredModelProperty);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (Screen.func_231173_s_() || CoreConfig.alwaysShowDetails) {
            this.tooltipDelegate(stack, worldIn, tooltip, flagIn);
        } else if (CoreConfig.holdShiftForDetails) {
            tooltip.add((ITextComponent)StringHelper.getTextComponent((String)"info.cofh.hold_shift_for_details").func_240699_a_(TextFormatting.GRAY));
        }
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean func_77616_k(ItemStack stack) {
        return this.getItemEnchantability(stack) > 0;
    }

    protected float getEfficiency(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.field_77864_a : 1.0f;
    }

    public boolean canHarvestBlock(ItemStack stack, BlockState state) {
        return this.func_150897_b(state);
    }

    public float func_150893_a(ItemStack stack, BlockState state) {
        return this.getToolTypes(stack).stream().anyMatch(arg_0 -> ((BlockState)state).isToolEffective(arg_0)) ? this.getEfficiency(stack) : 1.0f;
    }

    public boolean func_77644_a(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        this.useEnergy(stack, false, (Entity)attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (Utils.isServerWorld((World)worldIn) && state.func_185887_b((IBlockReader)worldIn, pos) != 0.0f) {
            this.useEnergy(stack, false, (Entity)entityLiving);
        }
        return true;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        HashMultimap multimap = HashMultimap.create();
        if (slot == EquipmentSlotType.MAINHAND) {
            multimap.put((Object)Attributes.field_233823_f_, (Object)new AttributeModifier(field_111210_e, "Tool modifier", (double)this.getAttackDamage(stack), AttributeModifier.Operation.ADDITION));
            multimap.put((Object)Attributes.field_233825_h_, (Object)new AttributeModifier(field_185050_h, "Tool modifier", (double)this.getAttackSpeed(stack), AttributeModifier.Operation.ADDITION));
        }
        return multimap;
    }

    public ActionResultType func_195939_a(ItemUseContext context) {
        ItemStack tool = context.func_195996_i();
        PlayerEntity player = context.func_195999_j();
        if (player != null) {
            World world = context.func_195991_k();
            if (player.func_225608_bj_()) {
                if (this.useEnergy(tool, true, player.field_71075_bZ.field_75098_d)) {
                    int r = 10;
                    int r2 = r * r;
                    for (BlockPos pos : BlockPos.func_218278_a((BlockPos)context.func_195995_a().func_177982_a(-r, -r, -r), (BlockPos)context.func_195995_a().func_177982_a(r, r, r))) {
                        if (!(pos.func_177951_i((Vector3i)context.func_195995_a()) < (double)r2) || !world.func_180495_p(pos).func_177230_c().equals(RSAReferences.FLUX_GLOW_AIR)) continue;
                        this.extinguishAir(world, player, pos, 0.3f);
                    }
                    return ActionResultType.SUCCESS;
                }
            } else {
                BlockPos pos = context.func_195995_a().func_177972_a(context.func_196000_l());
                BlockState state = world.func_180495_p(pos);
                if (state.func_177230_c().equals(RSAReferences.FLUX_GLOW_AIR) && this.useEnergy(tool, false, player.field_71075_bZ.field_75098_d)) {
                    this.extinguishAir(world, player, pos, 0.5f);
                    return ActionResultType.SUCCESS;
                }
                if (state.func_196958_f() && this.useEnergy(tool, true, player.field_71075_bZ.field_75098_d)) {
                    this.igniteAir(world, player, pos, 0.5f);
                    return ActionResultType.SUCCESS;
                }
            }
        }
        return ActionResultType.PASS;
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        BlockPos pos;
        super.func_77663_a(stack, world, entity, itemSlot, isSelected);
        if (!world.func_201670_d() && this.isEmpowered(stack) && world.func_82737_E() % 8L == 0L && world.func_175623_d(pos = entity.func_233580_cy_()) && world.func_226659_b_(pos, world.func_175657_ab()) <= 5 && this.useEnergy(stack, true, entity)) {
            this.igniteAir(world, null, pos, 0.3f);
        }
    }

    public void igniteAir(World world, PlayerEntity player, BlockPos pos, float volume) {
        world.func_184133_a(player, pos, SoundEvents.field_187649_bu, SoundCategory.PLAYERS, volume, 1.0f);
        if (!world.func_201670_d()) {
            ((ServerWorld)world).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4, 0.25, 0.25, 0.25, 0.0);
        }
        world.func_175656_a(pos, RSAReferences.FLUX_GLOW_AIR.func_176223_P());
    }

    public void extinguishAir(World world, PlayerEntity player, BlockPos pos, float volume) {
        world.func_184133_a(player, pos, SoundEvents.field_187646_bt, SoundCategory.PLAYERS, 0.5f, 1.0f);
        if (!world.func_201670_d()) {
            ((ServerWorld)world).func_195598_a((IParticleData)RedstoneParticleData.field_197564_a, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, 4, 0.25, 0.25, 0.25, 0.0);
        }
        world.func_175656_a(pos, Blocks.field_150350_a.func_176223_P());
    }

    protected float getAttackDamage(ItemStack stack) {
        return this.hasEnergy(stack, false) ? this.damage : 0.0f;
    }

    protected float getAttackSpeed(ItemStack stack) {
        return this.attackSpeed;
    }

    public int getExtract(ItemStack container) {
        return this.extract;
    }

    public int getReceive(ItemStack container) {
        return this.receive;
    }

    public int getMaxEnergyStored(ItemStack container) {
        return this.getMaxStored(container, this.maxEnergy);
    }
}

